/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module.png;

import com.mcgath.jhove.module.png.MessageConstants;
import com.mcgath.jhove.module.png.PNGChunk;
import com.mcgath.jhove.module.png.PNGException;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.messages.JhoveMessage;
import edu.harvard.hul.ois.jhove.messages.JhoveMessages;

public class PlteChunk
extends PNGChunk {
    public PlteChunk(int sig, long leng) {
        this.chunkType = sig;
        this.length = leng;
        this.ancillary = false;
    }

    @Override
    public void processChunk(RepInfo info) throws Exception {
        this.processChunkCommon(info);
        boolean chunkOk = true;
        if (this._module.isPlteSeen()) {
            info.setMessage(new ErrorMessage(MessageConstants.PNG_GDM_34));
            chunkOk = false;
        }
        this._module.setPlteSeen(true);
        if (this._module.isIdatSeen()) {
            info.setMessage(new ErrorMessage(MessageConstants.PNG_GDM_35));
            chunkOk = false;
        }
        if (this.length % 3L != 0L) {
            JhoveMessage msg = JhoveMessages.getMessageInstance(MessageConstants.PNG_GDM_36.getId(), String.format(MessageConstants.PNG_GDM_36.getMessage(), this.length));
            info.setMessage(new ErrorMessage(msg));
            chunkOk = false;
        }
        if (!chunkOk) {
            info.setWellFormed(false);
            throw new PNGException(MessageConstants.PNG_GDM_37);
        }
        int i = 0;
        while ((long)i < this.length) {
            this.readUnsignedByte();
            ++i;
        }
    }
}

