/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module.png;

import com.mcgath.jhove.module.png.MessageConstants;
import com.mcgath.jhove.module.png.PNGChunk;
import com.mcgath.jhove.module.png.PNGException;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;

public class SbitChunk
extends PNGChunk {
    public SbitChunk(int sig, long leng) {
        this.chunkType = sig;
        this.length = leng;
        this.ancillary = true;
        this.duplicateAllowed = false;
    }

    @Override
    public void processChunk(RepInfo info) throws Exception {
        this.processChunkCommon(info);
        if (this._module.isPlteSeen() || this._module.isIdatSeen()) {
            ErrorMessage msg = new ErrorMessage(MessageConstants.PNG_GDM_40);
            info.setMessage(msg);
            info.setWellFormed(false);
            throw new PNGException(MessageConstants.PNG_GDM_41);
        }
        if (this.length == 0L || this.length > 4L) {
            ErrorMessage msg = new ErrorMessage(MessageConstants.PNG_GDM_42);
            info.setMessage(msg);
            info.setWellFormed(false);
            throw new PNGException(MessageConstants.PNG_GDM_41);
        }
        int[] sbitVal = new int[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            sbitVal[i] = this.readUnsignedByte();
            ++i;
        }
        Property prop = new Property("Significant bits", PropertyType.INTEGER, PropertyArity.ARRAY, sbitVal);
        this._propList.add(prop);
    }
}

