/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module.png;

import com.mcgath.jhove.module.png.MessageConstants;
import com.mcgath.jhove.module.png.PNGChunk;
import com.mcgath.jhove.module.png.PNGException;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.messages.JhoveMessage;
import edu.harvard.hul.ois.jhove.messages.JhoveMessages;

public class SrgbChunk
extends PNGChunk {
    private static final String[] intents = new String[]{"Perceptual", "Relative colorimetric", "Saturation", "Absolute colorimetric"};

    public SrgbChunk(int sig, long leng) {
        this.chunkType = sig;
        this.length = leng;
        this.ancillary = true;
        this.duplicateAllowed = false;
    }

    @Override
    public void processChunk(RepInfo info) throws Exception {
        this.processChunkCommon(info);
        boolean chunkOk = true;
        int colorIntent = 0;
        if (this._module.isPlteSeen()) {
            info.setMessage(new ErrorMessage(MessageConstants.PNG_GDM_48));
            chunkOk = false;
        } else if (this._module.isIdatSeen()) {
            info.setMessage(new ErrorMessage(MessageConstants.PNG_GDM_49));
            chunkOk = false;
        } else if (this._module.isChunkSeen(1766015824)) {
            info.setMessage(new ErrorMessage(MessageConstants.PNG_GDM_50));
            chunkOk = false;
        } else if (this.length == 0L) {
            info.setMessage(new ErrorMessage(MessageConstants.PNG_GDM_51));
            chunkOk = false;
        } else {
            colorIntent = this.readUnsignedByte();
            if (colorIntent > 3) {
                JhoveMessage msg = JhoveMessages.getMessageInstance(MessageConstants.PNG_GDM_52.getId(), String.format(MessageConstants.PNG_GDM_52.getMessage(), colorIntent));
                info.setMessage(new ErrorMessage(msg));
                chunkOk = false;
            }
        }
        if (!chunkOk) {
            info.setWellFormed(false);
            throw new PNGException(MessageConstants.PNG_GDM_53);
        }
        Property prop = new Property("SRGB rendering intent", PropertyType.STRING, intents[colorIntent]);
        info.setProperty(prop);
        int i = 0;
        while ((long)i < this.length - 1L) {
            this.readUnsignedByte();
            ++i;
        }
    }
}

