/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module.png;

import com.mcgath.jhove.module.png.MessageConstants;
import com.mcgath.jhove.module.png.PNGChunk;
import com.mcgath.jhove.module.png.PNGException;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import java.util.Calendar;
import java.util.TimeZone;

public class TimeChunk
extends PNGChunk {
    public TimeChunk(int sig, long leng) {
        this.chunkType = sig;
        this.length = leng;
        this.ancillary = true;
        this.duplicateAllowed = false;
    }

    @Override
    public void processChunk(RepInfo info) throws Exception {
        this.processChunkCommon(info);
        if (this.length < 7L) {
            ErrorMessage msg = new ErrorMessage(MessageConstants.PNG_GDM_56);
            info.setMessage(msg);
            info.setWellFormed(false);
            throw new PNGException(MessageConstants.PNG_GDM_57);
        }
        int year = this.readUnsignedShort();
        int month = this.readUnsignedByte();
        int day = this.readUnsignedByte();
        int hour = this.readUnsignedByte();
        int minute = this.readUnsignedByte();
        int second = this.readUnsignedByte();
        if (month == 0 || month > 12 || day == 0 || day > 31 || hour > 23 || minute > 59 || second > 60) {
            ErrorMessage msg = new ErrorMessage(MessageConstants.PNG_GDM_58);
            info.setMessage(msg);
            info.setValid(false);
            return;
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(year, month - 1, day, hour, minute, second);
        Property prop = new Property("Time modified", PropertyType.DATE, cal.getTime());
        this._propList.add(prop);
    }
}

