/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module.png;

import com.mcgath.jhove.module.png.MessageConstants;
import com.mcgath.jhove.module.png.PNGChunk;
import com.mcgath.jhove.module.png.PNGException;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.messages.JhoveMessage;
import edu.harvard.hul.ois.jhove.messages.JhoveMessages;

public class TrnsChunk
extends PNGChunk {
    public TrnsChunk(int sig, long leng) {
        this.chunkType = sig;
        this.length = leng;
        this.ancillary = true;
        this.duplicateAllowed = false;
    }

    @Override
    public void processChunk(RepInfo info) throws Exception {
        this.processChunkCommon(info);
        boolean chunkOk = true;
        if (this._module.isIdatSeen()) {
            info.setMessage(new ErrorMessage(MessageConstants.PNG_GDM_59));
            chunkOk = false;
        }
        int colorType = this._module.getColorType();
        int lengthLeft = (int)this.length;
        if (colorType == 0 && this.length < 2L || colorType == 2 && this.length < 6L) {
            info.setMessage(new ErrorMessage(MessageConstants.PNG_GDM_60));
            chunkOk = false;
        }
        if (colorType != 0 && colorType != 2 && colorType != 3) {
            JhoveMessage msg = JhoveMessages.getMessageInstance(MessageConstants.PNG_GDM_61.getId(), String.format(MessageConstants.PNG_GDM_61.getMessage(), colorType));
            info.setMessage(new ErrorMessage(msg));
            chunkOk = false;
        }
        if (!chunkOk) {
            info.setWellFormed(false);
            throw new PNGException(MessageConstants.PNG_GDM_62);
        }
        switch (colorType) {
            case 0: {
                int transGray = this.readUnsignedShort();
                info.setProperty(new Property("Transparent grey value", PropertyType.INTEGER, transGray));
                lengthLeft = (int)this.length - 2;
                break;
            }
            case 2: {
                int transRed = this.readUnsignedShort();
                int transGreen = this.readUnsignedShort();
                int transBlue = this.readUnsignedShort();
                info.setProperty(new Property("Transparent red value", PropertyType.INTEGER, transRed));
                info.setProperty(new Property("Transparent green value", PropertyType.INTEGER, transGreen));
                info.setProperty(new Property("Transparent blue value", PropertyType.INTEGER, transBlue));
                lengthLeft = (int)this.length - 6;
                break;
            }
            case 3: {
                int nTrans = (int)this.length;
                if (nTrans > 256) {
                    nTrans = 256;
                    lengthLeft = (int)this.length - 256;
                } else {
                    lengthLeft = 0;
                }
                int[] alpha = new int[nTrans];
                for (int i = 0; i < nTrans; ++i) {
                    alpha[i] = this.readUnsignedByte();
                }
                info.setProperty(new Property("Alpha for palette index", PropertyType.INTEGER, PropertyArity.ARRAY, alpha));
                break;
            }
        }
        for (int i = 0; i < lengthLeft; ++i) {
            this.readUnsignedByte();
        }
    }
}

