/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.Rational;
import java.awt.color.ICC_Profile;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NisoImageMetadata {
    private static final Logger LOGGER = Logger.getLogger(NisoImageMetadata.class.getCanonicalName());
    private static final String YES = "Yes";
    private static final String NO = "No";
    private static final String TIME_SEP = ":";
    public static final String[] AUTOFOCUS = new String[]{"unidentified", "auto focus used", "auto focus interrupted", "near focused", "soft focus", "manual"};
    public static final String[] BACKLIGHT = new String[]{"front light", "backlight 1", "backlight 2"};
    public static final String[] BYTEORDER = new String[]{"big-endian", "little-endian"};
    public static final String[] CHECKSUM_METHOD = new String[]{"CRC32", "MD5", "SHA-1", "SHA-256"};
    public static final String[] COLORSPACE = new String[]{"white is zero", "black is zero", "RGB", "palette color", "transparency mask", "CMYK", "YCbCr", "CIE L*a*b*", "ICC L*a*b*", "ITU L*a*b*", "CFA", "CIE Log2(L)", "CIE Log2(L)(u',v')", "LinearRaw", "YCCK"};
    public static final int[] COLORSPACE_INDEX = new int[]{0, 1, 2, 3, 4, 5, 6, 8, 9, 10, 32803, 32844, 32845, 34892, 65535};
    public static final String[] COMPRESSION_SCHEME = new String[]{"uncompressed", "CCITT 1D", "CCITT Group 3", "CCITT Group 4", "LZW", "JPEG", "ISO JPEG", "Deflate", "JBIG", "RLE with word alignment", "PackBits", "NeXT 2-bit encoding", "ThunderScan 4-bit encoding", "RasterPadding in CT or MP", "RLE for LW", "RLE for HC", "RLE for BL", "Pixar 10-bit LZW", "Pixar companded 11-bit ZIP encoding", "PKZIP-style Deflate encoding", "Kodak DCS", "SGI 32-bit Log Luminance encoding", "SGI 24-bit Log Luminance encoding", "JPEG 2000", "JPEG2000 Lossy", "JPEG2000 Lossless", "LZMA"};
    public static final int COMPRESSION_JPEG2000_LOSSY = 34713;
    public static final int COMPRESSION_JPEG2000_LOSSLESS = 34714;
    public static final int[] COMPRESSION_SCHEME_INDEX = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 32661, 32771, 32773, 32766, 32809, 32895, 32896, 32897, 32898, 32908, 32909, 32946, 32947, 34676, 34677, 34712, 34713, 34714, 34925};
    public static final String[] DISPLAY_ORIENTATION = new String[]{"portrait", "landscape"};
    public static final String[] EXTRA_SAMPLES = new String[]{"unspecified", "associated alpha", "unassociated alpha", "range or depth"};
    public static final String[] EXPOSURE_PROGRAM = new String[]{"Not defined", " Manual", "Normal program", "Aperture priority", "Shutter priority", "Creative program (biased toward depth of field)", "Action program (biased toward fast shutter speed)", "Portrait mode (for closeup photos with the background out of focus)", "Landscape mode (for landscape photos with the background in focus)"};
    public static final String[] FLASH = new String[]{"No", "Yes"};
    public static final String[] FLASH_20 = new String[]{"Flash did not fire", "Flash fired"};
    public static final String[] FLASH_RETURN = new String[]{"Yes", "No"};
    public static final String[] GRAY_RESPONSE_UNIT_02 = new String[]{"", "tenths of a unit", "hundredths of a unit", "thousandths of a unit", "ten-thousandths of a unit", "hundred-thousandths of a unit"};
    public static final String[] GRAY_RESPONSE_UNIT_20 = new String[]{"Number represents tenths of a unit", "Number represents hundredths of a unit", "Number represents thousandths of a unit", "Number represents ten-thousandths of a unit", "Number represents hundred-thousandths of a unit"};
    public static final String[] EXTRA_SAMPLE_20 = new String[]{"unspecified data", "associated alpha data (with pre-multiplied color)", "unassociated alpha data", "range or depth data"};
    public static final String[] METERING_MODE = new String[]{"unidentified", "average", "center weighted average", "spot", "multispot", "pattern", "partial"};
    public static final String[] ORIENTATION = new String[]{"", "normal", "reflected horiz", "rotated 180 deg", "reflected vert", "left top", "rotated cw 90 deg", "right bottom", "rotated ccw 90 deg", "unknown"};
    public static final String[] PLANAR_CONFIGURATION = new String[]{"", "chunky", "planar"};
    public static final String[] SAMPLING_FREQUENCY_PLANE = new String[]{"", "camera/scanner focal plane", "object plane", "source object plane"};
    public static final String[] SAMPLING_FREQUENCY_UNIT = new String[]{"", "no absolute unit", "inch", "centimeter"};
    public static final String[] SCENE_ILLUMINANT = new String[]{"unidentified", "daylight", "fluorescent", "tungsten lamp", "flash", "standard illuminant A", "standard illuminat B", "standard illuminant C", "D55 illuminant", "D65 illuminant", "D75 illuminant"};
    public static final int[] SCENE_ILLUMINANT_INDEX = new int[]{0, 1, 2, 3, 10, 17, 18, 19, 20, 21, 22};
    public static final String[] SEGMENT_TYPE = new String[]{"strips", "tiles"};
    public static final String[] SENSOR = new String[]{"Undefined", "MonochromeArea", "OneChipColorArea", "TwoChipColorArea", "ThreeChipColorArea", "ColorSequentialArea", "MonochromeLinear", "ColorTriLinear", "ColorSequentialLinear"};
    public static final String[] SOURCE_DIMENSION_UNIT = new String[]{"inches", "mm"};
    public static final String[] YCBCR_POSITIONING = new String[]{"", "centered", "cosited"};
    public static final String[] TARGET_TYPE = new String[]{"external", "internal"};
    public static final int NULL = -1;
    public static final double NILL = -1.0;
    private String _mimeType;
    private String _byteOrder;
    private int _compressionScheme = -1;
    private int _compressionLevel = -1;
    private int _colorSpace = -1;
    private String _profileName;
    private String _profileURL;
    private int[] _yCbCrSubSampling;
    private int _yCbCrPositioning = -1;
    private Rational[] _yCbCrCoefficients;
    private Rational[] _referenceBlackWhite;
    private int _segmentType = -1;
    private long[] _stripOffsets;
    private long _rowsPerStrip = -1L;
    private long[] _stripByteCounts;
    private long _tileWidth = -1L;
    private long _tileLength = -1L;
    private long[] _tileOffsets;
    private long[] _tileByteCounts;
    private int _planarConfiguration = -1;
    private String _imageIdentifier;
    private String _imageIdentifierLocation;
    private long _fileSize = -1L;
    private int _checksumMethod = -1;
    private String _checksumValue;
    private int _orientation = -1;
    private int _displayOrientation = -1;
    private long _xTargetedDisplayAR = -1L;
    private long _yTargetedDisplayAR = -1L;
    private String _preferredPresentation;
    private String _jp2Tiles = null;
    private int _jp2Layers = -1;
    private int _jp2ResolutionLevels = -1;
    private String _sourceType;
    private String _sourceID;
    private String _imageProducer;
    private String _hostComputer;
    private String _os;
    private String _osVersion;
    private String _deviceSource;
    private String _scannerManufacturer = null;
    private String _scannerModelName = null;
    private String _scannerModelNumber = null;
    private String _scannerModelSerialNo = null;
    private String _scanningSoftware;
    private String _scanningSoftwareVersionNo;
    private double _pixelSize = -1.0;
    private double _xPhysScanResolution = -1.0;
    private double _yPhysScanResolution = -1.0;
    private String _digitalCameraManufacturer = null;
    private String _digitalCameraModelName = null;
    private String _digitalCameraModelNumber = null;
    private String _digitalCameraModelSerialNo = null;
    private double _fNumber = -1.0;
    private double _exposureTime = -1.0;
    private int _exposureProgram = -1;
    private String _exifVersion = null;
    private Rational _maxApertureValue = null;
    private Rational _brightness = null;
    private Rational _exposureBias = null;
    private double[] _subjectDistance;
    private int _meteringMode = -1;
    private int _sceneIlluminant = -1;
    private double _colorTemp = -1.0;
    private double _focalLength = -1.0;
    private int _flash = -1;
    private Rational _flashEnergy = null;
    private int _flashReturn = -1;
    private int _backLight = -1;
    private double _exposureIndex = -1.0;
    private int _autoFocus = -1;
    private double _xPrintAspectRatio = -1.0;
    private double _yPrintAspectRatio = -1.0;
    private int _sensor = -1;
    private String _dateTimeCreated;
    private String _methodology;
    private int _samplingFrequencyPlane = -1;
    private int _samplingFrequencyUnit = -1;
    private Rational _xSamplingFrequency = null;
    private Rational _ySamplingFrequency = null;
    private long _imageWidth = -1L;
    private long _imageLength = -1L;
    private double _sourceXDimension = -1.0;
    private int _sourceXDimensionUnit = -1;
    private double _sourceYDimension = -1.0;
    private int _sourceYDimensionUnit = -1;
    private int[] _bitsPerSample;
    private int _samplesPerPixel = -1;
    private int[] _extraSamples;
    private String _colormapReference;
    private int[] _colormapBitCodeValue;
    private int[] _colormapRedValue;
    private int[] _colormapGreenValue;
    private int[] _colormapBlueValue;
    private int[] _grayResponseCurve;
    private int _grayResponseUnit = -1;
    private Rational _whitePointXValue;
    private Rational _whitePointYValue;
    private Rational _primaryChromaticitiesRedX;
    private Rational _primaryChromaticitiesRedY;
    private Rational _primaryChromaticitiesGreenX;
    private Rational _primaryChromaticitiesGreenY;
    private Rational _primaryChromaticitiesBlueX;
    private Rational _primaryChromaticitiesBlueY;
    private int _targetType = -1;
    private String _targetIDManufacturer = null;
    private String _targetIDName = null;
    private String _targetIDNo = null;
    private String _targetIDMedia = null;
    private String _imageData = null;
    private String _performanceData = null;
    private String _profiles = null;
    private String _dateTimeProcessed = null;
    private String _sourceData = null;
    private String _processingAgency = null;
    private String _processingSoftwareName = null;
    private String _processingSoftwareVersion = null;
    private String[] _processingActions = null;
    private Property _viewerData = null;

    public int getAutoFocus() {
        return this._autoFocus;
    }

    public int getBackLight() {
        return this._backLight;
    }

    public int[] getBitsPerSample() {
        return this._bitsPerSample;
    }

    public Rational getBrightness() {
        return this._brightness;
    }

    public String getByteOrder() {
        return this._byteOrder;
    }

    public int getChecksumMethod() {
        return this._checksumMethod;
    }

    public String getChecksumValue() {
        return this._checksumValue;
    }

    public int[] getColormapBitCodeValue() {
        return this._colormapBitCodeValue;
    }

    public int[] getColormapBlueValue() {
        return this._colormapBlueValue;
    }

    public int[] getColormapGreenValue() {
        return this._colormapGreenValue;
    }

    public int[] getColormapRedValue() {
        return this._colormapRedValue;
    }

    public String getColormapReference() {
        return this._colormapReference;
    }

    public int getColorSpace() {
        return this._colorSpace;
    }

    public double getColorTemp() {
        return this._colorTemp;
    }

    public int getCompressionLevel() {
        return this._compressionLevel;
    }

    public int getCompressionScheme() {
        return this._compressionScheme;
    }

    public String getDateTimeCreated() {
        return this._dateTimeCreated;
    }

    public String getDateTimeProcessed() {
        return this._dateTimeProcessed;
    }

    public String getDeviceSource() {
        return this._deviceSource;
    }

    public String getDigitalCameraManufacturer() {
        return this._digitalCameraManufacturer;
    }

    public String getDigitalCameraModelName() {
        return this._digitalCameraModelName;
    }

    public String getDigitalCameraModelNumber() {
        return this._digitalCameraModelNumber;
    }

    public String getDigitalCameraModelSerialNo() {
        return this._digitalCameraModelSerialNo;
    }

    public int getDisplayOrientation() {
        return this._displayOrientation;
    }

    public String getExifVersion() {
        return this._exifVersion;
    }

    public Rational getExposureBias() {
        return this._exposureBias;
    }

    public double getExposureIndex() {
        return this._exposureIndex;
    }

    public int getExposureProgram() {
        return this._exposureProgram;
    }

    public double getExposureTime() {
        return this._exposureTime;
    }

    public int[] getExtraSamples() {
        return this._extraSamples;
    }

    public long getFileSize() {
        return this._fileSize;
    }

    public int getFlash() {
        return this._flash;
    }

    public Rational getFlashEnergy() {
        return this._flashEnergy;
    }

    public int getFlashReturn() {
        return this._flashReturn;
    }

    public double getFNumber() {
        return this._fNumber;
    }

    public double getFocalLength() {
        return this._focalLength;
    }

    public int[] getGrayResponseCurve() {
        return this._grayResponseCurve;
    }

    public int getGrayResponseUnit() {
        return this._grayResponseUnit;
    }

    public String getHostComputer() {
        return this._hostComputer;
    }

    public String getImageData() {
        return this._imageData;
    }

    public String getImageIdentifier() {
        return this._imageIdentifier;
    }

    public String getImageIdentifierLocation() {
        return this._imageIdentifierLocation;
    }

    public long getImageLength() {
        return this._imageLength;
    }

    public String getImageProducer() {
        return this._imageProducer;
    }

    public long getImageWidth() {
        return this._imageWidth;
    }

    public Rational getMaxApertureValue() {
        return this._maxApertureValue;
    }

    public int getMeteringMode() {
        return this._meteringMode;
    }

    public String getMethodology() {
        return this._methodology;
    }

    public String getMimeType() {
        return this._mimeType;
    }

    public int getOrientation() {
        return this._orientation;
    }

    public String getOS() {
        return this._os;
    }

    public String getOSVersion() {
        return this._osVersion;
    }

    public String getPerformanceData() {
        return this._performanceData;
    }

    public double getPixelSize() {
        return this._pixelSize;
    }

    public int getPlanarConfiguration() {
        return this._planarConfiguration;
    }

    public String getPreferredPresentation() {
        return this._preferredPresentation;
    }

    public String getJp2Tiles() {
        return this._jp2Tiles;
    }

    public void setJp2Tiles(String jp2Tiles) {
        this._jp2Tiles = jp2Tiles;
    }

    public int getJp2Layers() {
        return this._jp2Layers;
    }

    public void setJp2Layers(int jp2Layers) {
        this._jp2Layers = jp2Layers;
    }

    public int getJp2ResolutionLevels() {
        return this._jp2ResolutionLevels;
    }

    public void setJp2ResolutionLevels(int jp2ResolutionLevels) {
        this._jp2ResolutionLevels = jp2ResolutionLevels;
    }

    public Rational getPrimaryChromaticitiesBlueX() {
        return this._primaryChromaticitiesBlueX;
    }

    public Rational getPrimaryChromaticitiesBlueY() {
        return this._primaryChromaticitiesBlueY;
    }

    public Rational getPrimaryChromaticitiesGreenX() {
        return this._primaryChromaticitiesGreenX;
    }

    public Rational getPrimaryChromaticitiesGreenY() {
        return this._primaryChromaticitiesGreenY;
    }

    public Rational getPrimaryChromaticitiesRedX() {
        return this._primaryChromaticitiesRedX;
    }

    public Rational getPrimaryChromaticitiesRedY() {
        return this._primaryChromaticitiesRedY;
    }

    public String[] getProcessingActions() {
        return this._processingActions;
    }

    public String getProcessingAgency() {
        return this._processingAgency;
    }

    public String getProcessingSoftwareName() {
        return this._processingSoftwareName;
    }

    public String getProcessingSoftwareVersion() {
        return this._processingSoftwareVersion;
    }

    public String getProfileName() {
        return this._profileName;
    }

    public String getProfiles() {
        return this._profiles;
    }

    public String getProfileURL() {
        return this._profileURL;
    }

    public Rational[] getReferenceBlackWhite() {
        return this._referenceBlackWhite;
    }

    public long getRowsPerStrip() {
        return this._rowsPerStrip;
    }

    public int getSamplesPerPixel() {
        return this._samplesPerPixel;
    }

    public int getSamplingFrequencyPlane() {
        return this._samplingFrequencyPlane;
    }

    public int getSamplingFrequencyUnit() {
        return this._samplingFrequencyUnit;
    }

    public String getScannerManufacturer() {
        return this._scannerManufacturer;
    }

    public String getScannerModelName() {
        return this._scannerModelName;
    }

    public String getScannerModelNumber() {
        return this._scannerModelNumber;
    }

    public String getScannerModelSerialNo() {
        return this._scannerModelSerialNo;
    }

    public String getScanningSoftware() {
        return this._scanningSoftware;
    }

    public String getScanningSoftwareVersionNo() {
        return this._scanningSoftwareVersionNo;
    }

    public int getSceneIlluminant() {
        return this._sceneIlluminant;
    }

    public int getSegmentType() {
        return this._segmentType;
    }

    public int getSensor() {
        return this._sensor;
    }

    public String getSourceData() {
        return this._sourceData;
    }

    public String getSourceID() {
        return this._sourceID;
    }

    public String getSourceType() {
        return this._sourceType;
    }

    public double getSourceXDimension() {
        return this._sourceXDimension;
    }

    public int getSourceXDimensionUnit() {
        return this._sourceXDimensionUnit;
    }

    public double getSourceYDimension() {
        return this._sourceYDimension;
    }

    public int getSourceYDimensionUnit() {
        return this._sourceYDimensionUnit;
    }

    public long[] getStripByteCounts() {
        return this._stripByteCounts;
    }

    public long[] getStripOffsets() {
        return this._stripOffsets;
    }

    public double[] getSubjectDistance() {
        return this._subjectDistance;
    }

    public String getTargetIDManufacturer() {
        return this._targetIDManufacturer;
    }

    public String getTargetIDMedia() {
        return this._targetIDMedia;
    }

    public String getTargetIDName() {
        return this._targetIDName;
    }

    public String getTargetIDNo() {
        return this._targetIDNo;
    }

    public int getTargetType() {
        return this._targetType;
    }

    public long[] getTileByteCounts() {
        return this._tileByteCounts;
    }

    public long getTileLength() {
        return this._tileLength;
    }

    public long[] getTileOffsets() {
        return this._tileOffsets;
    }

    public long getTileWidth() {
        return this._tileWidth;
    }

    public Rational getWhitePointXValue() {
        return this._whitePointXValue;
    }

    public Rational getWhitePointYValue() {
        return this._whitePointYValue;
    }

    public double getXPrintAspectRatio() {
        return this._xPrintAspectRatio;
    }

    public double getXPhysScanResolution() {
        return this._xPhysScanResolution;
    }

    public Rational getXSamplingFrequency() {
        return this._xSamplingFrequency;
    }

    public long getXTargetedDisplayAR() {
        return this._xTargetedDisplayAR;
    }

    public Rational[] getYCbCrCoefficients() {
        return this._yCbCrCoefficients;
    }

    public int getYCbCrPositioning() {
        return this._yCbCrPositioning;
    }

    public int[] getYCbCrSubSampling() {
        return this._yCbCrSubSampling;
    }

    public double getYPhysScanResolution() {
        return this._yPhysScanResolution;
    }

    public double getYPrintAspectRatio() {
        return this._yPrintAspectRatio;
    }

    public Rational getYSamplingFrequency() {
        return this._ySamplingFrequency;
    }

    public long getYTargetedDisplayAR() {
        return this._yTargetedDisplayAR;
    }

    public Property getViewerData() {
        return this._viewerData;
    }

    public void setAutoFocus(int focus) {
        this._autoFocus = focus;
    }

    public void setBackLight(int light) {
        this._backLight = light;
    }

    public void setBitsPerSample(int[] bits) {
        this._bitsPerSample = bits;
    }

    public void setBrightness(Rational brightness) {
        this._brightness = brightness;
    }

    public void setByteOrder(String order) {
        this._byteOrder = order;
    }

    public void setColormapBitCodeValue(int[] value) {
        this._colormapBitCodeValue = value;
    }

    public void setColormapBlueValue(int[] value) {
        this._colormapBlueValue = value;
    }

    public void setColormapGreenValue(int[] value) {
        this._colormapGreenValue = value;
    }

    public void setColormapRedValue(int[] value) {
        this._colormapRedValue = value;
    }

    public void setColormapReference(String reference) {
        this._colormapReference = reference;
    }

    public void setColorSpace(int space) {
        this._colorSpace = space;
    }

    public void setColorTemp(double temp) {
        this._colorTemp = temp;
    }

    public void setCompressionLevel(int level) {
        this._compressionLevel = level;
    }

    public void setCompressionScheme(int scheme) {
        this._compressionScheme = scheme;
    }

    public void setDateTimeCreated(String date) {
        this._dateTimeCreated = NisoImageMetadata.make8601Valid(date);
    }

    public void setDateTimeProcessed(String date) {
        this._dateTimeProcessed = NisoImageMetadata.make8601Valid(date);
    }

    public void setDeviceSource(String source) {
        this._deviceSource = source;
    }

    public void setDigitalCameraManufacturer(String manufacturer) {
        this._digitalCameraManufacturer = manufacturer;
    }

    public void setDigitalCameraModelName(String modelName) {
        this._digitalCameraModelName = modelName;
    }

    public void setDigitalCameraModelNumber(String modelNumber) {
        this._digitalCameraModelNumber = modelNumber;
    }

    public void setDigitalCameraModelSerialNo(String modelSerialNo) {
        this._digitalCameraModelSerialNo = modelSerialNo;
    }

    public void setDisplayOrientation(int orientation) {
        this._displayOrientation = orientation;
    }

    public void setExifVersion(String version) {
        this._exifVersion = version;
    }

    public void setExposureBias(Rational bias) {
        this._exposureBias = bias;
    }

    public void setExposureIndex(double index) {
        this._exposureIndex = index;
    }

    public void setExposureProgram(int program) {
        this._exposureProgram = program;
    }

    public void setExposureTime(double time) {
        this._exposureTime = time;
    }

    public void setExtraSamples(int[] extra) {
        this._extraSamples = extra;
    }

    public void setFileSize(long size) {
        this._fileSize = size;
    }

    public void setFNumber(double f) {
        this._fNumber = f;
    }

    public void setFlashEnergy(Rational energy) {
        this._flashEnergy = energy;
    }

    public void setFlashReturn(int ret) {
        this._flashReturn = ret;
    }

    public void setFlash(int flash) {
        this._flash = flash;
    }

    public void setFocalLength(double length) {
        this._focalLength = length;
    }

    public void setGrayResponseCurve(int[] curve) {
        this._grayResponseCurve = curve;
    }

    public void setGrayResponseUnit(int unit) {
        this._grayResponseUnit = unit;
    }

    public void setHostComputer(String computer) {
        this._hostComputer = computer;
    }

    public void setImageData(String imageData) {
        this._imageData = imageData;
    }

    public void setImageIdentifier(String identifier) {
        this._imageIdentifier = identifier;
    }

    public void setImageIdentifierLocation(String location) {
        this._imageIdentifierLocation = location;
    }

    public void setImageLength(long length) {
        this._imageLength = length;
    }

    public void setImageProducer(String producer) {
        this._imageProducer = producer;
    }

    public void setImageWidth(long width) {
        this._imageWidth = width;
    }

    public void setMaxApertureValue(Rational value) {
        this._maxApertureValue = value;
    }

    public void setMeteringMode(int mode) {
        this._meteringMode = mode;
    }

    public void setMethodology(String methodology) {
        this._methodology = methodology;
    }

    public void setMimeType(String type) {
        this._mimeType = type;
    }

    public void setOrientation(int orientation) {
        this._orientation = orientation;
    }

    public void setOS(String os) {
        this._os = os;
    }

    public void setOSVersion(String version) {
        this._osVersion = version;
    }

    public void setPerformanceData(String performanceData) {
        this._performanceData = performanceData;
    }

    public void setPixelSize(double size) {
        this._pixelSize = size;
    }

    public void setPlanarConfiguration(int configuration) {
        this._planarConfiguration = configuration;
    }

    public void setPreferredPresentation(String presentation) {
        this._preferredPresentation = presentation;
    }

    public void setPrimaryChromaticitiesBlueX(Rational x) {
        this._primaryChromaticitiesBlueX = x;
    }

    public void setPrimaryChromaticitiesBlueY(Rational y) {
        this._primaryChromaticitiesBlueY = y;
    }

    public void setPrimaryChromaticitiesGreenX(Rational x) {
        this._primaryChromaticitiesGreenX = x;
    }

    public void setPrimaryChromaticitiesGreenY(Rational y) {
        this._primaryChromaticitiesGreenY = y;
    }

    public void setPrimaryChromaticitiesRedX(Rational x) {
        this._primaryChromaticitiesRedX = x;
    }

    public void setPrimaryChromaticitiesRedY(Rational y) {
        this._primaryChromaticitiesRedY = y;
    }

    public void setProcessingActions(String[] actions) {
        this._processingActions = actions;
    }

    public void setProcessingAgency(String processingAgency) {
        this._processingAgency = processingAgency;
    }

    public void setProcessingSoftwareName(String name) {
        this._processingSoftwareName = name;
    }

    public void setProcessingSoftwareVersion(String version) {
        this._processingSoftwareVersion = version;
    }

    public void setProfileName(String name) {
        this._profileName = name;
    }

    public void setProfiles(String profiles) {
        this._profiles = profiles;
    }

    public void setProfileURL(String URL2) {
        this._profileURL = URL2;
    }

    public void setReferenceBlackWhite(Rational[] reference) {
        this._referenceBlackWhite = reference;
    }

    public void setRowsPerStrip(long rows) {
        this._rowsPerStrip = rows;
    }

    public void setSamplingFrequencyPlane(int plane) {
        this._samplingFrequencyPlane = plane;
    }

    public void setSamplesPerPixel(int samples) {
        this._samplesPerPixel = samples;
    }

    public void setSamplingFrequencyUnit(int unit) {
        this._samplingFrequencyUnit = unit;
    }

    public void setScannerManufacturer(String manufacturer) {
        this._scannerManufacturer = manufacturer;
    }

    public void setScannerModelName(String name) {
        this._scannerModelName = name;
    }

    public void setScannerModelNumber(String number) {
        this._scannerModelNumber = number;
    }

    public void setScannerModelSerialNo(String number) {
        this._scannerModelSerialNo = number;
    }

    public void setScanningSoftware(String software) {
        this._scanningSoftware = software;
    }

    public void setScanningSoftwareVersionNo(String number) {
        this._scanningSoftwareVersionNo = number;
    }

    public void setSceneIlluminant(int illuminant) {
        this._sceneIlluminant = illuminant;
    }

    public void setSensor(int sensor) {
        this._sensor = sensor;
    }

    public void setSourceData(String sourceData) {
        this._sourceData = sourceData;
    }

    public void setSourceID(String id) {
        this._sourceID = id;
    }

    public void setSourceType(String type) {
        this._sourceType = type;
    }

    public void setSourceXDimension(double x) {
        this._sourceXDimension = x;
    }

    public void setSourceXDimensionUnit(int unit) {
        this._sourceXDimensionUnit = unit;
    }

    public void setSourceYDimension(double y) {
        this._sourceYDimension = y;
    }

    public void setSourceYDimensionUnit(int unit) {
        this._sourceYDimensionUnit = unit;
    }

    public void setStripByteCounts(long[] counts) {
        this._stripByteCounts = counts;
    }

    public void setStripOffsets(long[] offsets) {
        this._stripOffsets = offsets;
    }

    public void setSubjectDistance(double[] distance) {
        this._subjectDistance = distance;
    }

    public void setTargetIDManufacturer(String targetIDManufacturer) {
        this._targetIDManufacturer = targetIDManufacturer;
    }

    public void setTargetIDMedia(String targetIDMedia) {
        this._targetIDMedia = targetIDMedia;
    }

    public void setTargetIDName(String targetIDName) {
        this._targetIDName = targetIDName;
    }

    public void setTargetIDNo(String targetIDNo) {
        this._targetIDNo = targetIDNo;
    }

    public void setTargetType(int targetType) {
        this._targetType = targetType;
    }

    public void setTileByteCounts(long[] counts) {
        this._tileByteCounts = counts;
    }

    public void setTileLength(long length) {
        this._tileLength = length;
    }

    public void setTileOffsets(long[] offsets) {
        this._tileOffsets = offsets;
    }

    public void setTileWidth(long width) {
        this._tileWidth = width;
    }

    public void setWhitePointXValue(Rational x) {
        this._whitePointXValue = x;
    }

    public void setWhitePointYValue(Rational y) {
        this._whitePointYValue = y;
    }

    public void setXPhysScanResolution(double x) {
        this._xPhysScanResolution = x;
    }

    public void setXPrintAspectRatio(double x) {
        this._xPrintAspectRatio = x;
    }

    public void setXSamplingFrequency(Rational x) {
        this._xSamplingFrequency = x;
    }

    public void setXTargetedDisplayAspectRatio(long x) {
        this._xTargetedDisplayAR = x;
    }

    public void setYCbCrCoefficients(Rational[] coefficients) {
        this._yCbCrCoefficients = coefficients;
    }

    public void setYCbCrPositioning(int positioning) {
        this._yCbCrPositioning = positioning;
    }

    public void setYCbCrSubSampling(int[] sampling) {
        this._yCbCrSubSampling = sampling;
    }

    public void setYPhysScanResolution(double y) {
        this._yPhysScanResolution = y;
    }

    public void setYPrintAspectRatio(double y) {
        this._yPrintAspectRatio = y;
    }

    public void setYSamplingFrequency(Rational y) {
        this._ySamplingFrequency = y;
    }

    public void setYTargetedDisplayAspectRatio(long y) {
        this._yTargetedDisplayAR = y;
    }

    public void setViewerData(Property viewerData) {
        this._viewerData = viewerData;
    }

    protected static String make8601Valid(String date) {
        String isoDate;
        Pattern pIsoDate = Pattern.compile("(\\d{4})\\-([01]\\d)\\-([0-3]\\d)T([0-2]\\d):([0-5]\\d):([0-5]\\d)");
        Pattern pTiffDate = Pattern.compile("(\\d{4}).([01]\\d).([0-3]\\d).([0-2]\\d).([0-5]\\d).([0-5]\\d)");
        if (pIsoDate.matcher(date).matches()) {
            return date;
        }
        Matcher m3 = pTiffDate.matcher(date);
        if (m3.matches() && pIsoDate.matcher(isoDate = String.format("%s-%s-%sT%s:%s:%s", m3.group(1), m3.group(2), m3.group(3), m3.group(4), m3.group(5), m3.group(6))).matches()) {
            return isoDate;
        }
        return null;
    }

    public static String extractIccProfileDescription(byte[] data) throws IllegalArgumentException {
        ICC_Profile profile = ICC_Profile.getInstance(data);
        byte[] dataProf = profile.getData(1684370275);
        if (dataProf == null) {
            return null;
        }
        String description = null;
        ByteBuffer bb = ByteBuffer.wrap(dataProf).asReadOnlyBuffer();
        int majorVersion = profile.getMajorVersion();
        int minorVersion = profile.getMinorVersion();
        LOGGER.fine("Version " + majorVersion + "." + minorVersion);
        int beginTag = bb.getInt(0);
        if (beginTag == 1684370275) {
            int OFFSET_LENGTH = 8;
            int OFFSET_DESC = 12;
            int lengthAscii = bb.getInt(8);
            byte[] asciiDesc = new byte[lengthAscii - 1];
            bb.position(12);
            bb.get(asciiDesc);
            description = new String(asciiDesc, StandardCharsets.US_ASCII);
        } else {
            int OFFSET_NUMBER = 8;
            int MLUC_TAG = 1835824483;
            int OFFSET_NAME_LENGTH = 20;
            int OFFSET_NAME_OFFSET = 24;
            int tagMluc = bb.getInt(0);
            int nb = bb.getInt(8);
            if (tagMluc != 1835824483 || nb < 1) {
                throw new IllegalArgumentException("No description in ICC profile v4");
            }
            int firstNameLength = bb.getInt(20);
            int firstNameOffset = bb.getInt(24);
            byte[] desc = new byte[firstNameLength];
            bb.position(firstNameOffset);
            bb.get(desc);
            description = new String(desc, StandardCharsets.UTF_16BE);
        }
        return description;
    }
}

