/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.messages;

import edu.harvard.hul.ois.jhove.messages.JhoveMessage;
import edu.harvard.hul.ois.jhove.messages.JhoveMessageFactory;
import edu.harvard.hul.ois.jhove.messages.JhoveMessages;
import java.util.ResourceBundle;

final class JhoveMessageFactImpl
implements JhoveMessageFactory {
    private final ResourceBundle messageBundle;

    private JhoveMessageFactImpl(ResourceBundle messageBundle) {
        this.messageBundle = messageBundle;
    }

    @Override
    public JhoveMessage getMessage(String id) {
        String message = this.messageBundle.getString(id);
        return JhoveMessages.getMessageInstance(id, message);
    }

    static JhoveMessageFactImpl getInstance(ResourceBundle messageBundle) throws IllegalArgumentException {
        if (messageBundle == null) {
            throw new IllegalArgumentException("messageBundle cannot be null");
        }
        return new JhoveMessageFactImpl(messageBundle);
    }
}

