/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.messages.JhoveMessage;
import edu.harvard.hul.ois.jhove.messages.JhoveMessages;
import org.jwat.common.Diagnosis;
import org.jwat.common.DiagnosisType;

public class JwatJhoveIdMinter {
    public static final String DEFAULT_DELIMETER = "-";
    public static final int DEFAULT_OFFSET = 100;
    private final String prefix;
    private final int offset;

    private JwatJhoveIdMinter(String prefix, String delimeter, int offset) {
        this.prefix = prefix.toUpperCase() + delimeter;
        this.offset = offset;
    }

    public final JhoveMessage mint(Diagnosis diagnosis) {
        return JhoveMessages.getMessageInstance(this.getID(diagnosis.type), diagnosis.type.name(), JwatJhoveIdMinter.createSubMessage(diagnosis));
    }

    public static final JwatJhoveIdMinter getInstance(String prefix) {
        return JwatJhoveIdMinter.getInstance(prefix, DEFAULT_DELIMETER);
    }

    public static final JwatJhoveIdMinter getInstance(String prefix, String delimeter) {
        return JwatJhoveIdMinter.getInstance(prefix, delimeter, 100);
    }

    public static final JwatJhoveIdMinter getInstance(String prefix, String delimeter, int offset) {
        if (prefix == null || prefix.isEmpty()) {
            throw new IllegalArgumentException("Prefix cannot be null or empty");
        }
        if (delimeter == null || delimeter.isEmpty()) {
            throw new IllegalArgumentException("Delimeter cannot be null or empty");
        }
        return new JwatJhoveIdMinter(prefix, delimeter, offset);
    }

    private final String getID(DiagnosisType type) {
        return this.prefix + (type.ordinal() + this.offset);
    }

    private static String createSubMessage(Diagnosis d) {
        StringBuilder res = new StringBuilder();
        res.append("Entity: ").append(d.entity);
        for (String i : d.information) {
            res.append(", ").append(i);
        }
        return res.toString();
    }
}

