/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.sort.CustomSetEntryChain;
import net.sf.saxon.expr.sort.EqualityMatcher;
import net.sf.saxon.z.IntHashMap;

public class CustomSet<T> {
    private final IntHashMap<CustomSetEntryChain<T>> buckets = new IntHashMap();
    private final EqualityMatcher<T> equalityMatcher;

    public CustomSet(EqualityMatcher<T> matcher) {
        this.equalityMatcher = matcher;
    }

    public boolean add(T value) {
        int h2 = this.equalityMatcher.hash(value);
        CustomSetEntryChain<T> bucket = this.buckets.get(h2);
        if (bucket == null) {
            CustomSetEntryChain<T> entry = new CustomSetEntryChain<T>(value);
            this.buckets.put(h2, entry);
            return true;
        }
        while (!this.equalityMatcher.equal(bucket.value, value)) {
            if (bucket.next == null) {
                CustomSetEntryChain<T> entry = new CustomSetEntryChain<T>(value);
                bucket.next = entry;
                return true;
            }
            bucket = bucket.next;
        }
        return false;
    }

    public boolean contains(T value) {
        int h2 = this.equalityMatcher.hash(value);
        CustomSetEntryChain<T> bucket = this.buckets.get(h2);
        if (bucket == null) {
            return false;
        }
        while (!this.equalityMatcher.equal(bucket.value, value)) {
            if (bucket.next == null) {
                return false;
            }
            bucket = bucket.next;
        }
        return true;
    }
}

