/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.text.Normalizer;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceiverOption;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.str.WhitespaceString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;

public class UnicodeNormalizer
extends ProxyReceiver {
    private final Normalizer.Form normForm;

    public UnicodeNormalizer(String form, Receiver next) throws XPathException {
        super(next);
        switch (form) {
            case "NFC": {
                this.normForm = Normalizer.Form.NFC;
                break;
            }
            case "NFD": {
                this.normForm = Normalizer.Form.NFD;
                break;
            }
            case "NFKC": {
                this.normForm = Normalizer.Form.NFKC;
                break;
            }
            case "NFKD": {
                this.normForm = Normalizer.Form.NFKD;
                break;
            }
            default: {
                XPathException err = new XPathException("Unknown normalization form " + form);
                err.setErrorCode("SESU0011");
                throw err;
            }
        }
    }

    public Normalizer.Form getNormalizationForm() {
        return this.normForm;
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        AttributeMap am2 = attributes.apply(attInfo -> {
            String newValue = this.normalize(StringView.of(attInfo.getValue()), ReceiverOption.contains(attInfo.getProperties(), 256)).toString();
            return new AttributeInfo(attInfo.getNodeName(), attInfo.getType(), newValue, attInfo.getLocation(), attInfo.getProperties());
        });
        this.nextReceiver.startElement(elemName, type, am2, namespaces, location, properties);
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        if (Whitespace.isAllWhite(chars)) {
            this.nextReceiver.characters(chars, locationId, properties);
        } else {
            this.nextReceiver.characters(this.normalize(chars, ReceiverOption.contains(properties, 256)), locationId, properties);
        }
    }

    public UnicodeString normalize(UnicodeString in, boolean containsNullMarkers) {
        if (in instanceof WhitespaceString) {
            return in;
        }
        UnicodeString t = in.tidy();
        if (containsNullMarkers) {
            StringBuilder out = new StringBuilder(t.length32());
            String s2 = in.toString();
            int start = 0;
            int nextNull = s2.indexOf(0);
            while (nextNull >= 0) {
                out.append(Normalizer.normalize(s2.substring(start, nextNull), this.normForm));
                out.append('\u0000');
                start = nextNull + 1;
                nextNull = s2.indexOf(0, start);
                out.append(s2.substring(start, nextNull));
                out.append('\u0000');
                start = nextNull + 1;
                nextNull = s2.indexOf(0, start);
            }
            out.append(Normalizer.normalize(s2.substring(start), this.normForm));
            return StringView.tidy(out.toString());
        }
        return StringView.tidy(Normalizer.normalize(in.toString(), this.normForm));
    }
}

