/*
 * Decompiled with CFR 0.152.
 */
package org.ithaka.portico.jhove.module.epub;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.MasterReport;
import com.adobe.epubcheck.messages.Message;
import com.adobe.epubcheck.messages.Severity;
import com.adobe.epubcheck.reporting.CheckMessage;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.PathUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class JhoveRepInfoReport
extends MasterReport {
    protected String generationDate;
    protected String creationDate;
    protected String lastModifiedDate;
    protected String identifier;
    protected Set<String> titles = new TreeSet<String>();
    protected Set<String> creators = new TreeSet<String>();
    protected Set<String> contributors = new TreeSet<String>();
    protected Set<String> subjects = new TreeSet<String>();
    protected String publisher;
    protected Set<String> rights = new TreeSet<String>();
    protected String date;
    protected Set<String> mediaTypes = new TreeSet<String>();
    protected String formatName;
    protected String formatVersion;
    protected long pagesCount;
    protected long charsCount;
    protected String language;
    protected Set<String> embeddedFonts = new TreeSet<String>();
    protected Set<String> refFonts = new TreeSet<String>();
    protected Set<String> references = new TreeSet<String>();
    protected Set<String> resources = new TreeSet<String>();
    protected boolean hasEncryption;
    protected boolean hasSignatures;
    protected boolean hasAudio;
    protected boolean hasVideo;
    protected boolean hasFixedLayout;
    protected boolean hasScripts;
    protected List<CheckMessage> warns = new ArrayList<CheckMessage>();
    protected List<CheckMessage> errors = new ArrayList<CheckMessage>();
    protected List<CheckMessage> fatalErrors = new ArrayList<CheckMessage>();
    protected List<CheckMessage> usageMsgs = new ArrayList<CheckMessage>();
    protected List<CheckMessage> infoMsgs = new ArrayList<CheckMessage>();
    protected static final String ISO_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    protected static final String FALLBACK_FORMAT = "application/octet-stream";
    protected static final String FRAGMENT_START = "#";

    public JhoveRepInfoReport(String ePubName) {
        this.setEpubFileName(PathUtil.removeWorkingDirectory(ePubName));
    }

    @Override
    public void message(Message message, EPUBLocation location, Object ... args) {
        Severity s2 = message.getSeverity();
        switch (s2) {
            case FATAL: {
                CheckMessage.addCheckMessage(this.fatalErrors, message, location, args);
                break;
            }
            case ERROR: {
                CheckMessage.addCheckMessage(this.errors, message, location, args);
                break;
            }
            case WARNING: {
                CheckMessage.addCheckMessage(this.warns, message, location, args);
                break;
            }
            case USAGE: {
                CheckMessage.addCheckMessage(this.usageMsgs, message, location, args);
                break;
            }
            case INFO: {
                CheckMessage.addCheckMessage(this.infoMsgs, message, location, args);
                break;
            }
            case SUPPRESSED: {
                break;
            }
        }
    }

    @Override
    public void info(String resource, FeatureEnum feature, String value) {
        if (value == null) {
            return;
        }
        switch (feature) {
            case FORMAT_NAME: {
                this.formatName = value;
                break;
            }
            case FORMAT_VERSION: {
                this.formatVersion = value;
                break;
            }
            case CREATION_DATE: {
                this.creationDate = value;
                break;
            }
            case MODIFIED_DATE: {
                this.lastModifiedDate = value;
                break;
            }
            case PAGES_COUNT: {
                this.pagesCount = Long.parseLong(value);
                break;
            }
            case CHARS_COUNT: {
                this.charsCount += Long.parseLong(value);
                break;
            }
            case DECLARED_MIMETYPE: {
                this.mediaTypes.add(value);
                if (value != null && value.startsWith("audio/")) {
                    this.hasAudio = true;
                    break;
                }
                if (value == null || !value.startsWith("video/")) break;
                this.hasVideo = true;
                break;
            }
            case FONT_EMBEDDED: {
                this.embeddedFonts.add(value);
                break;
            }
            case FONT_REFERENCE: {
                this.refFonts.add(value);
                break;
            }
            case REFERENCE: {
                this.references.add(value);
                break;
            }
            case RESOURCE: {
                String no_fragment = value.split(FRAGMENT_START)[0];
                this.resources.add(no_fragment);
                break;
            }
            case DC_LANGUAGE: {
                this.language = value;
                break;
            }
            case DC_TITLE: {
                this.titles.add(value);
                break;
            }
            case DC_CREATOR: {
                this.creators.add(value);
                break;
            }
            case DC_CONTRIBUTOR: {
                this.contributors.add(value);
                break;
            }
            case DC_PUBLISHER: {
                this.publisher = value;
                break;
            }
            case DC_SUBJECT: {
                this.subjects.add(value);
                break;
            }
            case DC_RIGHTS: {
                this.rights.add(value);
                break;
            }
            case DC_DATE: {
                this.date = value;
                break;
            }
            case UNIQUE_IDENT: {
                if (resource != null) break;
                this.identifier = value;
                break;
            }
            case HAS_SIGNATURES: {
                this.hasSignatures = true;
                break;
            }
            case HAS_ENCRYPTION: {
                this.hasEncryption = true;
                break;
            }
            case HAS_FIXED_LAYOUT: {
                this.hasFixedLayout = true;
                break;
            }
            case HAS_SCRIPTS: {
                this.hasScripts = true;
                break;
            }
            case SPINE_INDEX: {
                break;
            }
        }
    }

    public Date getCreationDate() {
        return JhoveRepInfoReport.toDate(this.creationDate);
    }

    public Date getLastModifiedDate() {
        return JhoveRepInfoReport.toDate(this.lastModifiedDate);
    }

    public String getFormat() {
        if (this.formatName == null) {
            return FALLBACK_FORMAT;
        }
        return this.formatName;
    }

    public String getVersion() {
        return this.formatVersion;
    }

    public List<CheckMessage> getAllMessages() {
        ArrayList<CheckMessage> messages = new ArrayList<CheckMessage>();
        messages.addAll(this.fatalErrors);
        messages.addAll(this.errors);
        messages.addAll(this.warns);
        messages.addAll(this.usageMsgs);
        messages.addAll(this.infoMsgs);
        return messages;
    }

    public long getPageCount() {
        return this.pagesCount;
    }

    public long getCharacterCount() {
        return this.charsCount;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String[] getTitles() {
        return this.toStringArray(this.titles);
    }

    public String[] getCreators() {
        return this.toStringArray(this.creators);
    }

    public String[] getContributors() {
        return this.toStringArray(this.contributors);
    }

    public String getDate() {
        return this.date;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public String[] getSubjects() {
        return this.toStringArray(this.subjects);
    }

    public String[] getRights() {
        return this.toStringArray(this.rights);
    }

    public Set<String> getEmbeddedFonts() {
        return this.embeddedFonts;
    }

    public Set<String> getRefFonts() {
        return this.refFonts;
    }

    public String[] getReferences() {
        return this.toStringArray(this.references);
    }

    public String[] getResources() {
        return this.toStringArray(this.resources);
    }

    public String[] getMediaTypes() {
        return this.toStringArray(this.mediaTypes);
    }

    public Set<String> getFeatures() {
        TreeSet<String> features = new TreeSet<String>();
        if (this.hasEncryption) {
            features.add("hasEncryption");
        }
        if (this.hasSignatures) {
            features.add("hasSignatures");
        }
        if (this.hasAudio) {
            features.add("hasAudio");
        }
        if (this.hasVideo) {
            features.add("hasVideo");
        }
        if (this.hasFixedLayout) {
            features.add("hasFixedLayout");
        }
        if (this.hasScripts) {
            features.add("hasScripts");
        }
        return features;
    }

    private String[] toStringArray(Set<String> set) {
        if (set != null && !set.isEmpty()) {
            String[] arr = new String[set.size()];
            return set.toArray(arr);
        }
        return null;
    }

    private static Date toDate(String isoDate) {
        Date date;
        if (isoDate == null || isoDate.length() == 0) {
            return null;
        }
        isoDate = isoDate.trim();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ISO_DATE_PATTERN);
        try {
            date = simpleDateFormat.parse(isoDate);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid ISO date provided: " + isoDate, e);
        }
        return date;
    }

    @Override
    public int getErrorCount() {
        return this.errors.size();
    }

    @Override
    public int getWarningCount() {
        return this.warns.size();
    }

    @Override
    public int getFatalErrorCount() {
        return this.fatalErrors.size();
    }

    @Override
    public int getUsageCount() {
        return this.usageMsgs.size();
    }

    @Override
    public int getInfoCount() {
        return this.infoMsgs.size();
    }

    @Override
    public int generate() {
        return 0;
    }

    @Override
    public void initialize() {
    }
}

