/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

public class HeaderLine {
    public static final int READLINE_INITIAL_SIZE = 128;
    public static final byte HLT_LINE = 1;
    public static final byte HLT_HEADERLINE = 2;
    public byte type = 0;
    public String name;
    public String value;
    public String line;
    public byte[] raw;
    public int bfErrors;
    public List<HeaderLine> lines = new LinkedList<HeaderLine>();

    public static HeaderLine readLine(InputStream in) throws IOException {
        StringBuffer sb = new StringBuffer(128);
        ByteArrayOutputStream out = new ByteArrayOutputStream(128);
        while (true) {
            int b;
            if ((b = in.read()) == -1) {
                return null;
            }
            out.write(b);
            if (b == 10) break;
            if (b == 13) continue;
            sb.append((char)b);
        }
        HeaderLine headerLine = new HeaderLine();
        headerLine.line = sb.toString();
        headerLine.raw = out.toByteArray();
        return headerLine;
    }
}

