/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.epubcheck.core.references;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.ValidationContext;
import com.google.common.base.Preconditions;
import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.StrictErrorHandler;
import io.mola.galimatias.URL;
import io.mola.galimatias.URLParsingSettings;
import java.net.URI;
import org.w3c.epubcheck.util.url.URLUtils;

public class URLChecker {
    private static final String TEST_BASE_A_FULL = "https://a.example.org/A/";
    private static final String TEST_BASE_A_START = "https://a.example.org/";
    private static final URL TEST_BASE_A_URL = URL.fromJavaURI(URI.create("https://a.example.org/A/"));
    private static final String TEST_BASE_B_FULL = "https://b.example.org/B/";
    private static final String TEST_BASE_B_START = "https://b.example.org/";
    private static final URL TEST_BASE_B_URL = URL.fromJavaURI(URI.create("https://b.example.org/B/"));
    private static final URLParsingSettings STRICT_PARSING_SETTINGS = URLParsingSettings.create().withErrorHandler(StrictErrorHandler.getInstance());
    private URL baseURL;
    private URL baseURLTestA;
    private URL baseURLTestB;
    private boolean isRemoteBase;
    private final Report report;
    private final ValidationContext context;

    public URLChecker(ValidationContext context) {
        this(Preconditions.checkNotNull(context), context.url);
    }

    public URLChecker(ValidationContext context, URL baseURL) {
        this.context = Preconditions.checkNotNull(context);
        this.report = context.report;
        this.baseURL = Preconditions.checkNotNull(baseURL);
        this.isRemoteBase = false;
        try {
            this.baseURLTestA = TEST_BASE_A_URL.resolve(context.relativize(baseURL));
            this.baseURLTestB = TEST_BASE_B_URL.resolve(context.relativize(baseURL));
        }
        catch (GalimatiasParseException e) {
            throw new AssertionError((Object)e);
        }
    }

    public URL setBase(String newBase, EPUBLocation location) {
        URL newBaseURL = this.resolveURL(newBase, true, location);
        if (newBaseURL != null) {
            this.baseURL = newBaseURL;
        }
        return this.baseURL;
    }

    public URL checkURL(String string, EPUBLocation location) {
        URL url = URLUtils.normalize(this.resolveURL(string, false, location));
        return url;
    }

    private URL resolveURL(String string, boolean isBase, EPUBLocation location) {
        assert (this.baseURL != null);
        if (string == null) {
            return null;
        }
        try {
            if (string.startsWith("file:")) {
                this.report.message(MessageId.RSC_030, location, string);
            }
            if (string.startsWith("data:")) {
                string = string.replaceAll("\\s", "");
            }
            URL url = URL.parse(this.baseURL, string);
            try {
                URL.parse(STRICT_PARSING_SETTINGS, this.baseURL, string);
            }
            catch (GalimatiasParseException e) {
                this.report.message(MessageId.RSC_020, location, string, e.getLocalizedMessage());
            }
            URL testA = this.baseURLTestA.resolve(string);
            URL testB = this.baseURLTestB.resolve(string);
            if (isBase) {
                this.baseURLTestA = testA;
                this.baseURLTestB = testB;
            }
            if (this.isRemoteBase) {
                return url;
            }
            if (!testA.toString().startsWith(TEST_BASE_A_START) || !testB.toString().startsWith(TEST_BASE_B_START)) {
                this.isRemoteBase = true;
                return url;
            }
            if (url.query() != null) {
                this.report.message(MessageId.RSC_033, location, string);
                url = url.withQuery(null);
            }
            if (!(!this.context.container.isPresent() || isBase || testA.toString().startsWith(TEST_BASE_A_FULL) && testB.toString().startsWith(TEST_BASE_B_FULL))) {
                this.report.message(MessageId.RSC_026, location, string);
            }
            return url;
        }
        catch (GalimatiasParseException e) {
            this.report.message(MessageId.RSC_020, location, string, e.getLocalizedMessage());
            return null;
        }
    }
}

