/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.epubcheck.util.url;

import com.google.common.base.Preconditions;
import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.ParseIssue;
import io.mola.galimatias.URL;
import io.mola.galimatias.canonicalize.DecodeUnreservedCanonicalizer;
import java.io.File;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.text.StringCharacterIterator;

public final class URLUtils {
    public static URL toURL(File file) {
        Preconditions.checkArgument(file != null, "file must not be null");
        return URL.fromJavaURI(file.toURI());
    }

    public static File toFile(URL url) {
        Preconditions.checkArgument(url != null, "file must not be null");
        Preconditions.checkArgument("file".equals(url.scheme()));
        try {
            return Paths.get(url.toJavaURI()).toFile();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toFilePath(URL url) {
        Preconditions.checkArgument(url != null, "file must not be null");
        Preconditions.checkArgument("file".equals(url.scheme()));
        try {
            return Paths.get(url.toJavaURI()).toString();
        }
        catch (Exception e) {
            return URLUtils.decode(url.path());
        }
    }

    public static URL docURL(URL url) {
        Preconditions.checkArgument(url != null, "url must not be null");
        try {
            return url.withFragment(null);
        }
        catch (GalimatiasParseException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    public static boolean isSameOrigin(URL urlA, URL urlB) {
        if (urlA == null || urlB == null) {
            return urlA == null && urlB == null;
        }
        if (urlA.equals(urlB)) {
            return true;
        }
        switch (urlA.scheme()) {
            case "ftp": 
            case "http": 
            case "https": 
            case "ws": 
            case "wss": 
            case "file": {
                return urlA.scheme().equals(urlB.scheme()) && (urlA.host() == urlB.host() || urlA.host().equals(urlB.host())) && urlA.port() == urlB.port();
            }
        }
        return false;
    }

    public static boolean isRemote(URL test, URL local) {
        return (test == null || !test.scheme().equals("data")) && !URLUtils.isSameOrigin(test, local);
    }

    public static boolean isAbsoluteURLString(String string) {
        block2: {
            try {
                URL.parse(string);
            }
            catch (GalimatiasParseException e) {
                if (!ParseIssue.MISSING_SCHEME.equals((Object)e.getParseIssue())) break block2;
                return false;
            }
        }
        return true;
    }

    public static boolean isPathRelativeSchemeLessURLString(String string) {
        return true;
    }

    public static String encodePath(String string) {
        int codepoint;
        if (string == null || string.isEmpty()) {
            return string;
        }
        StringBuilder buffer = new StringBuilder(string.length() * 2);
        for (int index = 0; index < string.length(); index += Character.charCount(codepoint)) {
            codepoint = string.codePointAt(index);
            if (!io.mola.galimatias.URLUtils.isURLCodePoint(codepoint) || codepoint == 63) {
                byte[] bytes;
                for (byte b : bytes = new String(Character.toChars(codepoint)).getBytes(io.mola.galimatias.URLUtils.UTF_8)) {
                    io.mola.galimatias.URLUtils.percentEncode(b, buffer);
                }
                continue;
            }
            buffer.appendCodePoint(codepoint);
        }
        return buffer.toString();
    }

    public static String decode(String string) {
        return io.mola.galimatias.URLUtils.percentDecode(string);
    }

    public static URL normalize(URL url) {
        URL normalized = url;
        if (url != null) {
            try {
                if (url.isHierarchical() && url.path() != null) {
                    normalized = url.withPath(URLUtils.encodePath(URLUtils.decode(url.path())));
                }
                normalized = new DecodeUnreservedCanonicalizer().canonicalize(normalized);
            }
            catch (GalimatiasParseException unexpected) {
                throw new AssertionError((Object)unexpected);
            }
        }
        return normalized;
    }

    public static String getDataURLType(URL url) {
        if (!"data".equals(url.scheme())) {
            return null;
        }
        StringBuilder type = new StringBuilder();
        StringCharacterIterator characters = new StringCharacterIterator(url.schemeData());
        char c = characters.current();
        while (c != '\uffff' && c != ',' && c != ';') {
            type.append(c);
            c = characters.next();
        }
        return type.toString();
    }
}

