/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.css;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.css.CSSChecker;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.vocab.PackageVocabs;
import com.adobe.epubcheck.vocab.Property;
import com.google.common.base.CharMatcher;
import com.google.common.collect.Sets;
import io.mola.galimatias.URL;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.idpf.epubcheck.util.css.CssContentHandler;
import org.idpf.epubcheck.util.css.CssErrorHandler;
import org.idpf.epubcheck.util.css.CssExceptions;
import org.idpf.epubcheck.util.css.CssGrammar;
import org.idpf.epubcheck.util.css.CssLocation;
import org.w3c.epubcheck.core.references.Reference;
import org.w3c.epubcheck.core.references.URLChecker;

public class CSSHandler
implements CssContentHandler,
CssErrorHandler {
    final ValidationContext context;
    final Report report;
    final EPUBVersion version;
    final CSSChecker.Mode mode;
    int startingLineNumber = 0;
    int startingColumnNumber = 0;
    static final CharMatcher SPACE_AND_QUOTES = CharMatcher.anyOf(" \t\n\r\f\"'").precomputed();
    Map<String, URL> parsedURLs = new HashMap<String, URL>();
    final URLChecker urlChecker;
    String fontFamily;
    String fontStyle;
    String fontWeight;
    String fontURI;
    boolean inFontFace = false;
    boolean hasFontFaceDeclarations = false;
    boolean inKeyFrames = false;
    CssGrammar.CssAtRule atRule = null;
    final Set<PackageVocabs.ITEM_PROPERTIES> detectedProperties = EnumSet.noneOf(PackageVocabs.ITEM_PROPERTIES.class);
    static final Pattern invalidTokenStringFinder = Pattern.compile("Token '[0-9]+%' not allowed here");
    static final Pattern keyframesPattern = Pattern.compile("@((keyframes)|(-moz-keyframes)|(-webkit-keyframes)|(-o-keyframes))");

    public CSSHandler(ValidationContext context, CSSChecker.Mode mode) {
        this.context = context;
        this.report = context.report;
        this.version = context.version;
        this.mode = mode;
        this.urlChecker = new URLChecker(context);
    }

    private EPUBLocation getCorrectedEPUBLocation(int lineNumber, int columnNumber, String details) {
        lineNumber = this.correctedLineNumber(lineNumber);
        columnNumber = this.correctedColumnNumber(lineNumber, columnNumber);
        return EPUBLocation.of(this.context).at(lineNumber, columnNumber).context(details);
    }

    private int correctedLineNumber(int lineNumber) {
        return this.startingLineNumber + lineNumber;
    }

    private int correctedColumnNumber(int lineNumber, int columnNumber) {
        if (lineNumber != 0) {
            return columnNumber;
        }
        return this.startingColumnNumber + columnNumber;
    }

    @Override
    public void error(CssExceptions.CssException e) throws CssExceptions.CssException {
        Matcher m3;
        String message = e.getMessage();
        if (this.inKeyFrames && (m3 = invalidTokenStringFinder.matcher(message)).matches()) {
            return;
        }
        CssLocation location = e.getLocation();
        this.report.message(MessageId.CSS_008, this.getCorrectedEPUBLocation(location.getLine(), location.getColumn(), null), e.getMessage());
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
        this.checkProperties();
    }

    @Override
    public void startAtRule(CssGrammar.CssAtRule atRule) {
        String ruleName = atRule.getName().get();
        this.atRule = atRule;
        if (ruleName.equals("@import")) {
            CssGrammar.CssConstruct uriOrString = atRule.getComponents().get(0);
            if (uriOrString != null) {
                int line = uriOrString.getLocation().getLine();
                int col = uriOrString.getLocation().getColumn();
                String uri = null;
                if (uriOrString.getType() == CssGrammar.CssConstruct.Type.URI) {
                    uri = ((CssGrammar.CssURI)uriOrString).toUriString();
                } else if (uriOrString.getType() == CssGrammar.CssConstruct.Type.STRING) {
                    uri = CharMatcher.anyOf("\"'").trimFrom(uriOrString.toCssString());
                }
                if (uri != null) {
                    this.resolveAndRegister(uri, line, col, atRule.toCssString(), Reference.Type.STYLESHEET);
                }
            }
        } else if (!atRule.getName().get().equals("@namespace")) {
            this.registerURIs(atRule.getComponents(), atRule.getLocation().getLine(), atRule.getLocation().getColumn());
        }
        if (ruleName.equals("@font-face")) {
            this.inFontFace = true;
        } else if (keyframesPattern.matcher(ruleName).matches()) {
            this.inKeyFrames = true;
        }
    }

    @Override
    public void endAtRule(String name) {
        if (this.inFontFace) {
            this.inFontFace = false;
            this.handleFontFaceInfo();
            if (!this.hasFontFaceDeclarations) {
                this.report.message(MessageId.CSS_019, EPUBLocation.of(this.context).at(this.atRule.getLocation().getLine(), this.atRule.getLocation().getColumn()).context(this.atRule.toCssString()), new Object[0]);
            }
            this.hasFontFaceDeclarations = false;
        }
        if (this.inKeyFrames) {
            this.inKeyFrames = false;
        }
        this.atRule = null;
    }

    @Override
    public void selectors(List<CssGrammar.CssSelector> selectors) {
        for (CssGrammar.CssSelector selector : selectors) {
            if (!this.context.featureReport.hasFeature(FeatureEnum.MEDIA_OVERLAYS_ACTIVE_CLASS) && this.findClassName(selector, ".-epub-media-overlay-active")) {
                this.report.message(MessageId.CSS_029, this.getCorrectedEPUBLocation(selector.getLocation().getLine(), selector.getLocation().getColumn(), selector.toCssString()), "-epub-media-overlay-active", "media:active-class");
            }
            if (this.context.featureReport.hasFeature(FeatureEnum.MEDIA_OVERLAYS_PLAYBACK_ACTIVE_CLASS) || !this.findClassName(selector, ".-epub-media-overlay-playing")) continue;
            this.report.message(MessageId.CSS_029, this.getCorrectedEPUBLocation(selector.getLocation().getLine(), selector.getLocation().getColumn(), selector.toCssString()), "-epub-media-overlay-playing", "media:playback-active-class");
        }
    }

    private boolean findClassName(CssGrammar.CssConstruct construct, String name) {
        if (construct.getType() == CssGrammar.CssConstruct.Type.CLASSNAME && name.equals(construct.toCssString())) {
            return true;
        }
        if (construct instanceof CssGrammar.CssComposedConstruct) {
            for (CssGrammar.CssConstruct component : ((CssGrammar.CssComposedConstruct)construct).getComponents()) {
                if (!this.findClassName(component, name)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void endSelectors(List<CssGrammar.CssSelector> selectors) {
    }

    @Override
    public void declaration(CssGrammar.CssDeclaration declaration) {
        String value;
        CssGrammar.CssConstruct cns;
        this.registerURIs(declaration.getComponents(), declaration.getLocation().getLine(), declaration.getLocation().getColumn());
        String propertyName = declaration.getName().get();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("position") && (cns = declaration.getComponents().get(0)) != null && (value = cns.toCssString()) != null && value.equalsIgnoreCase("fixed")) {
            this.report.message(MessageId.CSS_006, this.getCorrectedEPUBLocation(declaration.getLocation().getLine(), declaration.getLocation().getColumn(), declaration.toCssString()), new Object[0]);
        }
        if (this.version == EPUBVersion.VERSION_3 && (propertyName.equals("direction") || propertyName.equals("unicode-bidi"))) {
            this.report.message(MessageId.CSS_001, this.getCorrectedEPUBLocation(declaration.getLocation().getLine(), declaration.getLocation().getColumn(), declaration.toCssString()), propertyName);
        }
        if (this.inFontFace) {
            CssGrammar.CssConstruct cc;
            this.hasFontFaceDeclarations = true;
            if (propertyName.equals("font-family")) {
                cc = declaration.getComponents().get(0);
                if (cc != null) {
                    this.fontFamily = SPACE_AND_QUOTES.trimFrom(cc.toCssString());
                }
            } else if (propertyName.equals("font-style")) {
                cc = declaration.getComponents().get(0);
                this.fontStyle = cc.toCssString();
            } else if (propertyName.equals("font-weight")) {
                cc = declaration.getComponents().get(0);
                this.fontWeight = cc.toCssString();
            } else if (propertyName.equals("src")) {
                for (CssGrammar.CssConstruct construct : declaration.getComponents()) {
                    URL fontURL;
                    if (construct.getType() != CssGrammar.CssConstruct.Type.URI || (fontURL = this.parsedURLs.get(((CssGrammar.CssURI)construct).toUriString())) == null || !this.context.resourceRegistry.isPresent()) continue;
                    this.fontURI = this.context.relativize(fontURL);
                    String fontMimeType = this.context.getMimeType(fontURL);
                    if (fontMimeType == null) continue;
                    boolean blessed = true;
                    if (this.version == EPUBVersion.VERSION_2) {
                        blessed = OPFChecker.isBlessedFontMimetype20(fontMimeType);
                    } else if (this.version == EPUBVersion.VERSION_3) {
                        blessed = OPFChecker30.isBlessedFontType(fontMimeType);
                    }
                    if (blessed) continue;
                    this.report.message(MessageId.CSS_007, this.getCorrectedEPUBLocation(declaration.getLocation().getLine(), declaration.getLocation().getColumn(), declaration.toCssString()), fontURL, fontMimeType);
                }
            }
            this.report.message(MessageId.CSS_028, this.getCorrectedEPUBLocation(declaration.getLocation().getLine(), declaration.getLocation().getColumn(), this.fontURI != null ? this.fontURI : "null"), new Object[0]);
        }
    }

    private void registerURIs(List<CssGrammar.CssConstruct> constructs, int line, int col) {
        for (CssGrammar.CssConstruct construct : constructs) {
            if (construct.getType() != CssGrammar.CssConstruct.Type.URI) continue;
            this.resolveAndRegister(((CssGrammar.CssURI)construct).toUriString(), line, col, construct.toCssString(), this.inFontFace ? Reference.Type.FONT : Reference.Type.GENERIC);
        }
    }

    private void resolveAndRegister(String uriString, int line, int col, String cssContext, Reference.Type type) {
        if (uriString != null && uriString.trim().length() > 0) {
            if (!uriString.startsWith("#")) {
                URL url = this.urlChecker.checkURL(uriString, this.getCorrectedEPUBLocation(line, col, cssContext));
                this.parsedURLs.put(uriString, url);
                if (url != null && this.context.referenceRegistry.isPresent()) {
                    this.context.referenceRegistry.get().registerReference(url, type, this.getCorrectedEPUBLocation(line, col, cssContext));
                    if (type != Reference.Type.STYLESHEET && this.context.isRemote(url)) {
                        this.detectedProperties.add(PackageVocabs.ITEM_PROPERTIES.REMOTE_RESOURCES);
                    }
                }
            }
        } else {
            this.report.message(MessageId.CSS_002, this.getCorrectedEPUBLocation(line, col, cssContext), new Object[0]);
        }
    }

    private void handleFontFaceInfo() {
        if (this.fontFamily != null) {
            if (this.fontURI != null && !this.fontURI.startsWith("http")) {
                this.report.info(this.context.path, FeatureEnum.FONT_EMBEDDED, this.fontFamily + (this.fontStyle != null && !"normal".equalsIgnoreCase(this.fontStyle) ? "," + this.fontStyle : "") + (this.fontWeight != null && !"normal".equalsIgnoreCase(this.fontWeight) ? "," + this.fontWeight : ""));
            } else {
                this.report.info(this.context.path, FeatureEnum.FONT_REFERENCE, this.fontFamily + (this.fontStyle != null && !"normal".equalsIgnoreCase(this.fontStyle) ? "," + this.fontStyle : "") + (this.fontWeight != null && !"normal".equalsIgnoreCase(this.fontWeight) ? "," + this.fontWeight : ""));
                if (this.fontURI != null) {
                    this.report.info(this.context.path, FeatureEnum.REFERENCE, this.fontURI);
                }
            }
        }
    }

    protected void checkProperties() {
        EnumSet<PackageVocabs.ITEM_PROPERTIES> uncheckedProperties;
        if (!this.context.container.isPresent()) {
            return;
        }
        Set<PackageVocabs.ITEM_PROPERTIES> declaredProperties = Property.filter(this.context.properties, PackageVocabs.ITEM_PROPERTIES.class);
        for (PackageVocabs.ITEM_PROPERTIES property : Sets.difference(this.detectedProperties, declaredProperties)) {
            this.report.message(MessageId.OPF_014, EPUBLocation.of(this.context).at(this.startingLineNumber, this.startingColumnNumber), PackageVocabs.ITEM_VOCAB.getName(property));
        }
        if (this.mode == CSSChecker.Mode.FILE && (uncheckedProperties = Sets.difference(declaredProperties, this.detectedProperties).copyInto(EnumSet.noneOf(PackageVocabs.ITEM_PROPERTIES.class))).contains((Object)PackageVocabs.ITEM_PROPERTIES.REMOTE_RESOURCES)) {
            uncheckedProperties.remove((Object)PackageVocabs.ITEM_PROPERTIES.REMOTE_RESOURCES);
            this.report.message(MessageId.OPF_018, EPUBLocation.of(this.context).at(this.startingLineNumber, this.startingColumnNumber), new Object[0]);
        }
    }

    public void setStartingLineNumber(int offset) {
        this.startingLineNumber = offset - 1;
        if (this.startingLineNumber < 0) {
            this.startingLineNumber = 0;
        }
    }
}

