/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.dtbook;

import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.URISchemes;
import com.adobe.epubcheck.xml.handlers.XMLHandler;
import com.adobe.epubcheck.xml.model.XMLElement;
import io.mola.galimatias.URL;
import org.w3c.epubcheck.core.references.Reference;

public class DTBookHandler
extends XMLHandler {
    public DTBookHandler(ValidationContext context) {
        super(context);
    }

    @Override
    public void startElement() {
        XMLElement e = this.currentElement();
        String ns = e.getNamespace();
        String name = e.getName();
        if (ns.equals("http://www.daisy.org/z3986/2005/dtbook/")) {
            if (this.context.resourceRegistry.isPresent()) {
                this.context.resourceRegistry.get().registerID(e.getAttribute("id"), Reference.Type.GENERIC, this.location().url);
            }
            URL url = null;
            Reference.Type type = Reference.Type.GENERIC;
            if (name.equals("a")) {
                url = this.checkURL(e.getAttribute("href"));
                if (url != null && "true".equals(e.getAttribute("external")) && this.context.isRemote(url)) {
                    this.report.info(this.path, FeatureEnum.REFERENCE, url.toString());
                    if (!URISchemes.contains(url.scheme())) {
                        this.report.message(MessageId.OPF_021, this.location(), url.toHumanString());
                    }
                    url = null;
                }
            } else if (name.equals("link")) {
                url = this.checkURL(e.getAttribute("href"));
            } else if (name.equals("img")) {
                url = this.checkURL(e.getAttribute("src"));
                type = Reference.Type.IMAGE;
            }
            if (url != null) {
                this.registerReference(url, type);
                if (this.context.isRemote(url)) {
                    this.report.info(this.path, FeatureEnum.REFERENCE, url.toString());
                }
            }
        }
    }
}

