/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.EPUBVersion;
import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class FallbackChainResolver {
    private final Report report;
    private final EPUBVersion version;
    private final Map<String, OPFItem.Builder> items;

    public FallbackChainResolver(Map<String, OPFItem.Builder> items, ValidationContext context) {
        this.report = context.report;
        this.version = context.version;
        this.items = items;
    }

    public List<OPFItem> resolve() {
        LinkedList<OPFItem.Builder> itemQueue = new LinkedList<OPFItem.Builder>(this.items.values());
        ImmutableList.Builder resolved = ImmutableList.builderWithExpectedSize(itemQueue.size());
        int pending = 0;
        while (!itemQueue.isEmpty() && pending <= itemQueue.size()) {
            OPFItem.Builder item = (OPFItem.Builder)itemQueue.pop();
            String mimetype = item.mimetype();
            item.hasCoreMediaTypeFallback(item.hasCoreMediaTypeFallback() || this.version == EPUBVersion.VERSION_2 && OPFChecker.isBlessedImageType(mimetype, this.version) || OPFChecker30.isCoreMediaType(mimetype));
            item.hasContentDocumentFallback(item.hasContentDocumentFallback() || OPFChecker.isBlessedItemType(mimetype, this.version) || OPFChecker.isDeprecatedBlessedItemType(mimetype));
            if (item.hasFallback()) {
                OPFItem.Builder fallback = this.items.get(item.fallback());
                if (fallback == null) {
                    this.report.message(MessageId.OPF_040, item.location(), item.fallback());
                } else if (fallback.isResolved()) {
                    item.hasContentDocumentFallback(item.hasContentDocumentFallback() || fallback.hasContentDocumentFallback());
                    item.hasCoreMediaTypeFallback(item.hasCoreMediaTypeFallback() || fallback.hasCoreMediaTypeFallback());
                } else {
                    itemQueue.add(item);
                    ++pending;
                    continue;
                }
            }
            if (this.version == EPUBVersion.VERSION_2 && item.hasFallbackStyle()) {
                OPFItem.Builder fallbackStyle = this.items.get(item.fallbackStyle());
                if (fallbackStyle == null) {
                    this.report.message(MessageId.OPF_041, item.location(), item.fallback());
                } else {
                    boolean hasValidFallbackStyle = OPFChecker.isBlessedStyleType(fallbackStyle.mimetype()) || OPFChecker.isDeprecatedBlessedStyleType(fallbackStyle.mimetype());
                    item.hasContentDocumentFallback(item.hasContentDocumentFallback() || hasValidFallbackStyle);
                    item.hasCoreMediaTypeFallback(item.hasCoreMediaTypeFallback() || hasValidFallbackStyle);
                }
            }
            resolved.add(item.build());
            item.markResolved();
            pending = 0;
        }
        if (!itemQueue.isEmpty()) {
            this.report.message(MessageId.OPF_045, ((OPFItem.Builder)itemQueue.peek()).location(), new Object[0]);
            itemQueue.stream().forEach(i -> resolved.add(i.build()));
        }
        return resolved.build();
    }
}

