/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.QuietReport;
import com.adobe.epubcheck.messages.LocalizedMessages;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.LinkedResource;
import com.adobe.epubcheck.opf.LinkedResources;
import com.adobe.epubcheck.opf.MetadataSet;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.opf.OPFHandler;
import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.opf.ResourceCollection;
import com.adobe.epubcheck.opf.ResourceCollections;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.vocab.AccessibilityVocab;
import com.adobe.epubcheck.vocab.AggregateVocab;
import com.adobe.epubcheck.vocab.DCMESVocab;
import com.adobe.epubcheck.vocab.EnumVocab;
import com.adobe.epubcheck.vocab.EpubCheckVocab;
import com.adobe.epubcheck.vocab.ForeignVocabs;
import com.adobe.epubcheck.vocab.MediaOverlaysVocab;
import com.adobe.epubcheck.vocab.PackageVocabs;
import com.adobe.epubcheck.vocab.Property;
import com.adobe.epubcheck.vocab.RenditionVocabs;
import com.adobe.epubcheck.vocab.ScriptedCompVocab;
import com.adobe.epubcheck.vocab.Vocab;
import com.adobe.epubcheck.vocab.VocabUtil;
import com.adobe.epubcheck.xml.model.XMLElement;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.URL;
import java.util.Deque;
import java.util.IllformedLocaleException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.w3c.epubcheck.core.references.Reference;
import org.w3c.epubcheck.util.url.URLUtils;

public class OPFHandler30
extends OPFHandler {
    private static final Map<String, Vocab> RESERVED_VOCABS = new ImmutableMap.Builder<String, Vocab>().put("dcterms", ForeignVocabs.DCTERMS_VOCAB).put("marc", ForeignVocabs.MARC_VOCAB).put("onix", ForeignVocabs.ONIX_VOCAB).put("schema", ForeignVocabs.SCHEMA_VOCAB).put("xsd", ForeignVocabs.XSD_VOCAB).build();
    private static final Map<String, Vocab> RESERVED_META_VOCABS = new ImmutableMap.Builder<String, Vocab>().put("", AggregateVocab.of(PackageVocabs.META_VOCAB, PackageVocabs.META_VOCAB_CAMEL)).put("a11y", AccessibilityVocab.META_VOCAB).put("media", MediaOverlaysVocab.VOCAB).put("rendition", RenditionVocabs.META_VOCAB).putAll(RESERVED_VOCABS).build();
    private static final Map<String, Vocab> RESERVED_ITEM_VOCABS = new ImmutableMap.Builder<String, EnumVocab<PackageVocabs.ITEM_PROPERTIES>>().put("", PackageVocabs.ITEM_VOCAB).put("media", (EnumVocab<PackageVocabs.ITEM_PROPERTIES>)VocabUtil.EMPTY_VOCAB).put("rendition", (EnumVocab<PackageVocabs.ITEM_PROPERTIES>)VocabUtil.EMPTY_VOCAB).putAll(RESERVED_VOCABS).build();
    private static final Map<String, Vocab> RESERVED_ITEMREF_VOCABS = new ImmutableMap.Builder<String, EnumVocab<PackageVocabs.ITEMREF_PROPERTIES>>().put("", PackageVocabs.ITEMREF_VOCAB).put("media", (EnumVocab<PackageVocabs.ITEMREF_PROPERTIES>)VocabUtil.EMPTY_VOCAB).put("rendition", RenditionVocabs.ITEMREF_VOCAB).putAll(RESERVED_VOCABS).build();
    private static final Map<String, Vocab> RESERVED_LINKREL_VOCABS = new ImmutableMap.Builder<String, EnumVocab<PackageVocabs.LINKREL_PROPERTIES>>().put("", PackageVocabs.LINKREL_VOCAB).put("a11y", AccessibilityVocab.LINKREL_VOCAB).put("media", (EnumVocab<AccessibilityVocab.LINKREL_PROPERTIES>)VocabUtil.EMPTY_VOCAB).put("rendition", (EnumVocab<AccessibilityVocab.LINKREL_PROPERTIES>)VocabUtil.EMPTY_VOCAB).putAll(RESERVED_VOCABS).build();
    private static final Map<String, Vocab> RESERVED_LINK_VOCABS = new ImmutableMap.Builder<String, EnumVocab<PackageVocabs.LINK_PROPERTIES>>().put("", PackageVocabs.LINK_VOCAB).put("a11y", (EnumVocab<PackageVocabs.LINK_PROPERTIES>)VocabUtil.EMPTY_VOCAB).put("media", (EnumVocab<PackageVocabs.LINK_PROPERTIES>)VocabUtil.EMPTY_VOCAB).put("rendition", (EnumVocab<PackageVocabs.LINK_PROPERTIES>)VocabUtil.EMPTY_VOCAB).putAll(RESERVED_VOCABS).build();
    private static final Map<String, Vocab> KNOWN_VOCAB_URIS = new ImmutableMap.Builder<String, Vocab>().put("http://purl.org/dc/terms/", ForeignVocabs.DCTERMS_VOCAB).put("http://id.loc.gov/vocabulary/", ForeignVocabs.MARC_VOCAB).put("http://www.editeur.org/ONIX/book/codelists/current.html#", ForeignVocabs.ONIX_VOCAB).put("http://schema.org/", ForeignVocabs.SCHEMA_VOCAB).put("http://www.w3.org/2001/XMLSchema#", ForeignVocabs.XSD_VOCAB).build();
    private static final Map<String, Vocab> KNOWN_META_VOCAB_URIS = new ImmutableMap.Builder<String, Vocab>().putAll(KNOWN_VOCAB_URIS).put("http://www.idpf.org/epub/vocab/package/a11y/#", AccessibilityVocab.META_VOCAB).put("http://www.idpf.org/epub/vocab/overlays/#", MediaOverlaysVocab.VOCAB).put("http://www.idpf.org/vocab/rendition/#", RenditionVocabs.META_VOCAB).put("http://idpf.org/epub/vocab/sc/#", ScriptedCompVocab.VOCAB).build();
    private static final Map<String, Vocab> KNOWN_ITEM_VOCAB_URIS = new ImmutableMap.Builder<String, Vocab>().putAll(KNOWN_VOCAB_URIS).put("http://www.idpf.org/epub/vocab/package/a11y/#", VocabUtil.EMPTY_VOCAB).put("http://www.idpf.org/epub/vocab/overlays/#", VocabUtil.EMPTY_VOCAB).put("http://www.idpf.org/vocab/rendition/#", VocabUtil.EMPTY_VOCAB).put("http://idpf.org/epub/vocab/sc/#", VocabUtil.EMPTY_VOCAB).build();
    private static final Map<String, Vocab> KNOWN_ITEMREF_VOCAB_URIS = new ImmutableMap.Builder<String, Vocab>().putAll(KNOWN_VOCAB_URIS).put("http://www.idpf.org/epub/vocab/package/a11y/#", VocabUtil.EMPTY_VOCAB).put("http://www.idpf.org/epub/vocab/overlays/#", VocabUtil.EMPTY_VOCAB).put("http://www.idpf.org/vocab/rendition/#", RenditionVocabs.ITEMREF_VOCAB).build();
    private static final Map<String, Vocab> KNOWN_LINK_VOCAB_URIS = new ImmutableMap.Builder<String, Vocab>().putAll(KNOWN_VOCAB_URIS).put("http://www.idpf.org/epub/vocab/package/a11y/#", VocabUtil.EMPTY_VOCAB).put("http://www.idpf.org/epub/vocab/overlays/#", VocabUtil.EMPTY_VOCAB).put("http://www.idpf.org/vocab/rendition/#", VocabUtil.EMPTY_VOCAB).put("http://idpf.org/epub/vocab/sc/#", VocabUtil.EMPTY_VOCAB).build();
    private static final Map<String, Vocab> KNOWN_LINKREL_VOCAB_URIS = new ImmutableMap.Builder<String, Vocab>().putAll(KNOWN_VOCAB_URIS).put("http://www.idpf.org/epub/vocab/package/a11y/#", AccessibilityVocab.LINKREL_VOCAB).put("http://www.idpf.org/epub/vocab/overlays/#", (EnumVocab<AccessibilityVocab.LINKREL_PROPERTIES>)VocabUtil.EMPTY_VOCAB).put("http://www.idpf.org/vocab/rendition/#", (EnumVocab<AccessibilityVocab.LINKREL_PROPERTIES>)VocabUtil.EMPTY_VOCAB).put("http://idpf.org/epub/vocab/sc/#", (EnumVocab<AccessibilityVocab.LINKREL_PROPERTIES>)VocabUtil.EMPTY_VOCAB).build();
    private static final Set<String> DEFAULT_VOCAB_URIS = ImmutableSet.of("http://idpf.org/epub/vocab/package/item/#", "http://idpf.org/epub/vocab/package/itemref/#", "http://idpf.org/epub/vocab/package/meta/#", "http://idpf.org/epub/vocab/package/link/#");
    private static final Splitter TOKENIZER = Splitter.onPattern("\\s+");
    private Map<String, Vocab> itemrefVocabs;
    private Map<String, Vocab> itemVocabs;
    private Map<String, Vocab> metaVocabs;
    private Map<String, Vocab> linkVocabs;
    private Map<String, Vocab> linkrelVocabs;
    private final Deque<MetadataSet.Builder> metadataBuilders = Lists.newLinkedList();
    private MetadataSet metadata = null;
    private final Deque<LinkedResources.Builder> linkedResourcesBuilders = Lists.newLinkedList();
    private LinkedResources linkedResources = null;
    private final Deque<ResourceCollection.Builder> collectionBuilders = Lists.newLinkedList();
    private final ResourceCollections.Builder collectionsBuilder = ResourceCollections.builder();
    private ResourceCollections collections = null;

    OPFHandler30(ValidationContext context) {
        super(context);
    }

    @Override
    public void startElement() {
        super.startElement();
        XMLElement e = this.currentElement();
        String name = e.getName();
        String xmllang = e.getAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
        if (xmllang != null && !xmllang.isEmpty()) {
            this.checkLanguageTag(xmllang);
        }
        if ("http://www.idpf.org/2007/opf".equals(e.getNamespace())) {
            if (name.equals("package")) {
                String prefixDecl = e.getAttribute("prefix");
                EPUBLocation loc = this.location();
                this.metaVocabs = VocabUtil.parsePrefixDeclaration(prefixDecl, RESERVED_META_VOCABS, KNOWN_META_VOCAB_URIS, DEFAULT_VOCAB_URIS, this.report, loc);
                this.itemVocabs = VocabUtil.parsePrefixDeclaration(prefixDecl, RESERVED_ITEM_VOCABS, KNOWN_ITEM_VOCAB_URIS, DEFAULT_VOCAB_URIS, QuietReport.INSTANCE, loc);
                this.itemrefVocabs = VocabUtil.parsePrefixDeclaration(prefixDecl, RESERVED_ITEMREF_VOCABS, KNOWN_ITEMREF_VOCAB_URIS, DEFAULT_VOCAB_URIS, QuietReport.INSTANCE, loc);
                this.linkrelVocabs = VocabUtil.parsePrefixDeclaration(prefixDecl, RESERVED_LINKREL_VOCABS, KNOWN_LINKREL_VOCAB_URIS, DEFAULT_VOCAB_URIS, QuietReport.INSTANCE, loc);
                this.linkVocabs = VocabUtil.parsePrefixDeclaration(prefixDecl, RESERVED_LINK_VOCABS, KNOWN_LINK_VOCAB_URIS, DEFAULT_VOCAB_URIS, QuietReport.INSTANCE, loc);
            } else if (name.equals("metadata")) {
                this.metadataBuilders.addFirst(MetadataSet.builder());
                this.linkedResourcesBuilders.addFirst(LinkedResources.builder());
            } else if (name.equals("link")) {
                this.processLink();
            } else if (name.equals("item")) {
                String id = e.getAttribute("id");
                OPFItem.Builder itemBuilder = (OPFItem.Builder)this.itemBuilders.get(id);
                if (itemBuilder != null) {
                    this.processItemProperties(itemBuilder, e.getAttribute("properties"), e.getAttribute("media-type"));
                }
            } else if (name.equals("itemref")) {
                String idref = e.getAttribute("idref");
                OPFItem.Builder itemBuilder = (OPFItem.Builder)this.itemBuilders.get(idref);
                if (itemBuilder != null) {
                    this.processItemrefProperties(itemBuilder, e.getAttribute("properties"));
                }
            } else if (name.equals("collection")) {
                this.collectionBuilders.addFirst(ResourceCollection.builder().roles(this.processCollectionRole(e.getAttribute("role"))));
                this.linkedResourcesBuilders.addFirst(LinkedResources.builder());
            }
        }
    }

    @Override
    public void endElement() {
        XMLElement e = this.currentElement();
        String name = e.getName();
        if ("http://www.idpf.org/2007/opf".equals(e.getNamespace())) {
            if (name.equals("package")) {
                this.collections = this.collectionsBuilder.build();
                for (ResourceCollection collection : this.getCollections().getByRole(ResourceCollection.Roles.INDEX)) {
                    this.processItemsInIndexCollection(collection);
                }
            } else if (name.equals("meta")) {
                this.processMeta();
            } else if (name.equals("metadata")) {
                LinkedResources linkedResources;
                MetadataSet metadata = null;
                try {
                    if (!this.metadataBuilders.isEmpty()) {
                        metadata = this.metadataBuilders.removeFirst().build();
                    }
                }
                catch (IllegalStateException ex) {
                    this.report.message(MessageId.OPF_065, this.location(), new Object[0]);
                }
                LinkedResources linkedResources2 = linkedResources = this.linkedResourcesBuilders.isEmpty() ? null : this.linkedResourcesBuilders.removeFirst().build();
                if (this.collectionBuilders.isEmpty()) {
                    this.metadata = metadata;
                    this.linkedResources = linkedResources;
                    this.reportMetadata();
                } else {
                    this.collectionBuilders.peekFirst().metadata(metadata).metadataLinks(linkedResources);
                }
            } else if (name.equals("collection") && !this.collectionBuilders.isEmpty()) {
                if (!this.linkedResourcesBuilders.isEmpty()) {
                    this.collectionBuilders.peekFirst().resources(this.linkedResourcesBuilders.removeFirst().build());
                }
                ResourceCollection collection = this.collectionBuilders.removeFirst().build();
                if (this.collectionBuilders.isEmpty()) {
                    this.collectionsBuilder.add(collection);
                } else {
                    this.collectionBuilders.peekFirst().collection(collection);
                }
            }
        } else if ("http://purl.org/dc/elements/1.1/".equals(e.getNamespace())) {
            this.processDCElem();
        }
        super.endElement();
    }

    public MetadataSet getMetadata() {
        return this.metadata == null ? new MetadataSet.Builder().build() : this.metadata;
    }

    public LinkedResources getLinkedResources() {
        return this.linkedResources == null ? LinkedResources.builder().build() : this.linkedResources;
    }

    public ResourceCollections getCollections() {
        return this.collections == null ? ResourceCollections.builder().build() : this.collections;
    }

    private List<String> processCollectionRole(String roleAtt) {
        ImmutableList.Builder rolesBuilder = ImmutableList.builder();
        for (String role : TOKENIZER.split(Strings.nullToEmpty(roleAtt))) {
            if (URLUtils.isAbsoluteURLString(role)) {
                try {
                    URL.parse(role);
                }
                catch (GalimatiasParseException e) {
                    this.report.message(MessageId.OPF_070, this.location(), role);
                    break;
                }
            }
            rolesBuilder.add(role);
        }
        return rolesBuilder.build();
    }

    private void processLink() {
        String hreflang;
        XMLElement e = this.currentElement();
        String href = e.getAttribute("href");
        URL url = this.checkURL(href);
        if (url != null) {
            if ("data".equals(url.scheme())) {
                this.report.message(MessageId.RSC_029, this.location(), new Object[0]);
                return;
            }
            if (url.fragment() != null && !url.fragment().isEmpty() && URLUtils.docURL(url).equals(this.context.url)) {
                this.report.message(MessageId.OPF_098, this.location(), href);
                return;
            }
            if (this.context.isRemote(url)) {
                this.report.info(this.path, FeatureEnum.REFERENCE, href);
            }
            this.registerReference(url, Reference.Type.LINK);
            String rel = e.getAttribute("rel");
            Set<Property> relSet = this.processLinkRel(rel);
            Set<PackageVocabs.LINKREL_PROPERTIES> relEnum = Property.filter(relSet, PackageVocabs.LINKREL_PROPERTIES.class);
            String mediatype = e.getAttribute("media-type");
            if (mediatype == null) {
                if (!this.context.isRemote(url) && !this.metadataBuilders.isEmpty()) {
                    if (this.linkedResourcesBuilders.size() == 1) {
                        this.report.message(MessageId.OPF_093, this.location(), new Object[0]);
                    }
                } else if (relEnum.stream().anyMatch(keyword -> keyword == PackageVocabs.LINKREL_PROPERTIES.RECORD || keyword == PackageVocabs.LINKREL_PROPERTIES.VOICING)) {
                    this.report.message(MessageId.OPF_094, this.location(), rel);
                }
            } else if (relEnum.contains(PackageVocabs.LINKREL_PROPERTIES.VOICING) && !OPFChecker30.isAudioType(mediatype)) {
                this.report.message(MessageId.OPF_095, this.location(), mediatype);
            }
            this.processLinkProperties(e.getAttribute("properties"));
            if (!this.linkedResourcesBuilders.isEmpty()) {
                LinkedResource resource = new LinkedResource.Builder(url).id(e.getAttribute("id")).rel(relSet).mimetype(mediatype).refines(e.getAttribute("refines")).build();
                this.linkedResourcesBuilders.peekFirst().add(resource);
            }
        }
        if ((hreflang = e.getAttribute("hreflang")) != null && !hreflang.isEmpty()) {
            this.checkLanguageTag(hreflang);
        }
    }

    private void processItemrefProperties(OPFItem.Builder builder, String property) {
        Set<Property> properties = VocabUtil.parsePropertyList(property, this.itemrefVocabs, this.context, this.location());
        builder.properties(properties);
        if (properties.contains(RenditionVocabs.ITEMREF_VOCAB.get(RenditionVocabs.ITEMREF_PROPERTIES.LAYOUT_PRE_PAGINATED)) || !properties.contains(RenditionVocabs.ITEMREF_VOCAB.get(RenditionVocabs.ITEMREF_PROPERTIES.LAYOUT_REFLOWABLE)) && this.getMetadata().containsPrimary(RenditionVocabs.META_VOCAB.get(RenditionVocabs.META_PROPERTIES.LAYOUT), "pre-paginated")) {
            builder.fixedLayout();
        }
    }

    private void processItemProperties(OPFItem.Builder builder, String property, String mimeType) {
        if (property == null) {
            return;
        }
        Set<Property> properties = VocabUtil.parsePropertyList(property, this.itemVocabs, this.context, this.location());
        Set<PackageVocabs.ITEM_PROPERTIES> itemProps = Property.filter(properties, PackageVocabs.ITEM_PROPERTIES.class);
        mimeType = mimeType.trim();
        for (PackageVocabs.ITEM_PROPERTIES itemProp : itemProps) {
            if (itemProp.isAllowedForType(mimeType)) continue;
            this.report.message(MessageId.OPF_012, this.location(), PackageVocabs.ITEM_VOCAB.getName(itemProp), mimeType);
        }
        builder.properties(properties);
    }

    private Set<Property> processLinkProperties(String properties) {
        return VocabUtil.parsePropertyList(properties, this.linkVocabs, this.context, this.location());
    }

    private Set<Property> processLinkRel(String rel) {
        Set<Property> linkRelProperties = VocabUtil.parsePropertyList(rel, this.linkrelVocabs, this.context, this.location());
        if (Property.filter(linkRelProperties, PackageVocabs.LINKREL_PROPERTIES.class).contains(PackageVocabs.LINKREL_PROPERTIES.ALTERNATE) && linkRelProperties.size() > 1) {
            this.report.message(MessageId.OPF_089, this.location(), new Object[0]);
        }
        return linkRelProperties;
    }

    private void processMeta() {
        XMLElement e = this.currentElement();
        Optional<Property> prop = VocabUtil.parseProperty(e.getAttribute("property"), this.metaVocabs, this.context, this.location());
        if (prop.isPresent() && !this.metadataBuilders.isEmpty()) {
            String value = Strings.nullToEmpty((String)e.getPrivateData("text")).trim();
            this.metadataBuilders.peekFirst().meta(e.getAttribute("id"), prop.get(), value, e.getAttribute("refines"));
            if (this.metadataBuilders.size() == 1) {
                switch (prop.get().getPrefixedName()) {
                    case "media:active-class": {
                        this.context.featureReport.report(FeatureEnum.MEDIA_OVERLAYS_ACTIVE_CLASS, this.location(), e.getPrivateData().toString());
                        break;
                    }
                    case "media:playback-active-class": {
                        this.context.featureReport.report(FeatureEnum.MEDIA_OVERLAYS_PLAYBACK_ACTIVE_CLASS, this.location(), e.getPrivateData().toString());
                        break;
                    }
                    case "rendition:spread": {
                        if (!value.equals("portrait")) break;
                        this.report.message(MessageId.OPF_086, this.location(), "rendition:spread portrait", LocalizedMessages.getInstance(this.context.locale).getSuggestion(MessageId.OPF_086, null));
                        break;
                    }
                }
            }
        }
        VocabUtil.parseProperty(e.getAttribute("scheme"), this.metaVocabs, this.context, this.location());
    }

    private void processDCElem() {
        String language;
        XMLElement e = this.currentElement();
        Optional<Property> prop = DCMESVocab.VOCAB.lookup(e.getName());
        if (prop.isPresent() && !this.metadataBuilders.isEmpty()) {
            this.metadataBuilders.peekFirst().meta(e.getAttribute("id"), prop.get(), (String)e.getPrivateData("text"), null);
        }
        if ("language".equals(e.getName()) && (language = (String)e.getPrivateData("text")) != null && !language.trim().isEmpty()) {
            this.checkLanguageTag(language.trim());
        }
    }

    private void processItemsInIndexCollection(ResourceCollection collection) {
        if (collection.hasRole(ResourceCollection.Roles.INDEX) || collection.hasRole(ResourceCollection.Roles.INDEX_GROUP)) {
            for (LinkedResource resource : collection.getResources().asList()) {
                OPFItem.Builder itemBuilder = (OPFItem.Builder)this.itemBuildersByURL.get(resource.getDocumentURL());
                if (itemBuilder == null) continue;
                itemBuilder.properties(ImmutableSet.of(EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.IN_INDEX_COLLECTION)));
            }
            for (ResourceCollection childCollection : collection.getCollections().asList()) {
                this.processItemsInIndexCollection(childCollection);
            }
        }
    }

    private void checkLanguageTag(String language) {
        try {
            new Locale.Builder().setLanguageTag(language);
        }
        catch (IllformedLocaleException exception) {
            this.report.message(MessageId.OPF_092, this.location(), language, exception.getMessage());
        }
    }

    protected void reportMetadata() {
        Optional<MetadataSet.Metadata> spread;
        Optional<MetadataSet.Metadata> orientation;
        if (this.getMetadata().containsPrimary(RenditionVocabs.META_VOCAB.get(RenditionVocabs.META_PROPERTIES.LAYOUT), "pre-paginated")) {
            this.report.info(null, FeatureEnum.RENDITION_LAYOUT, "pre-paginated");
            this.report.info(null, FeatureEnum.HAS_FIXED_LAYOUT, "true");
        }
        if ((orientation = MetadataSet.tryFind(this.getMetadata().getAll(), RenditionVocabs.META_VOCAB.get(RenditionVocabs.META_PROPERTIES.ORIENTATION), Optional.absent())).isPresent()) {
            this.report.info(null, FeatureEnum.RENDITION_ORIENTATION, orientation.get().getValue());
        }
        if ((spread = MetadataSet.tryFind(this.getMetadata().getAll(), RenditionVocabs.META_VOCAB.get(RenditionVocabs.META_PROPERTIES.SPREAD), Optional.absent())).isPresent()) {
            this.report.info(null, FeatureEnum.RENDITION_SPREAD, spread.get().getValue());
        }
    }

    @Override
    protected void reportItem(OPFItem item) {
        super.reportItem(item);
        Set<RenditionVocabs.ITEMREF_PROPERTIES> properties = Property.filter(item.getProperties(), RenditionVocabs.ITEMREF_PROPERTIES.class);
        for (RenditionVocabs.ITEMREF_PROPERTIES property : properties) {
            switch (property) {
                case LAYOUT_PRE_PAGINATED: {
                    this.report.info(item.getPath(), FeatureEnum.RENDITION_LAYOUT, "pre-paginated");
                    this.report.info(item.getPath(), FeatureEnum.HAS_FIXED_LAYOUT, "true");
                    break;
                }
                case LAYOUT_REFLOWABLE: {
                    this.report.info(item.getPath(), FeatureEnum.RENDITION_LAYOUT, "reflowable");
                    this.report.info(item.getPath(), FeatureEnum.HAS_FIXED_LAYOUT, "false");
                    break;
                }
                case ORIENTATION_AUTO: 
                case ORIENTATION_LANDSCAPE: 
                case ORIENTATION_PORTRAIT: {
                    this.report.info(item.getPath(), FeatureEnum.RENDITION_ORIENTATION, property.name().substring(12).toLowerCase(Locale.ROOT));
                    break;
                }
                case SPREAD_AUTO: 
                case SPREAD_BOTH: 
                case SPREAD_LANDSCAPE: 
                case SPREAD_NONE: 
                case SPREAD_PORTRAIT: {
                    this.report.info(item.getPath(), FeatureEnum.RENDITION_SPREAD, property.name().substring(7).toLowerCase(Locale.ROOT));
                    break;
                }
            }
        }
    }
}

