/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.ValidationContext;
import com.google.common.base.Preconditions;
import org.w3c.epubcheck.core.AbstractChecker;

public class PublicationResourceChecker
extends AbstractChecker {
    public PublicationResourceChecker(ValidationContext context) {
        super(context);
    }

    @Override
    public final void check() {
        boolean cont = !this.context.container.isPresent() || this.checkPublicationBeforeContent();
        cont = cont && this.checkContent();
        cont = cont && !this.context.container.isPresent() || this.checkPublicationAfterContent();
    }

    protected boolean checkPublicationBeforeContent() {
        return PublicationResourceChecker.checkResourceExists(this.context) && PublicationResourceChecker.checkResourceCanBeDecrypted(this.context);
    }

    protected boolean checkContent() {
        return true;
    }

    protected boolean checkPublicationAfterContent() {
        return true;
    }

    private static boolean checkResourceExists(ValidationContext context) {
        Preconditions.checkState(context.container.isPresent());
        if (!context.container.get().contains(context.url)) {
            context.report.message(MessageId.RSC_001, EPUBLocation.of(context), context.path);
            return false;
        }
        return true;
    }

    private static boolean checkResourceCanBeDecrypted(ValidationContext context) {
        Preconditions.checkState(context.container.isPresent());
        if (!context.container.get().canDecrypt(context.url)) {
            context.report.message(MessageId.RSC_004, EPUBLocation.of(context), context.path);
            return false;
        }
        return true;
    }
}

