/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.opf.ResourceCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;

public final class ResourceCollections {
    private final List<ResourceCollection> collections;
    private final ListMultimap<String, ResourceCollection> collectionsByRole;

    private ResourceCollections(Iterable<ResourceCollection> collections) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        ImmutableListMultimap.Builder byRoleBuilder = ImmutableListMultimap.builder();
        for (ResourceCollection collection : collections) {
            listBuilder.add(collection);
            for (String role : collection.getRoles()) {
                byRoleBuilder.put(role, collection);
            }
        }
        this.collections = listBuilder.build();
        this.collectionsByRole = byRoleBuilder.build();
    }

    public List<ResourceCollection> asList() {
        return this.collections;
    }

    public List<ResourceCollection> getByRole(String role) {
        return this.collectionsByRole.get((Object)role);
    }

    public List<ResourceCollection> getByRole(ResourceCollection.Roles role) {
        return role == null ? ImmutableList.of() : this.getByRole(role.toString());
    }

    public boolean hasRole(String role) {
        return !this.collectionsByRole.get((Object)role).isEmpty();
    }

    public boolean hasRole(ResourceCollection.Roles role) {
        return role != null && this.hasRole(role.toString());
    }

    public static final Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final LinkedHashSet<ResourceCollection> collections = Sets.newLinkedHashSet();

        public Builder add(ResourceCollection collection) {
            if (collection != null) {
                this.collections.add(collection);
            }
            return this;
        }

        public ResourceCollections build() {
            return new ResourceCollections(this.collections);
        }
    }
}

