/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ops;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.css.CSSChecker;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.URISchemes;
import com.adobe.epubcheck.xml.handlers.XMLHandler;
import com.adobe.epubcheck.xml.model.XMLElement;
import io.mola.galimatias.URL;
import java.util.Locale;
import java.util.Stack;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.ProcInstParser;
import org.w3c.epubcheck.constants.MIMEType;
import org.w3c.epubcheck.core.references.Reference;
import org.xml.sax.SAXException;

public class OPSHandler
extends XMLHandler {
    protected long openElements;
    protected long charsCount;
    protected int tableDepth = 0;
    protected boolean hasTh = false;
    protected boolean hasThead = false;
    protected boolean hasCaption = false;
    protected boolean hasCSS = false;
    protected boolean epubTypeInUse = false;
    protected StringBuilder textNode;
    protected Stack<EPUBLocation> elementLocationStack = new Stack();

    public OPSHandler(ValidationContext context) {
        super(context);
    }

    private void checkPaint(String attr) {
        String paint = this.currentElement().getAttribute(attr);
        if (paint != null && paint.startsWith("url(") && paint.endsWith(")")) {
            URL url = this.checkURL(paint.substring(4, paint.length() - 1));
            this.registerReference(url, Reference.Type.SVG_PAINT);
        }
    }

    protected void checkImage(String attrNS, String attr) {
        URL imageURL = this.checkURL(this.currentElement().getAttributeNS(attrNS, attr));
        if (imageURL != null) {
            this.registerReference(imageURL, Reference.Type.IMAGE);
        }
    }

    protected void checkObject() {
        URL objectURL = this.checkURL(this.currentElement().getAttribute("data"));
        if (objectURL != null) {
            this.registerReference(objectURL, Reference.Type.GENERIC);
        }
    }

    protected void checkLink() {
        XMLElement e = this.currentElement();
        URL href = this.checkURL(e.getAttribute("href"));
        String rel = e.getAttribute("rel");
        if (href != null && rel != null && rel.toLowerCase(Locale.ROOT).contains("stylesheet")) {
            this.hasCSS = true;
            this.registerReference(href, Reference.Type.STYLESHEET);
        }
    }

    protected void checkSymbol() {
        URL href = this.checkURL(this.currentElement().getAttributeNS("http://www.w3.org/1999/xlink", "href"));
        if (href != null) {
            this.registerReference(href, Reference.Type.SVG_SYMBOL);
        }
    }

    private void checkHRef(String attrNS, String attr) {
        String href = this.currentElement().getAttributeNS(attrNS, attr);
        if (href == null) {
            return;
        }
        if ((href = href.trim()).isEmpty()) {
            this.report.message(MessageId.HTM_045, this.location(), new Object[0]);
            return;
        }
        if (".".equals(href)) {
            return;
        }
        URL url = this.checkURL(href);
        if (url == null) {
            return;
        }
        if (this.context.isRemote(url)) {
            this.report.info(this.path, FeatureEnum.REFERENCE, href);
            if (!URISchemes.contains(url.scheme())) {
                this.report.message(MessageId.HTM_025, this.location().context(href), new Object[0]);
            }
            return;
        }
        this.processHyperlink(url);
    }

    protected URL checkSVGFontFaceURI() {
        URL href = this.checkURL(this.currentElement().getAttributeNS("http://www.w3.org/1999/xlink", "href"));
        if (href != null) {
            this.registerReference(href, Reference.Type.FONT);
        }
        return href;
    }

    protected void processHyperlink(URL href) {
        this.registerReference(href, Reference.Type.HYPERLINK);
    }

    @Override
    public void startElement() {
        String eNS;
        ++this.openElements;
        XMLElement e = this.currentElement();
        this.elementLocationStack.push(this.location());
        String id = e.getAttribute("id");
        if (!this.epubTypeInUse && (eNS = e.getAttributeNS("http://www.idpf.org/2007/ops", "type")) != null) {
            this.epubTypeInUse = true;
        }
        String ns = e.getNamespace();
        String name = e.getName().toLowerCase(Locale.ROOT);
        Reference.Type resourceType = Reference.Type.GENERIC;
        if (ns != null) {
            if (name.equals("style")) {
                this.textNode = new StringBuilder();
            }
            if (ns.equals("http://www.w3.org/2000/svg")) {
                if (name.equals("lineargradient") || name.equals("radialgradient") || name.equals("pattern")) {
                    resourceType = Reference.Type.SVG_PAINT;
                } else if (name.equals("clippath")) {
                    resourceType = Reference.Type.SVG_CLIP_PATH;
                } else if (name.equals("symbol")) {
                    resourceType = Reference.Type.SVG_SYMBOL;
                } else if (name.equals("a")) {
                    this.checkHRef("http://www.w3.org/1999/xlink", "href");
                } else if (name.equals("use")) {
                    this.checkSymbol();
                } else if (name.equals("image")) {
                    this.checkImage("http://www.w3.org/1999/xlink", "href");
                } else if (name.equals("font-face-uri")) {
                    this.checkSVGFontFaceURI();
                } else if (name.equals("script")) {
                    this.checkScript();
                }
                this.checkPaint("fill");
                this.checkPaint("stroke");
            } else if (ns.equals("http://www.w3.org/1999/xhtml")) {
                if (name.equals("a") || name.equals("area")) {
                    this.checkHRef(null, "href");
                } else if (name.equals("img")) {
                    this.checkImage(null, "src");
                } else if (name.equals("object")) {
                    this.checkObject();
                } else if (name.equals("link")) {
                    this.checkLink();
                } else if (name.equals("iframe")) {
                    this.checkIFrame();
                } else if (name.equals("table")) {
                    ++this.tableDepth;
                } else if (name.equals("th") && this.tableDepth > 0) {
                    this.hasTh = true;
                } else if (name.equals("thead") && this.tableDepth > 0) {
                    this.hasThead = true;
                } else if (name.equals("caption") && this.tableDepth > 0) {
                    this.hasCaption = true;
                } else if (name.equals("i") || name.equals("b") || name.equals("em") || name.equals("strong")) {
                    this.checkBoldItalics();
                } else if (name.equals("script")) {
                    this.checkScript();
                }
                String style = e.getAttribute("style");
                if (style != null && style.length() > 0) {
                    new CSSChecker(this.context, style, this.location().getLine(), true).check();
                }
            }
        }
        if (this.context.resourceRegistry.isPresent() && id != null) {
            this.context.resourceRegistry.get().registerID(id, resourceType, this.location().url);
        }
    }

    protected void checkBoldItalics() {
    }

    protected void checkIFrame() {
    }

    protected void checkScript() {
        String type = this.currentElement().getAttribute("type");
        if (type == null || OPFChecker.isScriptType(type)) {
            this.processJavascript();
        }
    }

    protected void processJavascript() {
        this.report.info(this.path, FeatureEnum.HAS_SCRIPTS, "");
        this.context.featureReport.report(FeatureEnum.HAS_SCRIPTS, this.location());
    }

    @Override
    public void endElement() {
        --this.openElements;
        XMLElement e = this.currentElement();
        String ns = e.getNamespace();
        String name = e.getName();
        if (this.openElements == 0L) {
            this.report.info(this.path, FeatureEnum.CHARS_COUNT, Long.toString(this.charsCount));
            if (!this.epubTypeInUse) {
                if (this.context.version == EPUBVersion.VERSION_3) {
                    this.report.message(MessageId.ACC_007, EPUBLocation.of(this.context), new Object[0]);
                }
            } else {
                this.epubTypeInUse = false;
            }
        }
        EPUBLocation currentLocation = this.elementLocationStack.pop();
        if ("style".equals(name)) {
            String style = this.textNode.toString();
            if (style.length() > 0) {
                this.hasCSS = true;
                new CSSChecker(this.context, style, currentLocation.getLine(), false).check();
            }
            this.textNode = null;
        }
        if ("http://www.w3.org/1999/xhtml".equals(ns) && "table".equals(name) && this.tableDepth > 0) {
            --this.tableDepth;
            EPUBLocation location = currentLocation.context("table");
            this.checkDependentCondition(MessageId.ACC_005, this.tableDepth == 0, this.hasTh, location);
            this.checkDependentCondition(MessageId.ACC_006, this.tableDepth == 0, this.hasThead, location);
            this.checkDependentCondition(MessageId.ACC_012, this.tableDepth == 0, this.hasCaption, location);
            this.hasCaption = false;
            this.hasThead = false;
            this.hasTh = false;
        }
    }

    protected void checkDependentCondition(MessageId id, boolean condition1, boolean condition2, EPUBLocation location) {
        if (condition1 && !condition2) {
            this.report.message(id, location, new Object[0]);
        }
    }

    @Override
    public void characters(char[] chars, int start, int length) {
        this.charsCount += (long)length;
        if (this.textNode != null) {
            this.textNode.append(chars, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        super.processingInstruction(target, data);
        if (MIMEType.SVG.is(this.context.mimeType) && "xml-stylesheet".equals(target)) {
            this.checkXMLStylesheetPI(data);
        }
    }

    protected void checkXMLStylesheetPI(String data) {
        assert (data != null);
        try {
            String href;
            URL url;
            String type = ProcInstParser.getPseudoAttribute(data, "type");
            if ((type == null || MIMEType.CSS.is(type)) && (url = this.checkURL(href = ProcInstParser.getPseudoAttribute(data, "href"))) != null) {
                this.hasCSS = true;
                this.registerReference(url, Reference.Type.STYLESHEET);
            }
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
    }
}

