/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.xml;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.sf.saxon.om.NameChecker;

public final class HTMLUtils {
    private static final Set<String> KNOWN_XHTML_NAMESPACES = ImmutableSet.of("http://www.w3.org/1999/xhtml", "http://www.w3.org/XML/1998/namespace", "http://www.idpf.org/2007/ops", "http://www.w3.org/2000/svg", "http://www.w3.org/1998/Math/MathML", "http://www.w3.org/2001/10/synthesis", new String[]{"http://www.w3.org/2001/xml-events", "http://www.w3.org/1999/xlink"});
    private static final Set<String> CASE_INSENSITIVE_ATTRIBUTES = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("align")).add("allowfullscreen")).add("allowpaymentrequest")).add("allowusermedia")).add("async")).add("autocapitalize")).add("autocomplete")).add("autofocus")).add("autoplay")).add("checked")).add("contenteditable")).add("controls")).add("crossorigin")).add("default")).add("defer")).add("dir")).add("disabled")).add("draggable")).add("formnovalidate")).add("hidden")).add("http-equiv")).add("ismap")).add("itemscope")).add("kind")).add("loop")).add("multiple")).add("muted")).add("nomodule")).add("novalidate")).add("open")).add("playsinline")).add("preload")).add("readonly")).add("required")).add("reversed")).add("scope")).add("selected")).add("shape")).add("sizes")).add("spellcheck")).add("step")).add("translate")).add("type")).add("typemustmatch")).add("valign")).add("value")).add("wrap")).build();

    public static boolean isCustomElement(String namespace, String name) {
        return "http://www.w3.org/1999/xhtml".equals(namespace) && Preconditions.checkNotNull(name).contains("-");
    }

    public static boolean isCustomNamespace(String namespace) {
        return namespace != null && !namespace.trim().isEmpty() && !KNOWN_XHTML_NAMESPACES.contains(namespace.trim());
    }

    public static boolean isCaseInsensitiveAttribute(String namespace, String name) {
        return namespace.isEmpty() && CASE_INSENSITIVE_ATTRIBUTES.contains(name);
    }

    public static boolean isDataAttribute(String namespace, String name) {
        return namespace.isEmpty() && name.startsWith("data-");
    }

    public static boolean isValidDataAttribute(String name) {
        Preconditions.checkArgument(name != null && name.startsWith("data-"));
        name = name.substring(5);
        return !name.isEmpty() && NameChecker.isValidNCName(name) && !name.matches(".*[A-Z].*");
    }

    private HTMLUtils() {
    }
}

