/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonassert.impl.matcher;

import com.jayway.jsonassert.impl.matcher.MapTypeSafeMatcher;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;

public class IsMapContainingKey<K>
extends MapTypeSafeMatcher<Map<K, ?>> {
    private final Matcher<K> keyMatcher;

    public IsMapContainingKey(Matcher<K> keyMatcher) {
        this.keyMatcher = keyMatcher;
    }

    @Override
    public boolean matchesSafely(Map<K, ?> item) {
        for (K key : item.keySet()) {
            if (!this.keyMatcher.matches(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("map with key ").appendDescriptionOf(this.keyMatcher);
    }

    public static <K> Matcher<Map<K, ?>> hasKey(K key) {
        return IsMapContainingKey.hasKey(IsEqual.equalTo(key));
    }

    public static <K> Matcher<Map<K, ?>> hasKey(Matcher<K> keyMatcher) {
        return new IsMapContainingKey<K>(keyMatcher);
    }
}

