/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonassert.impl.matcher;

import com.jayway.jsonassert.impl.matcher.MapTypeSafeMatcher;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;

public class IsMapContainingValue<V>
extends MapTypeSafeMatcher<Map<?, V>> {
    private final Matcher<? super V> valueMatcher;

    public IsMapContainingValue(Matcher<? super V> valueMatcher) {
        this.valueMatcher = valueMatcher;
    }

    @Override
    public boolean matchesSafely(Map<?, V> item) {
        for (V value : item.values()) {
            if (!this.valueMatcher.matches(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("map with value ").appendDescriptionOf(this.valueMatcher);
    }

    public static <V> Matcher<? super Map<?, V>> hasValue(V value) {
        return IsMapContainingValue.hasValue(IsEqual.equalTo(value));
    }

    public static <V> Matcher<? super Map<?, V>> hasValue(Matcher<? super V> valueMatcher) {
        return new IsMapContainingValue<V>(valueMatcher);
    }
}

