/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module.png;

import com.mcgath.jhove.module.png.MessageConstants;
import com.mcgath.jhove.module.png.PNGChunk;
import com.mcgath.jhove.module.png.PNGException;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;

public class GamaChunk
extends PNGChunk {
    public GamaChunk(int sig, long leng) {
        this.chunkType = sig;
        this.length = leng;
        this.ancillary = true;
        this.duplicateAllowed = false;
    }

    @Override
    public void processChunk(RepInfo info) throws Exception {
        this.processChunkCommon(info);
        if (this._module.isPlteSeen() || this._module.isIdatSeen()) {
            ErrorMessage msg = new ErrorMessage(MessageConstants.PNG_GDM_7);
            info.setMessage(msg);
            info.setWellFormed(false);
            throw new PNGException(MessageConstants.PNG_GDM_8);
        }
        if (this.length != 4L) {
            ErrorMessage msg = new ErrorMessage(MessageConstants.PNG_GDM_9, String.format(MessageConstants.PNG_GDM_9_SUB.getMessage(), this.length));
            info.setMessage(msg);
            info.setWellFormed(false);
            throw new PNGException(MessageConstants.PNG_GDM_8);
        }
        int gamma = (int)this.readUnsignedInt();
        Rational ratGamma = new Rational(100000, gamma);
        Property gammaProp = new Property("Gamma", PropertyType.RATIONAL, ratGamma);
        this._propList.add(gammaProp);
        if (this._module.isPlteSeen()) {
            ErrorMessage msg = new ErrorMessage(MessageConstants.PNG_GDM_10);
            info.setMessage(msg);
            info.setWellFormed(false);
            throw new PNGException(MessageConstants.PNG_GDM_8);
        }
        if (this._module.isIdatSeen()) {
            ErrorMessage msg = new ErrorMessage(MessageConstants.PNG_GDM_11);
            info.setMessage(msg);
            info.setWellFormed(false);
            throw new PNGException(MessageConstants.PNG_GDM_8);
        }
    }
}

