/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module.png;

import com.mcgath.jhove.module.png.MessageConstants;
import com.mcgath.jhove.module.png.PNGChunk;
import com.mcgath.jhove.module.png.PNGException;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.messages.JhoveMessage;
import edu.harvard.hul.ois.jhove.messages.JhoveMessages;

public class IhdrChunk
extends PNGChunk {
    private static final int COLOR_GRAYSCALE = 0;
    private static final int COLOR_TRUE = 2;
    private static final int COLOR_INDEXED = 3;
    private static final int COLOR_GRAYSCALE_ALPHA = 4;
    private static final int COLOR_TRUE_ALPHA = 6;
    private static final String[] colorTypeNames = new String[]{"Greyscale", "", "Truecolour", "Indexed-colour", "Greyscale with alpha", "", "Truecolour with alpha"};
    private static final int[][] allowedBitDepths = new int[][]{{1, 2, 4, 8, 16}, new int[0], {8, 16}, {1, 2, 4, 8}, {8, 16}, new int[0], {8, 16}};
    private long width;
    private long height;
    private int bitDepth;
    private int colorType;
    private int compression;
    private int filter;
    private int interlace;

    public IhdrChunk(int sig, long leng) {
        this.chunkType = sig;
        this.length = leng;
        this.ancillary = false;
    }

    @Override
    public void processChunk(RepInfo info) throws Exception {
        String interlaceStr;
        Object msg;
        boolean badChunk = false;
        this.processChunkCommon(info);
        if (this._module.isIhdrSeen()) {
            ErrorMessage msg2 = new ErrorMessage(MessageConstants.PNG_GDM_22);
            info.setMessage(msg2);
            info.setWellFormed(false);
            throw new PNGException(MessageConstants.PNG_GDM_23);
        }
        this._module.setIhdrSeen(true);
        if (this.length < 13L) {
            ErrorMessage msg3 = new ErrorMessage(MessageConstants.PNG_GDM_24);
            info.setMessage(msg3);
            throw new PNGException(MessageConstants.PNG_GDM_25);
        }
        this.width = this.readUnsignedInt();
        this.height = this.readUnsignedInt();
        this.bitDepth = this.readUnsignedByte();
        this.colorType = this.readUnsignedByte();
        this.compression = this.readUnsignedByte();
        this.filter = this.readUnsignedByte();
        this.interlace = this.readUnsignedByte();
        int i = 0;
        while ((long)i < this.length - 13L) {
            this.readUnsignedByte();
            ++i;
        }
        this._nisoMetadata.setImageWidth(this.width);
        this._nisoMetadata.setImageLength(this.height);
        int[] bits = new int[]{this.bitDepth};
        this._nisoMetadata.setBitsPerSample(bits);
        boolean ctErr = false;
        try {
            this._nisoMetadata.setColorSpace(IhdrChunk.colorTypeToNiso(this.colorType));
            this._module.setColorType(this.colorType);
        }
        catch (PNGException e) {
            ctErr = true;
        }
        if (ctErr || this.colorType == 1 || this.colorType == 5 || this.colorType > 6) {
            msg = JhoveMessages.getMessageInstance(MessageConstants.PNG_GDM_28.getId(), MessageConstants.PNG_GDM_28.getId() + this.colorType);
            info.setMessage(new ErrorMessage((JhoveMessage)msg));
            info.setWellFormed(false);
            badChunk = true;
        } else {
            if (!IhdrChunk.colorAndDepthOK(this.colorType, this.bitDepth)) {
                msg = new ErrorMessage(MessageConstants.PNG_GDM_26, String.format(MessageConstants.PNG_GDM_26_SUB.getMessage(), this.colorType, this.bitDepth));
                info.setMessage((Message)msg);
                info.setWellFormed(false);
                badChunk = true;
            }
            this._propList.add(new Property("ColorType", PropertyType.STRING, colorTypeNames[this.colorType]));
        }
        String compressionStr = this.compression == 0 ? "Deflate" : Integer.toString(this.compression);
        this._propList.add(new Property("Compression", PropertyType.STRING, compressionStr));
        this._propList.add(new Property("Filter type", PropertyType.INTEGER, this.filter));
        switch (this.interlace) {
            case 0: {
                interlaceStr = "None";
                break;
            }
            case 1: {
                interlaceStr = "Adam7";
                break;
            }
            default: {
                interlaceStr = Integer.toString(this.interlace);
            }
        }
        this._propList.add(new Property("Interlace", PropertyType.STRING, interlaceStr));
        if (badChunk) {
            throw new PNGException(MessageConstants.PNG_GDM_27);
        }
    }

    private static int colorTypeToNiso(int typ) throws PNGException {
        int val = 0;
        switch (typ) {
            case 0: 
            case 4: {
                val = 0;
                break;
            }
            case 2: 
            case 6: {
                val = 2;
                break;
            }
            case 3: {
                val = 3;
                break;
            }
            default: {
                throw new PNGException(MessageConstants.PNG_GDM_28);
            }
        }
        return val;
    }

    private static boolean colorAndDepthOK(int color, int depth) {
        int[] allowedDepths = allowedBitDepths[color];
        boolean ok = false;
        for (int d : allowedDepths) {
            if (d != depth) continue;
            ok = true;
        }
        return ok;
    }
}

