/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module.png;

import com.mcgath.jhove.module.PngModule;
import com.mcgath.jhove.module.png.BkgdChunk;
import com.mcgath.jhove.module.png.ChrmChunk;
import com.mcgath.jhove.module.png.GamaChunk;
import com.mcgath.jhove.module.png.HistChunk;
import com.mcgath.jhove.module.png.IccpChunk;
import com.mcgath.jhove.module.png.IdatChunk;
import com.mcgath.jhove.module.png.IendChunk;
import com.mcgath.jhove.module.png.IhdrChunk;
import com.mcgath.jhove.module.png.ItxtChunk;
import com.mcgath.jhove.module.png.MessageConstants;
import com.mcgath.jhove.module.png.PNGException;
import com.mcgath.jhove.module.png.PhysChunk;
import com.mcgath.jhove.module.png.PlteChunk;
import com.mcgath.jhove.module.png.SbitChunk;
import com.mcgath.jhove.module.png.SpltChunk;
import com.mcgath.jhove.module.png.SrgbChunk;
import com.mcgath.jhove.module.png.TextChunk;
import com.mcgath.jhove.module.png.TimeChunk;
import com.mcgath.jhove.module.png.TrnsChunk;
import com.mcgath.jhove.module.png.UnknownChunk;
import com.mcgath.jhove.module.png.ZtxtChunk;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.RepInfo;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.CRC32;

public abstract class PNGChunk {
    protected long length = 0L;
    protected int chunkType = 0;
    protected char[] chunkData = null;
    protected CRC32 crc = new CRC32();
    protected boolean ancillary;
    protected boolean duplicateAllowed;
    protected NisoImageMetadata _nisoMetadata;
    protected PngModule _module;
    protected DataInputStream _dstream;
    protected List<Property> _propList;
    protected static final int IHDR_HEAD_SIG = 1229472850;
    protected static final int PLTE_HEAD_SIG = 1347179589;
    protected static final int IDAT_HEAD_SIG = 1229209940;
    protected static final int IEND_HEAD_SIG = 1229278788;
    protected static final int cHRM_HEAD_SIG = 1665684045;
    protected static final int gAMA_HEAD_SIG = 1732332865;
    protected static final int iCCP_HEAD_SIG = 1766015824;
    protected static final int sBIT_HEAD_SIG = 1933723988;
    protected static final int sRGB_HEAD_SIG = 1934772034;
    protected static final int tEXt_HEAD_SIG = 1950701684;
    protected static final int zTXt_HEAD_SIG = 2052348020;
    protected static final int iTXt_HEAD_SIG = 1767135348;
    protected static final int bKGD_HEAD_SIG = 1649100612;
    protected static final int hIST_HEAD_SIG = 1749635924;
    protected static final int pHYs_HEAD_SIG = 1883789683;
    protected static final int sPLT_HEAD_SIG = 1934642260;
    protected static final int tIME_HEAD_SIG = 1950960965;
    protected static final int tRNS_HEAD_SIG = 1951551059;

    public static PNGChunk makePNGChunk(long length, int sig) {
        switch (sig) {
            case 1229472850: {
                return new IhdrChunk(sig, length);
            }
            case 1229209940: {
                return new IdatChunk(sig, length);
            }
            case 1229278788: {
                return new IendChunk(sig, length);
            }
            case 1347179589: {
                return new PlteChunk(sig, length);
            }
            case 1649100612: {
                return new BkgdChunk(sig, length);
            }
            case 1665684045: {
                return new ChrmChunk(sig, length);
            }
            case 1732332865: {
                return new GamaChunk(sig, length);
            }
            case 1749635924: {
                return new HistChunk(sig, length);
            }
            case 1766015824: {
                return new IccpChunk(sig, length);
            }
            case 1767135348: {
                return new ItxtChunk(sig, length);
            }
            case 1883789683: {
                return new PhysChunk(sig, length);
            }
            case 1933723988: {
                return new SbitChunk(sig, length);
            }
            case 1934642260: {
                return new SpltChunk(sig, length);
            }
            case 1934772034: {
                return new SrgbChunk(sig, length);
            }
            case 1950701684: {
                return new TextChunk(sig, length);
            }
            case 1950960965: {
                return new TimeChunk(sig, length);
            }
            case 1951551059: {
                return new TrnsChunk(sig, length);
            }
            case 2052348020: {
                return new ZtxtChunk(sig, length);
            }
        }
        return new UnknownChunk(sig, length);
    }

    public void setNisoMetadata(NisoImageMetadata nmd) {
        this._nisoMetadata = nmd;
    }

    public void setPropertyList(List<Property> lst) {
        this._propList = lst;
    }

    public void setModule(PngModule mdl) {
        this._module = mdl;
    }

    public void setInputStream(DataInputStream dstrm) {
        this._dstream = dstrm;
    }

    public long getLength() {
        return this.length;
    }

    public int getChunkType() {
        return this.chunkType;
    }

    public char[] getChunkData() {
        return this.chunkData;
    }

    public long getCRC() {
        return this.crc.getValue();
    }

    public void processChunk(RepInfo info) throws Exception {
        this.processChunkCommon(info);
        this._module.eatChunk(this);
    }

    public void processChunkCommon(RepInfo info) throws PNGException {
        if (this.ancillary && !this.duplicateAllowed) {
            if (this._module.isChunkSeen(this.chunkType)) {
                ErrorMessage msg = new ErrorMessage(MessageConstants.PNG_GDM_38, String.format(MessageConstants.PNG_GDM_38_SUB.getMessage(), this.chunkTypeString()));
                info.setMessage(msg);
                info.setWellFormed(false);
                throw new PNGException(MessageConstants.PNG_GDM_39);
            }
            this._module.setChunkSeen(this.chunkType);
        }
        int[] chunkTypeVal = this.chunkTypeBytes();
        for (int i = 0; i < 4; ++i) {
            this.crc.update(chunkTypeVal[i]);
        }
    }

    public long readUnsignedInt() throws IOException {
        long val = 0L;
        for (int i = 0; i < 4; ++i) {
            int b = this._dstream.readUnsignedByte();
            val = val << 8 | (long)b;
            this.crc.update(b);
        }
        return val;
    }

    public int readUnsignedShort() throws IOException {
        int val = 0;
        for (int i = 0; i < 2; ++i) {
            int b = this._dstream.readUnsignedByte();
            val = val << 8 | b;
            this.crc.update(b);
        }
        return val;
    }

    public int readUnsignedByte() throws IOException {
        int b = this._dstream.readUnsignedByte();
        this.crc.update(b);
        return b;
    }

    public void skipBytes(int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            int b = this._dstream.readUnsignedByte();
            this.crc.update(b);
        }
    }

    public long readCRC() throws IOException {
        long c = ModuleBase.readUnsignedInt(this._dstream, true);
        return c;
    }

    public String chunkTypeString() {
        int[] bytes = this.chunkTypeBytes();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            int b = bytes[i];
            if (b < 32) {
                sb.append("?");
                continue;
            }
            sb.append((char)b);
        }
        return sb.toString();
    }

    private int[] chunkTypeBytes() {
        int[] bytes = new int[]{this.chunkType >> 24 & 0x7F, this.chunkType >> 16 & 0x7F, this.chunkType >> 8 & 0x7F, this.chunkType & 0x7F};
        return bytes;
    }
}

