/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module.png;

import com.mcgath.jhove.module.png.MessageConstants;
import com.mcgath.jhove.module.png.PNGChunk;
import com.mcgath.jhove.module.png.PNGException;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.messages.JhoveMessage;
import edu.harvard.hul.ois.jhove.messages.JhoveMessages;

public class SpltChunk
extends PNGChunk {
    public SpltChunk(int sig, long leng) {
        this.chunkType = sig;
        this.length = leng;
        this.ancillary = true;
        this.duplicateAllowed = true;
    }

    @Override
    public void processChunk(RepInfo info) throws Exception {
        String paletteName = null;
        this.processChunkCommon(info);
        if (this._module.isIdatSeen()) {
            ErrorMessage msg = new ErrorMessage(MessageConstants.PNG_GDM_43);
            info.setMessage(msg);
            info.setWellFormed(false);
            throw new PNGException(MessageConstants.PNG_GDM_44);
        }
        int lengthLeft = (int)this.length;
        int maxNameLen = this.length > 80L ? 80 : (int)this.length;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < maxNameLen; ++i) {
            char c = (char)this.readUnsignedByte();
            --lengthLeft;
            if (c == '\u0000') {
                paletteName = sb.toString();
                break;
            }
            sb.append(c);
        }
        if (paletteName == null) {
            ErrorMessage msg = new ErrorMessage(MessageConstants.PNG_GDM_45);
            info.setMessage(msg);
            info.setWellFormed(false);
            throw new PNGException(MessageConstants.PNG_GDM_44);
        }
        int sampleDepth = this.readUnsignedByte();
        --lengthLeft;
        if (sampleDepth != 8 && sampleDepth != 16) {
            JhoveMessage msg = JhoveMessages.getMessageInstance(MessageConstants.PNG_GDM_46.getId(), String.format(MessageConstants.PNG_GDM_46_SUB.getMessage(), sampleDepth));
            info.setMessage(new ErrorMessage(msg));
            info.setWellFormed(false);
            throw new PNGException(MessageConstants.PNG_GDM_44);
        }
        if (sampleDepth == 8 && lengthLeft % 6 != 0 || sampleDepth == 16 && lengthLeft % 10 != 0) {
            ErrorMessage msg = new ErrorMessage(MessageConstants.PNG_GDM_47);
            info.setMessage(msg);
            info.setWellFormed(false);
            throw new PNGException(MessageConstants.PNG_GDM_44);
        }
        int nSamples = sampleDepth == 8 ? lengthLeft / 6 : lengthLeft / 10;
        this._module.addSplt(paletteName, sampleDepth, nSamples);
        for (int i = 0; i < lengthLeft; ++i) {
            this.readUnsignedByte();
        }
    }
}

