/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module.png;

import com.mcgath.jhove.module.png.GeneralTextChunk;
import com.mcgath.jhove.module.png.MessageConstants;
import com.mcgath.jhove.module.png.PNGException;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.RepInfo;
import java.util.zip.DataFormatException;

public class ZtxtChunk
extends GeneralTextChunk {
    public ZtxtChunk(int sig, long leng) {
        this.chunkType = sig;
        this.length = leng;
        this.ancillary = true;
        this.duplicateAllowed = true;
    }

    @Override
    public void processChunk(RepInfo info) throws Exception {
        this.processChunkCommon(info);
        StringBuilder sb = new StringBuilder();
        String keyword = null;
        String value = null;
        int cmprsIdx = 0;
        int state = 0;
        byte[] compressedData = new byte[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            int c = this.readUnsignedByte();
            switch (state) {
                case 0: {
                    if (c == 0) {
                        keyword = sb.toString();
                        state = 1;
                        break;
                    }
                    sb.append((char)c);
                    break;
                }
                case 1: {
                    if (c != 0) {
                        ErrorMessage msg = new ErrorMessage(MessageConstants.PNG_GDM_63, String.format(MessageConstants.PNG_GDM_63_SUB.getMessage(), c));
                        info.setMessage(msg);
                        info.setWellFormed(0);
                        throw new PNGException(MessageConstants.PNG_GDM_64);
                    }
                    state = 2;
                    compressedData = new byte[(int)this.length - i];
                    break;
                }
                case 2: {
                    compressedData[cmprsIdx++] = (byte)c;
                    break;
                }
            }
            ++i;
        }
        if (keyword != null) {
            try {
                value = this.inflateToText(compressedData);
            }
            catch (DataFormatException e) {
                ErrorMessage msg = new ErrorMessage(MessageConstants.PNG_GDM_65);
                info.setMessage(msg);
                info.setWellFormed(false);
                throw new PNGException(MessageConstants.PNG_GDM_64);
            }
        }
        this._module.addKeyword(keyword, value);
    }
}

