/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.messages.JhoveMessage;

public abstract class Message {
    public static final long NULL = -1L;
    protected final JhoveMessage jhoveMessage;
    protected final String subMessage;
    protected final long offset;
    protected final String prefix;

    protected Message(JhoveMessage message, String subMessage, long offset, String prefix) {
        this.jhoveMessage = message;
        this.subMessage = subMessage.isEmpty() ? null : subMessage;
        this.offset = offset;
        this.prefix = prefix;
    }

    public String getMessage() {
        return this.jhoveMessage.getMessage();
    }

    public String getSubMessage() {
        return this.subMessage;
    }

    public long getOffset() {
        return this.offset;
    }

    public String getId() {
        return this.jhoveMessage.getId();
    }

    public JhoveMessage getJhoveMessage() {
        return this.jhoveMessage;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String toString() {
        return "Message [message=" + this.jhoveMessage + ", _subMessage=" + this.subMessage + ", _offset=" + this.offset + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.jhoveMessage == null ? 0 : this.jhoveMessage.hashCode());
        result = 31 * result + (this.subMessage == null ? 0 : this.subMessage.hashCode());
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Message other = (Message)obj;
        if (this.jhoveMessage == null ? other.jhoveMessage != null : !this.jhoveMessage.equals(other.jhoveMessage)) {
            return false;
        }
        if (this.subMessage == null ? other.subMessage != null : !this.subMessage.equals(other.subMessage)) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        return !(this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix));
    }
}

