/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.warc;

import edu.harvard.hul.ois.jhove.module.warc.WarcRecordData;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jwat.warc.WarcRecord;

public class WarcRecordProperties {
    private final WarcRecordData data;
    private Map<String, String> properties;
    private static final String DATE_HEADER = "Warc-Date header value.";
    private static final String TARGET_URI_HEADER = "Warc-Target-URI header value.";
    private static final String WARCINFO_ID_HEADER = "Warc-Warcinfo-ID header value.";
    private static final String REFERS_TO_HEADER = "Warc-Refers-To header value.";
    private static final String CONCURRENT_TO_HEADER = "Warc-Concurrent-To header value.";
    private static final String IP_ADDRESS_HEADER = "Warc-IP-Address header value.";
    private static final String IP_ADDRESS_VERSION = "Ip-Address version.";
    private static final String PROTOCOL_VERSION_HEADER = "ProtocolVersion header value.";

    public WarcRecordProperties(WarcRecord record) {
        this.data = new WarcRecordData(record);
    }

    public Map<String, String> getProperties() {
        this.properties = new LinkedHashMap<String, String>();
        this.setBaseProperties();
        if (this.data.warcType != null) {
            if (this.data.warcType.equalsIgnoreCase("continuation")) {
                this.setContinuationRecordProperties();
            } else if (this.data.warcType.equalsIgnoreCase("conversion")) {
                this.setConversionRecordProperties();
            } else if (this.data.warcType.equalsIgnoreCase("metadata")) {
                this.setMetadataRecordProperties();
            } else if (this.data.warcType.equalsIgnoreCase("request")) {
                this.setRequestRecordProperties();
            } else if (this.data.warcType.equalsIgnoreCase("resource")) {
                this.setResourceRecordProperties();
            } else if (this.data.warcType.equalsIgnoreCase("response")) {
                this.setResponseRecordProperties();
            } else if (this.data.warcType.equalsIgnoreCase("revisit")) {
                this.setRevisitRecordProperties();
            } else if (this.data.warcType.equalsIgnoreCase("warcinfo")) {
                this.setWarcInfoRecordProperties();
            }
        }
        return this.properties;
    }

    private void setBaseProperties() {
        this.setProperty(this.data.startOffset, "Record offset in WARC file.");
        this.setProperty(this.data.warcVersionStr, DATE_HEADER);
        this.setProperty(this.data.warcDate, DATE_HEADER);
        this.setProperty(this.data.warcRecordId, "Warc-Record-ID header value.");
        this.setProperty(this.data.recordIdScheme, "Record-ID-Scheme value.");
        this.setProperty(this.data.contentType, "Content-Type header value.");
        this.setProperty(this.data.contentLength, "Content-Length header value.");
        this.setProperty(this.data.warcType, "Warc-Type header value.");
        this.setProperty(this.data.warcBlockDigest, "Warc-Block-Digest header value.");
        this.setProperty(this.data.warcBlockDigestAlgorithm, "Block-Digest-Algorithm value.");
        this.setProperty(this.data.warcBlockDigestEncoding, "Block-Digest-Encoding value.");
        this.setProperty(this.data.isValidBlockDigest, "isValidBlockDigest boolean value.");
        this.setProperty(this.data.warcPayloadDigest, "Warc-Payload-Digest header value.");
        this.setProperty(this.data.warcPayloadDigestAlgorithm, "Payload-Digest-Algorithm value.");
        this.setProperty(this.data.warcPayloadDigestEncoding, "Payload-Digest-Encoding value.");
        this.setProperty(this.data.isValidPayloadDigest, "isValidPayloadDigest boolean value.");
        this.setProperty(this.data.warcTruncated, "Warc-Truncated header value.");
        this.setProperty(this.data.bHasPayload, "hasPayload value.");
        this.setProperty(this.data.payloadLength, "PayloadLength value.");
        this.setProperty(this.data.warcIdentifiedPayloadType, "Warc-Identified-Payload-Type header value.");
        this.setProperty(this.data.warcSegmentNumber, "Warc-Segment-Number header value.");
        this.setProperty(this.data.bIsNonCompliant, "isNonCompliant value.");
        this.setProperty(this.data.computedBlockDigest, "Computed Block-Digest header value.");
        this.setProperty(this.data.computedBlockDigestAlgorithm, "Computed Block-Digest-Algorithm value.");
        this.setProperty(this.data.computedBlockDigestEncoding, "Computed Block-Digest-Encoding value.");
        this.setProperty(this.data.computedPayloadDigest, "Computed Payload-Digest header value.");
        this.setProperty(this.data.computedPayloadDigestAlgorithm, "Computed Payload-Digest-Algorithm value.");
        this.setProperty(this.data.computedPayloadDigestEncoding, "Computed Payload-Digest-Encoding value.");
    }

    private void setContinuationRecordProperties() {
        this.setProperty(this.data.warcTargetUri, TARGET_URI_HEADER);
        this.setProperty(this.data.warcSegmentOriginId, "Warc-Segment-Origin-ID header value.");
        this.setProperty(this.data.warcSegmentTotalLength, "Warc-Segment-Total-Length header value.");
        this.setProperty(this.data.warcWarcinfoId, WARCINFO_ID_HEADER);
    }

    private void setConversionRecordProperties() {
        this.setProperty(this.data.warcTargetUri, TARGET_URI_HEADER);
        this.setProperty(this.data.warcRefersTo, REFERS_TO_HEADER);
        this.setProperty(this.data.warcWarcinfoId, WARCINFO_ID_HEADER);
    }

    private void setMetadataRecordProperties() {
        this.setProperty(this.data.warcTargetUri, TARGET_URI_HEADER);
        this.setProperty(this.data.warcConcurrentToList, CONCURRENT_TO_HEADER);
        this.setProperty(this.data.warcRefersTo, REFERS_TO_HEADER);
        this.setProperty(this.data.warcIpAddress, IP_ADDRESS_HEADER);
        this.setProperty(this.data.ipVersion, IP_ADDRESS_VERSION);
        this.setProperty(this.data.warcWarcinfoId, WARCINFO_ID_HEADER);
    }

    private void setRequestRecordProperties() {
        this.setProperty(this.data.warcTargetUri, TARGET_URI_HEADER);
        this.setProperty(this.data.warcConcurrentToList, CONCURRENT_TO_HEADER);
        this.setProperty(this.data.warcIpAddress, IP_ADDRESS_HEADER);
        this.setProperty(this.data.ipVersion, IP_ADDRESS_VERSION);
        this.setProperty(this.data.warcWarcinfoId, WARCINFO_ID_HEADER);
        this.setProperty(this.data.protocolVersion, PROTOCOL_VERSION_HEADER);
        this.setProperty(this.data.protocolUserAgent, "ProtocolUserAgent header value.");
    }

    private void setResourceRecordProperties() {
        this.setProperty(this.data.warcTargetUri, TARGET_URI_HEADER);
        this.setProperty(this.data.warcConcurrentToList, CONCURRENT_TO_HEADER);
        this.setProperty(this.data.warcIpAddress, IP_ADDRESS_HEADER);
        this.setProperty(this.data.ipVersion, IP_ADDRESS_VERSION);
        this.setProperty(this.data.warcWarcinfoId, WARCINFO_ID_HEADER);
    }

    private void setResponseRecordProperties() {
        this.setProperty(this.data.warcTargetUri, TARGET_URI_HEADER);
        this.setProperty(this.data.warcConcurrentToList, CONCURRENT_TO_HEADER);
        this.setProperty(this.data.warcIpAddress, IP_ADDRESS_HEADER);
        this.setProperty(this.data.ipVersion, IP_ADDRESS_VERSION);
        this.setProperty(this.data.warcWarcinfoId, WARCINFO_ID_HEADER);
        this.setProperty(this.data.resultCode, "ProtocolResultCode header value.");
        this.setProperty(this.data.protocolVersion, PROTOCOL_VERSION_HEADER);
        this.setProperty(this.data.protocolContentType, "ProtocolContentType header value.");
        this.setProperty(this.data.protocolServer, "ServerName header value.");
    }

    private void setRevisitRecordProperties() {
        this.setProperty(this.data.warcTargetUri, TARGET_URI_HEADER);
        this.setProperty(this.data.warcProfile, "Warc-Profile header value.");
        this.setProperty(this.data.warcRefersTo, REFERS_TO_HEADER);
        this.setProperty(this.data.warcIpAddress, IP_ADDRESS_HEADER);
        this.setProperty(this.data.ipVersion, IP_ADDRESS_VERSION);
        this.setProperty(this.data.warcWarcinfoId, WARCINFO_ID_HEADER);
    }

    private void setWarcInfoRecordProperties() {
        this.setProperty(this.data.warcFilename, "WarcFilename header value.");
    }

    private void setProperty(String variable, String description) {
        if (variable != null && !variable.isEmpty()) {
            this.properties.put(description, variable);
        }
    }

    private void setProperty(Boolean variable, String description) {
        if (variable != null) {
            this.properties.put(description, variable.toString());
        }
    }

    private void setProperty(List<String> variable, String description) {
        if (variable != null && !variable.isEmpty()) {
            this.properties.put(description, variable.toString());
        }
    }

    private void setProperty(Long variable, String description) {
        if (variable != null) {
            this.properties.put(description, variable.toString());
        }
    }
}

