/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.util.List;
import java.util.Stack;
import net.sf.saxon.regex.OpAtom;
import net.sf.saxon.regex.OpCapture;
import net.sf.saxon.regex.OpCharClass;
import net.sf.saxon.regex.OpNothing;
import net.sf.saxon.regex.OpRepeat;
import net.sf.saxon.regex.OpUnambiguousRepeat;
import net.sf.saxon.regex.Operation;
import net.sf.saxon.regex.RECompiler;
import net.sf.saxon.regex.REFlags;
import net.sf.saxon.regex.REMatcher;
import net.sf.saxon.regex.REProgram;
import net.sf.saxon.regex.charclass.CharacterClass;
import net.sf.saxon.regex.charclass.EmptyCharacterClass;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.z.IntIterator;

public class OpSequence
extends Operation {
    protected final List<Operation> operations;

    OpSequence(List<Operation> operations) {
        this.operations = operations;
    }

    public List<Operation> getOperations() {
        return this.operations;
    }

    @Override
    public int getMatchLength() {
        int len = 0;
        for (Operation o : this.operations) {
            int i = o.getMatchLength();
            if (i == -1) {
                return -1;
            }
            len += i;
        }
        return len;
    }

    @Override
    public int getMinimumMatchLength() {
        int len = 0;
        for (Operation o : this.operations) {
            len += o.getMinimumMatchLength();
        }
        return len;
    }

    @Override
    public int matchesEmptyString() {
        boolean bl;
        boolean matchesEmptyAnywhere = true;
        for (Operation operation : this.operations) {
            int m3 = operation.matchesEmptyString();
            if (m3 == 1024) {
                return 1024;
            }
            if (m3 == 7) continue;
            matchesEmptyAnywhere = false;
            break;
        }
        if (matchesEmptyAnywhere) {
            return 7;
        }
        boolean matchesBOL = true;
        for (Operation o : this.operations) {
            if ((o.matchesEmptyString() & 1) != 0) continue;
            matchesBOL = false;
            break;
        }
        if (matchesBOL) {
            return 1;
        }
        boolean bl2 = true;
        for (Operation o : this.operations) {
            if ((o.matchesEmptyString() & 2) != 0) continue;
            bl = false;
            break;
        }
        if (bl) {
            return 2;
        }
        return 0;
    }

    @Override
    public boolean containsCapturingExpressions() {
        for (Operation o : this.operations) {
            if (!(o instanceof OpCapture) && !o.containsCapturingExpressions()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CharacterClass getInitialCharacterClass(boolean caseBlind) {
        CharacterClass result = EmptyCharacterClass.getInstance();
        for (Operation o : this.operations) {
            result = RECompiler.makeUnion(result, o.getInitialCharacterClass(caseBlind));
            if (o.matchesEmptyString() != 1024) continue;
            return result;
        }
        return result;
    }

    @Override
    public String display() {
        StringBuilder fsb = new StringBuilder(64);
        for (Operation op : this.operations) {
            fsb.append(op.display());
        }
        return fsb.toString();
    }

    @Override
    public Operation optimize(REProgram program, REFlags flags) {
        if (this.operations.size() == 0) {
            return new OpNothing();
        }
        if (this.operations.size() == 1) {
            return this.operations.get(0);
        }
        for (int i = 0; i < this.operations.size() - 1; ++i) {
            Operation o1r;
            Operation o2;
            Operation o1 = this.operations.get(i);
            if (o1 != (o2 = o1.optimize(program, flags))) {
                this.operations.set(i, o2);
            }
            if (!(o2 instanceof OpRepeat) || !((o1r = ((OpRepeat)o1).getRepeatedOperation()) instanceof OpAtom) && !(o1r instanceof OpCharClass)) continue;
            Operation o2r = this.operations.get(i + 1);
            if (((OpRepeat)o1).min != ((OpRepeat)o1).max && !RECompiler.noAmbiguity(o1r, o2r, flags.isCaseIndependent(), !((OpRepeat)o1).greedy)) continue;
            this.operations.set(i, new OpUnambiguousRepeat(o1r, ((OpRepeat)o1).min, ((OpRepeat)o1).max));
        }
        return this;
    }

    @Override
    public IntIterator iterateMatches(final REMatcher matcher, final int position) {
        final Stack iterators = new Stack();
        final REMatcher.State savedState = this.containsCapturingExpressions() ? matcher.captureState() : null;
        final int backtrackingLimit = matcher.getProgram().getBacktrackingLimit();
        return new IntIterator(){
            private boolean primed = false;
            private int nextPos;

            private int advance() {
                int counter = 0;
                while (!iterators.isEmpty()) {
                    IntIterator top = (IntIterator)iterators.peek();
                    while (top.hasNext()) {
                        int p = top.next();
                        matcher.clearCapturedGroupsBeyond(p);
                        int i = iterators.size();
                        if (i >= OpSequence.this.operations.size()) {
                            return p;
                        }
                        top = OpSequence.this.operations.get(i).iterateMatches(matcher, p);
                        iterators.push(top);
                    }
                    iterators.pop();
                    if (backtrackingLimit < 0 || counter++ <= backtrackingLimit) continue;
                    throw new UncheckedXPathException(new XPathException("Regex backtracking limit exceeded processing " + matcher.operation.display() + ". Simplify the regular expression, or set Feature.REGEX_BACKTRACKING_LIMIT to -1 to remove this limit."));
                }
                if (savedState != null) {
                    matcher.resetState(savedState);
                }
                return -1;
            }

            @Override
            public boolean hasNext() {
                if (!this.primed) {
                    iterators.push(OpSequence.this.operations.get(0).iterateMatches(matcher, position));
                    this.primed = true;
                }
                this.nextPos = this.advance();
                return this.nextPos >= 0;
            }

            @Override
            public int next() {
                return this.nextPos;
            }
        };
    }
}

