/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.parsson;

import jakarta.json.JsonMergePatch;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.Objects;
import org.eclipse.parsson.JsonContext;
import org.eclipse.parsson.JsonObjectBuilderImpl;

public final class JsonMergePatchImpl
implements JsonMergePatch {
    private final JsonValue patch;
    private final JsonContext jsonContext;

    public JsonMergePatchImpl(JsonValue patch, JsonContext jsonContext) {
        this.jsonContext = jsonContext;
        this.patch = patch;
    }

    @Override
    public JsonValue apply(JsonValue target) {
        return this.mergePatch(target, this.patch);
    }

    @Override
    public JsonValue toJsonValue() {
        return this.patch;
    }

    private JsonValue mergePatch(JsonValue target, JsonValue patch) {
        if (patch.getValueType() != JsonValue.ValueType.OBJECT) {
            return patch;
        }
        if (target.getValueType() != JsonValue.ValueType.OBJECT) {
            target = JsonValue.EMPTY_JSON_OBJECT;
        }
        JsonObject targetJsonObject = target.asJsonObject();
        JsonObjectBuilderImpl builder = new JsonObjectBuilderImpl(targetJsonObject, this.jsonContext);
        patch.asJsonObject().forEach((key, value) -> {
            if (value == JsonValue.NULL) {
                if (targetJsonObject.containsKey(key)) {
                    builder.remove((String)key);
                }
            } else if (targetJsonObject.containsKey(key)) {
                builder.add((String)key, this.mergePatch((JsonValue)targetJsonObject.get(key), (JsonValue)value));
            } else {
                builder.add((String)key, this.mergePatch(JsonValue.EMPTY_JSON_OBJECT, (JsonValue)value));
            }
        });
        return builder.build();
    }

    static JsonValue diff(JsonValue source, JsonValue target, JsonContext jsonContext) {
        if (source.getValueType() != JsonValue.ValueType.OBJECT || target.getValueType() != JsonValue.ValueType.OBJECT) {
            return target;
        }
        JsonObject s2 = (JsonObject)source;
        JsonObject t = (JsonObject)target;
        JsonObjectBuilderImpl builder = new JsonObjectBuilderImpl(jsonContext);
        s2.forEach((key, value) -> {
            if (t.containsKey(key)) {
                if (!value.equals(t.get(key))) {
                    builder.add((String)key, JsonMergePatchImpl.diff(value, (JsonValue)t.get(key), jsonContext));
                }
            } else {
                builder.addNull((String)key);
            }
        });
        t.forEach((key, value) -> {
            if (!s2.containsKey(key)) {
                builder.add((String)key, (JsonValue)value);
            }
        });
        return builder.build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != JsonMergePatchImpl.class) {
            return false;
        }
        JsonMergePatchImpl other = (JsonMergePatchImpl)obj;
        return Objects.equals(this.patch, other.patch);
    }

    public int hashCode() {
        return Objects.hashCode(this.patch);
    }

    public String toString() {
        return this.patch.toString();
    }
}

