/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.tutorial.tutorial1;

import java.io.OutputStream;
import java.util.Arrays;
import org.openprovenance.prov.interop.Formats;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;

public class Little {
    public static final String PROVBOOK_NS = "http://www.provbook.org";
    public static final String PROVBOOK_PREFIX = "provbook";
    public static final String JIM_PREFIX = "jim";
    public static final String JIM_NS = "http://www.cs.rpi.edu/~hendler/";
    private final ProvFactory pFactory;
    private final Namespace ns;

    public Little(ProvFactory pFactory) {
        this.pFactory = pFactory;
        this.ns = new Namespace();
        this.ns.addKnownNamespaces();
        this.ns.register(PROVBOOK_PREFIX, PROVBOOK_NS);
        this.ns.register(JIM_PREFIX, JIM_NS);
    }

    public QualifiedName qn(String n) {
        return this.ns.qualifiedName(PROVBOOK_PREFIX, n, this.pFactory);
    }

    public Document makeDocument() {
        Entity quote = this.pFactory.newEntity(this.qn("a-little-provenance-goes-a-long-way"));
        quote.setValue(this.pFactory.newValue((Object)"A little provenance goes a long way", this.pFactory.getName().XSD_STRING));
        Entity original = this.pFactory.newEntity(this.ns.qualifiedName(JIM_PREFIX, "LittleSemanticsWeb.html", this.pFactory));
        Agent paul = this.pFactory.newAgent(this.qn("Paul"), "Paul Groth");
        Agent luc = this.pFactory.newAgent(this.qn("Luc"), "Luc Moreau");
        WasAttributedTo attr1 = this.pFactory.newWasAttributedTo(null, quote.getId(), paul.getId());
        WasAttributedTo attr2 = this.pFactory.newWasAttributedTo(null, quote.getId(), luc.getId());
        WasDerivedFrom wdf = this.pFactory.newWasDerivedFrom(quote.getId(), original.getId());
        Document document = this.pFactory.newDocument();
        document.getStatementOrBundle().addAll(Arrays.asList(quote, paul, luc, attr1, attr2, original, wdf));
        document.setNamespace(this.ns);
        return document;
    }

    public void doConversions(Document document, String file) {
        InteropFramework intF = new InteropFramework();
        intF.writeDocument(file, document);
        intF.writeDocument((OutputStream)System.out, Formats.ProvFormat.PROVN, document);
    }

    public void closingBanner() {
        System.out.println("*************************");
    }

    public void openingBanner() {
        System.out.println("*************************");
        System.out.println("* Converting document  ");
        System.out.println("*************************");
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            throw new UnsupportedOperationException("main to be called with filename");
        }
        String file = args[0];
        Little little = new Little(InteropFramework.getDefaultFactory());
        little.openingBanner();
        Document document = little.makeDocument();
        little.doConversions(document, file);
        little.closingBanner();
    }
}

