/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.tutorial.tutorial5;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.IndexedDocument;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.TypedValue;
import org.openprovenance.prov.notation.Utility;
import org.openprovenance.prov.template.expander.Bindings;
import org.openprovenance.prov.template.expander.Expand;
import org.openprovenance.prov.template.expander.Groupings;
import org.openprovenance.prov.tutorial.tutorial5.ChallengeCommon;
import org.openprovenance.prov.tutorial.tutorial5.Variables;

public class ProvenanceChallenge1Template
extends ChallengeCommon<Collection<Bindings>>
implements Variables {
    public ProvenanceChallenge1Template(ProvFactory pFactory) {
        super(pFactory);
    }

    public QualifiedName b_var(String name) {
        return this.pFactory.newQualifiedName("http://openprovenance.org/var#", name, "var");
    }

    public List<TypedValue> a_val(String s) {
        LinkedList<TypedValue> ll = new LinkedList<TypedValue>();
        ll.add((TypedValue)this.pFactory.newAttribute(this.pFactory.newQualifiedName("http://openprovenance.org/tmpl#", "ignore", "app"), (Object)s, this.name.XSD_STRING));
        return ll;
    }

    public List<TypedValue> a_val(QualifiedName s) {
        LinkedList<TypedValue> ll = new LinkedList<TypedValue>();
        ll.add((TypedValue)this.pFactory.newAttribute(this.pFactory.newQualifiedName("http://openprovenance.org/tmpl#", "ignore", "app"), (Object)s, this.name.PROV_QUALIFIED_NAME));
        return ll;
    }

    void align_static(Bindings bindings1) {
        bindings1.addAttribute("consumed_name", this.prim("Img"));
        bindings1.addAttribute("consumed_name", this.prim("Hdr"));
        bindings1.addAttribute("consumed_name", this.prim("ImgRef"));
        bindings1.addAttribute("consumed_name", this.prim("HdrRef"));
        bindings1.addAttribute("consumed_type", this.prim("File"));
        bindings1.addAttribute("consumed_type", this.prim("File"));
        bindings1.addAttribute("consumed_type", this.prim("File"));
        bindings1.addAttribute("consumed_type", this.prim("File"));
        bindings1.addAttribute("block_type", this.prim("Align_warp"));
        bindings1.addAttribute("produced_type", this.prim("File"));
        bindings1.addAttribute("produced_name", this.prim("Out"));
    }

    @Override
    public Collection<Bindings> align(String imgfile1, String imglabel, String hdrfile1, String hdrlabel, String imgreffile1, String imgreflabel, String hdrreffile1, String hdrreflabel, String activity, String warpfile, String warplabel, String workflow, String agent) {
        Bindings bindings1 = new Bindings(this.pFactory);
        this.align_static(bindings1);
        bindings1.addVariable("consumed", this.pc(imgfile1));
        bindings1.addVariable("consumed", this.pc(hdrfile1));
        bindings1.addVariable("consumed", this.pc(imgreffile1));
        bindings1.addVariable("consumed", this.pc(hdrreffile1));
        bindings1.addAttribute("consumed_label", imglabel);
        bindings1.addAttribute("consumed_label", hdrlabel);
        bindings1.addAttribute("consumed_label", imgreflabel);
        bindings1.addAttribute("consumed_label", hdrreflabel);
        bindings1.addVariable("block_instance", this.pc(activity));
        bindings1.addVariable("produced", this.pc(warpfile));
        bindings1.addAttribute("produced_label", warplabel);
        bindings1.addVariable("parent", this.pc(workflow));
        bindings1.addVariable("agent", this.pc(agent));
        return Collections.singleton(bindings1);
    }

    @Override
    public Collection<Bindings> reslice(String warp, String activity, String imgfile, String imglabel, String hdrfile, String hdrlabel, String workflow, String agent) {
        Bindings bindings = new Bindings(this.pFactory);
        bindings.addVariable(this.b_var("consumed"), this.pc(warp));
        bindings.addAttribute(this.b_var("consumed_name"), this.a_val(this.prim("In")));
        bindings.addAttribute(this.b_var("consumed_type"), this.a_val(this.prim("File")));
        bindings.addVariable(this.b_var("block_instance"), this.pc(activity));
        bindings.addAttribute(this.b_var("block_type"), this.a_val(this.prim("Reslice")));
        bindings.addVariable(this.b_var("produced"), this.pc(imgfile));
        bindings.addVariable(this.b_var("produced"), this.pc(hdrfile));
        bindings.addAttribute(this.b_var("produced_label"), this.a_val(imglabel));
        bindings.addAttribute(this.b_var("produced_label"), this.a_val(hdrlabel));
        bindings.addAttribute(this.b_var("produced_name"), this.a_val(this.prim("Img")));
        bindings.addAttribute(this.b_var("produced_name"), this.a_val(this.prim("Hdr")));
        bindings.addAttribute(this.b_var("produced_type"), this.a_val(this.prim("File")));
        bindings.addAttribute(this.b_var("produced_type"), this.a_val(this.prim("File")));
        bindings.addVariable(this.b_var("parent"), this.pc(workflow));
        bindings.addVariable(this.b_var("agent"), this.pc(agent));
        return Collections.singleton(bindings);
    }

    @Override
    public Collection<Bindings> softmean(String imgfile1, String hdrfile1, String imgfile2, String hdrfile2, String imgfile3, String hdrfile3, String imgfile4, String hdrfile4, String activity, String imgatlas, String imglabel, String hdratlas, String hdrlabel, String workflow, String agent) {
        Bindings bindings = new Bindings(this.pFactory);
        bindings.addVariable(this.b_var("consumed"), this.pc(imgfile1));
        bindings.addVariable(this.b_var("consumed"), this.pc(hdrfile1));
        bindings.addVariable(this.b_var("consumed"), this.pc(imgfile2));
        bindings.addVariable(this.b_var("consumed"), this.pc(hdrfile2));
        bindings.addVariable(this.b_var("consumed"), this.pc(imgfile3));
        bindings.addVariable(this.b_var("consumed"), this.pc(hdrfile3));
        bindings.addVariable(this.b_var("consumed"), this.pc(imgfile4));
        bindings.addVariable(this.b_var("consumed"), this.pc(hdrfile4));
        bindings.addAttribute(this.b_var("consumed_name"), this.a_val(this.prim("I1")));
        bindings.addAttribute(this.b_var("consumed_name"), this.a_val(this.prim("H1")));
        bindings.addAttribute(this.b_var("consumed_name"), this.a_val(this.prim("I2")));
        bindings.addAttribute(this.b_var("consumed_name"), this.a_val(this.prim("H2")));
        bindings.addAttribute(this.b_var("consumed_name"), this.a_val(this.prim("I3")));
        bindings.addAttribute(this.b_var("consumed_name"), this.a_val(this.prim("H3")));
        bindings.addAttribute(this.b_var("consumed_name"), this.a_val(this.prim("I4")));
        bindings.addAttribute(this.b_var("consumed_name"), this.a_val(this.prim("H4")));
        bindings.addVariable(this.b_var("block_instance"), this.pc(activity));
        bindings.addAttribute(this.b_var("block_type"), this.a_val(this.prim("Softmean")));
        bindings.addVariable(this.b_var("produced"), this.pc(imgatlas));
        bindings.addVariable(this.b_var("produced"), this.pc(hdratlas));
        bindings.addAttribute(this.b_var("produced_label"), this.a_val(imglabel));
        bindings.addAttribute(this.b_var("produced_label"), this.a_val(hdrlabel));
        bindings.addAttribute(this.b_var("produced_name"), this.a_val(this.prim("Img")));
        bindings.addAttribute(this.b_var("produced_name"), this.a_val(this.prim("Hdr")));
        bindings.addAttribute(this.b_var("produced_type"), this.a_val(this.prim("File")));
        bindings.addAttribute(this.b_var("produced_type"), this.a_val(this.prim("File")));
        bindings.addVariable(this.b_var("parent"), this.pc(workflow));
        bindings.addVariable(this.b_var("agent"), this.pc(agent));
        return Collections.singleton(bindings);
    }

    @Override
    public Collection<Bindings> slice(String imgatlas, String hdratlas, String params, String paramslabel, String paramsvalue, String activity, String pgmfile, String pgmlabel, String workflow, String agent) {
        Bindings bindings = new Bindings(this.pFactory);
        bindings.addVariable(this.b_var("consumed"), this.pc(imgatlas));
        bindings.addVariable(this.b_var("consumed"), this.pc(hdratlas));
        bindings.addVariable(this.b_var("consumed"), this.pc(params));
        bindings.addAttribute(this.b_var("consumed_name"), this.a_val(this.prim("Img")));
        bindings.addAttribute(this.b_var("consumed_name"), this.a_val(this.prim("Hdr")));
        bindings.addAttribute(this.b_var("consumed_name"), this.a_val(this.prim("Param")));
        bindings.addAttribute(this.b_var("consumed_label"), new LinkedList());
        bindings.addAttribute(this.b_var("consumed_label"), new LinkedList());
        bindings.addAttribute(this.b_var("consumed_label"), this.a_val(paramslabel));
        bindings.addAttribute(this.b_var("consumed_value"), new LinkedList());
        bindings.addAttribute(this.b_var("consumed_value"), new LinkedList());
        bindings.addAttribute(this.b_var("consumed_value"), this.a_val(paramsvalue));
        bindings.addAttribute(this.b_var("consumed_type"), new LinkedList());
        bindings.addAttribute(this.b_var("consumed_type"), new LinkedList());
        bindings.addAttribute(this.b_var("consumed_type"), this.a_val(this.prim("String")));
        bindings.addVariable(this.b_var("block_instance"), this.pc(activity));
        bindings.addAttribute(this.b_var("block_type"), this.a_val(this.prim("Slicer")));
        bindings.addVariable(this.b_var("produced"), this.pc(pgmfile));
        bindings.addAttribute(this.b_var("produced_label"), this.a_val(pgmlabel));
        bindings.addAttribute(this.b_var("produced_name"), this.a_val(this.prim("Out")));
        bindings.addAttribute(this.b_var("produced_type"), this.a_val(this.prim("File")));
        bindings.addVariable(this.b_var("parent"), this.pc(workflow));
        bindings.addVariable(this.b_var("agent"), this.pc(agent));
        return Collections.singleton(bindings);
    }

    @Override
    public Collection<Bindings> convert(String pgmfile, String activity, String giffile, String giflabel, String workflow, String agent) {
        Bindings bindings = new Bindings(this.pFactory);
        bindings.addVariable(this.b_var("consumed"), this.pc(pgmfile));
        bindings.addAttribute(this.b_var("consumed_name"), this.a_val(this.prim("In")));
        bindings.addVariable(this.b_var("block_instance"), this.pc(activity));
        bindings.addAttribute(this.b_var("block_type"), this.a_val(this.prim("Convert")));
        bindings.addVariable(this.b_var("produced"), this.pc(giffile));
        bindings.addAttribute(this.b_var("produced_label"), this.a_val(giflabel));
        bindings.addAttribute(this.b_var("produced_name"), this.a_val(this.prim("Out")));
        bindings.addAttribute(this.b_var("produced_type"), this.a_val(this.prim("File")));
        bindings.addVariable(this.b_var("parent"), this.pc(workflow));
        bindings.addVariable(this.b_var("agent"), this.pc(agent));
        return Collections.singleton(bindings);
    }

    public List<Bindings> makeBindings() {
        LinkedList<Bindings> res = new LinkedList<Bindings>();
        LinkedList acc = new LinkedList();
        this.overallWorkflow(acc);
        for (Collection col : acc) {
            res.addAll(col);
        }
        return res;
    }

    public Document expander(Document docIn, Bindings bindings1) {
        Expand expand = new Expand(this.pFactory, false, true);
        Bundle bun = (Bundle)docIn.getStatementOrBundle().get(0);
        Groupings grp1 = Groupings.fromDocument((Document)docIn);
        Bundle bun1 = (Bundle)expand.expand(bun, bindings1, grp1).get(0);
        Document doc1 = this.pFactory.newDocument();
        doc1.getStatementOrBundle().add(bun1);
        bun1.setNamespace(Namespace.gatherNamespaces((Bundle)bun1));
        doc1.setNamespace(new Namespace());
        return doc1;
    }

    public Document makeDocument(String bind) {
        System.out.println("******************");
        IndexedDocument iDoc = new IndexedDocument(this.pFactory, this.pFactory.newDocument(), true);
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("template_block.provn");
            Document doc = new Utility().readDocument(is, this.pFactory);
            int count = 0;
            for (Bindings bindings : this.makeBindings()) {
                bindings.addVariableBindingsAsAttributeBindings();
                bindings.exportToJson(bind + count + ".json");
                ++count;
                Document eDoc = this.expander(doc, bindings);
                iDoc.merge(eDoc);
            }
            return iDoc.toDocument();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            throw new UnsupportedOperationException("main to be called with filename");
        }
        String file1 = args[0];
        String file2 = args[1];
        String bind = args[2];
        ProvenanceChallenge1Template pc1 = new ProvenanceChallenge1Template(InteropFramework.getDefaultFactory());
        pc1.openingBanner();
        Document document = pc1.makeDocument(bind);
        pc1.doConversions(document, file1);
        pc1.doConversions(document, file2);
        pc1.closingBanner();
    }
}

