/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.tutorial.tutorial6;

import java.io.OutputStream;
import org.openprovenance.prov.interop.Formats;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.HasType;
import org.openprovenance.prov.model.Name;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.tutorial.tutorial6.ChallengeConstants;

public class ChallengeUtil
implements ChallengeConstants {
    protected final ProvFactory pFactory;
    protected final Name name;

    public ChallengeUtil(ProvFactory pFactory) {
        this.pFactory = pFactory;
        this.name = pFactory.getName();
    }

    public Entity newFile(ProvFactory pFactory, String id, String label) {
        Entity a = pFactory.newEntity(this.pc(id), label);
        pFactory.addType((HasType)a, pFactory.newType((Object)pFactory.newQualifiedName("http://openprovenance.org/primitives#", "File", "prim"), this.name.PROV_QUALIFIED_NAME));
        return a;
    }

    protected Entity newParameter(ProvFactory pFactory, String id, String label, String value) {
        Entity a = pFactory.newEntity(this.pc(id), label);
        pFactory.addType((HasType)a, pFactory.newType((Object)pFactory.newQualifiedName("http://openprovenance.org/primitives#", "String", "prim"), this.name.PROV_QUALIFIED_NAME));
        a.setValue(pFactory.newValue(value));
        return a;
    }

    public QualifiedName pc(String n) {
        return this.pFactory.newQualifiedName("http://www.ipaw.info/challenge/", n, "pc1");
    }

    public QualifiedName prim(String name) {
        return this.pFactory.newQualifiedName("http://openprovenance.org/primitives#", name, "prim");
    }

    public Used newUsed(Activity activity, String role, Entity entity) {
        return this.newUsed(activity.getId(), role, entity.getId());
    }

    public Used newUsed(QualifiedName activity, String role, QualifiedName entity) {
        Used u1 = this.pFactory.newUsed(activity, entity);
        u1.getRole().add(this.pFactory.newRole((Object)this.prim(role), this.name.PROV_QUALIFIED_NAME));
        return u1;
    }

    public WasGeneratedBy newWasGeneratedBy(Entity entity, String role, Activity activity) {
        return this.newWasGeneratedBy(entity.getId(), role, activity.getId());
    }

    public WasGeneratedBy newWasGeneratedBy(QualifiedName entity, String role, QualifiedName activity) {
        WasGeneratedBy u1 = this.pFactory.newWasGeneratedBy(null, entity, activity);
        u1.getRole().add(this.pFactory.newRole((Object)this.prim(role), this.name.PROV_QUALIFIED_NAME));
        return u1;
    }

    public WasDerivedFrom newWasDerivedFrom(Entity entity2, Entity entity1) {
        WasDerivedFrom wdf = this.pFactory.newWasDerivedFrom(null, entity2.getId(), entity1.getId());
        return wdf;
    }

    public void closingBanner() {
        System.out.println("");
        System.out.println("*************************");
    }

    public void openingBanner() {
        System.out.println("*************************");
        System.out.println("* Converting document  ");
        System.out.println("*************************");
    }

    public void doConversions(Document document, String file) {
        InteropFramework intF = new InteropFramework();
        intF.writeDocument(file, document);
        intF.writeDocument((OutputStream)System.out, Formats.ProvFormat.PROVN, document);
    }
}

