/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.tutorial.tutorial6;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.IndexedDocument;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.TypedValue;
import org.openprovenance.prov.notation.Utility;
import org.openprovenance.prov.template.expander.Bindings;
import org.openprovenance.prov.template.expander.BindingsBean;
import org.openprovenance.prov.template.expander.Expand;
import org.openprovenance.prov.template.expander.Groupings;
import org.openprovenance.prov.tutorial.tutorial6.AlignBindingsBean;
import org.openprovenance.prov.tutorial.tutorial6.ChallengeCommon;
import org.openprovenance.prov.tutorial.tutorial6.ConvertBindingsBean;
import org.openprovenance.prov.tutorial.tutorial6.ResliceBindingsBean;
import org.openprovenance.prov.tutorial.tutorial6.SlicerBindingsBean;
import org.openprovenance.prov.tutorial.tutorial6.SoftmeanBindingsBean;
import org.openprovenance.prov.tutorial.tutorial6.Variables;

public class ProvenanceChallenge1Template
extends ChallengeCommon<Collection<BindingsBean>>
implements Variables {
    public ProvenanceChallenge1Template(ProvFactory pFactory) {
        super(pFactory);
    }

    public QualifiedName b_var(String name) {
        return this.pFactory.newQualifiedName("http://openprovenance.org/var#", name, "var");
    }

    public List<TypedValue> a_val(String s) {
        LinkedList<TypedValue> ll = new LinkedList<TypedValue>();
        ll.add((TypedValue)this.pFactory.newAttribute(this.pFactory.newQualifiedName("http://openprovenance.org/tmpl#", "ignore", "app"), (Object)s, this.name.XSD_STRING));
        return ll;
    }

    public List<TypedValue> a_val(QualifiedName s) {
        LinkedList<TypedValue> ll = new LinkedList<TypedValue>();
        ll.add((TypedValue)this.pFactory.newAttribute(this.pFactory.newQualifiedName("http://openprovenance.org/tmpl#", "ignore", "app"), (Object)s, this.name.PROV_QUALIFIED_NAME));
        return ll;
    }

    @Override
    public Collection<BindingsBean> align(String imgfile1, String imglabel, String hdrfile1, String hdrlabel, String imgreffile1, String imgreflabel, String hdrreffile1, String hdrreflabel, String activity, String warpfile, String warplabel, String workflow, String agent) {
        AlignBindingsBean bean = new AlignBindingsBean(this.pFactory);
        bean.addConsumed1(this.pc(imgfile1));
        bean.addConsumed2(this.pc(hdrfile1));
        bean.addConsumed3(this.pc(imgreffile1));
        bean.addConsumed4(this.pc(hdrreffile1));
        bean.addConsumed_label1(imglabel);
        bean.addConsumed_label2(hdrlabel);
        bean.addConsumed_label3(imgreflabel);
        bean.addConsumed_label4(hdrreflabel);
        bean.addBlock_instance(this.pc(activity));
        bean.addProduced(this.pc(warpfile));
        bean.addProduced_label(warplabel);
        bean.addParent(this.pc(workflow));
        bean.addAgent(this.pc(agent));
        AlignBindingsBean bb = bean;
        return Collections.singleton(bb);
    }

    @Override
    public Collection<BindingsBean> reslice(String warp, String activity, String imgfile, String imglabel, String hdrfile, String hdrlabel, String workflow, String agent) {
        ResliceBindingsBean bean = new ResliceBindingsBean(this.pFactory);
        bean.addConsumed(this.pc(warp));
        bean.addBlock_instance(this.pc(activity));
        bean.addProduced1(this.pc(imgfile));
        bean.addProduced2(this.pc(hdrfile));
        bean.addProduced_label1(imglabel);
        bean.addProduced_label2(hdrlabel);
        bean.addParent(this.pc(workflow));
        ResliceBindingsBean bb = bean;
        return Collections.singleton(bb);
    }

    @Override
    public Collection<BindingsBean> softmean(String imgfile1, String hdrfile1, String imgfile2, String hdrfile2, String imgfile3, String hdrfile3, String imgfile4, String hdrfile4, String activity, String imgatlas, String imglabel, String hdratlas, String hdrlabel, String workflow, String agent) {
        SoftmeanBindingsBean bean = new SoftmeanBindingsBean(this.pFactory);
        bean.addConsumed1(this.pc(imgfile1));
        bean.addConsumed2(this.pc(hdrfile1));
        bean.addConsumed3(this.pc(imgfile2));
        bean.addConsumed4(this.pc(hdrfile2));
        bean.addConsumed5(this.pc(imgfile3));
        bean.addConsumed6(this.pc(hdrfile3));
        bean.addConsumed7(this.pc(imgfile4));
        bean.addConsumed8(this.pc(hdrfile4));
        bean.addBlock_instance(this.pc(activity));
        bean.addProduced1(this.pc(imgatlas));
        bean.addProduced2(this.pc(hdratlas));
        bean.addProduced_label1(imglabel);
        bean.addProduced_label2(hdrlabel);
        bean.addParent(this.pc(workflow));
        SoftmeanBindingsBean bb = bean;
        return Collections.singleton(bb);
    }

    @Override
    public Collection<BindingsBean> slice(String imgatlas, String hdratlas, String params, String paramslabel, String paramsvalue, String activity, String pgmfile, String pgmlabel, String workflow, String agent) {
        SlicerBindingsBean bean = new SlicerBindingsBean(this.pFactory);
        bean.addConsumed1(this.pc(imgatlas));
        bean.addConsumed2(this.pc(hdratlas));
        bean.addConsumed3(this.pc(params));
        bean.addConsumed_label3(paramslabel);
        bean.addConsumed_value3(paramsvalue);
        bean.addBlock_instance(this.pc(activity));
        bean.addProduced(this.pc(pgmfile));
        bean.addProduced_label(pgmlabel);
        bean.addParent(this.pc(workflow));
        SlicerBindingsBean bb = bean;
        return Collections.singleton(bb);
    }

    @Override
    public Collection<BindingsBean> convert(String pgmfile, String activity, String giffile, String giflabel, String workflow, String agent) {
        ConvertBindingsBean bean = new ConvertBindingsBean(this.pFactory);
        bean.addConsumed(this.pc(pgmfile));
        bean.addBlock_instance(this.pc(activity));
        bean.addProduced(this.pc(giffile));
        bean.addProduced_label(giflabel);
        bean.addParent(this.pc(workflow));
        ConvertBindingsBean bb = bean;
        return Collections.singleton(bb);
    }

    public List<BindingsBean> makeBindingsBean() {
        LinkedList<BindingsBean> res = new LinkedList<BindingsBean>();
        LinkedList acc = new LinkedList();
        this.overallWorkflow(acc);
        for (Collection col : acc) {
            if (col == null) continue;
            res.addAll(col);
        }
        return res;
    }

    public Document expander(Document docIn, Bindings bindings1) {
        Expand expand = new Expand(this.pFactory, false, true);
        Bundle bun = (Bundle)docIn.getStatementOrBundle().get(0);
        Groupings grp1 = Groupings.fromDocument((Document)docIn);
        Bundle bun1 = (Bundle)expand.expand(bun, bindings1, grp1).get(0);
        Document doc1 = this.pFactory.newDocument();
        doc1.getStatementOrBundle().add(bun1);
        bun1.setNamespace(Namespace.gatherNamespaces((Bundle)bun1));
        doc1.setNamespace(new Namespace());
        return doc1;
    }

    public Document makeDocument(String bind) {
        System.out.println("******************");
        IndexedDocument iDoc = new IndexedDocument(this.pFactory, this.pFactory.newDocument(), true);
        try {
            int count = 0;
            for (BindingsBean bb : this.makeBindingsBean()) {
                InputStream is = this.getClass().getClassLoader().getResourceAsStream(bb.getTemplate());
                Document doc = new Utility().readDocument(is, this.pFactory);
                Bindings bindings = bb.getBindings();
                bindings.addVariableBindingsAsAttributeBindings();
                bindings.exportToJson(bind + count + ".json");
                ++count;
                Document eDoc = this.expander(doc, bindings);
                iDoc.merge(eDoc);
            }
            return iDoc.toDocument();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            throw new UnsupportedOperationException("main to be called with filename");
        }
        String file1 = args[0];
        String file2 = args[1];
        String bind = args[2];
        ProvenanceChallenge1Template pc1 = new ProvenanceChallenge1Template(InteropFramework.getDefaultFactory());
        pc1.openingBanner();
        Document document = pc1.makeDocument(bind);
        pc1.doConversions(document, file1);
        pc1.doConversions(document, file2);
        pc1.closingBanner();
    }
}

