/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.benchmarks;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.infra.Blackhole;
import org.openprovenance.prov.benchmarks.Examples;
import org.openprovenance.prov.benchmarks.RawJsonDeserialiser;
import org.openprovenance.prov.benchmarks.RawJsonSerialiser;
import org.openprovenance.prov.core.jsonld11.serialization.ProvSerialiser;
import org.openprovenance.prov.model.BeanTraversal;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ModelConstructor;
import org.openprovenance.prov.scala.immutable.ProvDeserialiser;
import org.openprovenance.prov.vanilla.ProvFactory;

@State(value=Scope.Thread)
public class SerialisationBenchmarks {
    final ProvFactory pf = ProvFactory.getFactory();
    final ProvFactory spf = new org.openprovenance.prov.scala.immutable.ProvFactory();
    org.openprovenance.prov.model.ProvSerialiser jsonldSerialiser;
    org.openprovenance.prov.model.ProvDeserialiser provnDeserialiser = new org.openprovenance.prov.notation.ProvDeserialiser((org.openprovenance.prov.model.ProvFactory)this.pf);
    org.openprovenance.prov.model.ProvDeserialiser jsonldDeserialiser;
    org.openprovenance.prov.model.ProvSerialiser provnSerialiser;
    org.openprovenance.prov.model.ProvDeserialiser rawJsonDeserialiser;
    org.openprovenance.prov.model.ProvSerialiser rawJsonSerialiser;
    org.openprovenance.prov.model.ProvDeserialiser scalaDeserialiser;
    org.openprovenance.prov.model.ProvSerialiser pjsonSerialiser;
    org.openprovenance.prov.model.ProvDeserialiser pjsonDeserialiser;
    ByteArrayOutputStream baos;
    Document doc;
    private ByteArrayInputStream provjsonldPrimerStream;
    private BeanTraversal beanTraveral;
    private BeanTraversal beanTraveralScala;
    private ByteArrayInputStream pjsonPrimerStream;
    private ByteArrayInputStream provnPrimerStream;

    @Setup(value=Level.Trial)
    public void doSetup() throws IOException {
        this.jsonldSerialiser = new ProvSerialiser();
        this.jsonldDeserialiser = new org.openprovenance.prov.core.jsonld11.serialization.ProvDeserialiser();
        this.provnSerialiser = new org.openprovenance.prov.notation.ProvSerialiser((org.openprovenance.prov.model.ProvFactory)this.pf);
        this.provnDeserialiser = new org.openprovenance.prov.notation.ProvDeserialiser((org.openprovenance.prov.model.ProvFactory)this.pf);
        this.rawJsonDeserialiser = new RawJsonDeserialiser();
        this.rawJsonSerialiser = new RawJsonSerialiser();
        this.scalaDeserialiser = new ProvDeserialiser();
        this.pjsonSerialiser = new org.openprovenance.prov.core.json.serialization.ProvSerialiser();
        this.pjsonDeserialiser = new org.openprovenance.prov.core.json.serialization.ProvDeserialiser();
        this.baos = new ByteArrayOutputStream(100000);
        this.doc = this.provnDeserialiser.deserialiseDocument((InputStream)new FileInputStream("src/test/resources/primer.provn"));
        this.provjsonldPrimerStream = new ByteArrayInputStream(Examples.provjsonldPrimer.getBytes());
        this.pjsonPrimerStream = new ByteArrayInputStream(Examples.pjsonPrimer.getBytes());
        this.provnPrimerStream = new ByteArrayInputStream(Examples.provnPrimer.getBytes());
        this.beanTraveral = new BeanTraversal((ModelConstructor)this.pf, (org.openprovenance.prov.model.ProvFactory)this.pf);
        this.beanTraveralScala = new BeanTraversal((ModelConstructor)this.spf, (org.openprovenance.prov.model.ProvFactory)this.spf);
    }

    @TearDown(value=Level.Trial)
    public void doTearDown() {
    }

    @Benchmark
    public void testSerialiseProvJsonLD(Blackhole blackhole) {
        this.baos.reset();
        this.jsonldSerialiser.serialiseDocument((OutputStream)this.baos, this.doc, false);
        blackhole.consume((Object)this.baos);
    }

    @Benchmark
    public void testDeserialiseProvJsonLD(Blackhole blackhole) throws IOException {
        this.provjsonldPrimerStream.reset();
        this.doc = this.jsonldDeserialiser.deserialiseDocument((InputStream)this.provjsonldPrimerStream);
        blackhole.consume((Object)this.doc);
    }

    @Benchmark
    public void testDeepCopyJava(Blackhole blackhole) {
        Document doc2 = this.beanTraveral.doAction(this.doc);
        blackhole.consume((Object)doc2);
    }

    @Benchmark
    public void testDeepCopyScala(Blackhole blackhole) {
        Document doc2 = this.beanTraveralScala.doAction(this.doc);
        blackhole.consume((Object)doc2);
    }

    @Benchmark
    public void testDeserialisePJson(Blackhole blackhole) throws IOException {
        this.pjsonPrimerStream.reset();
        this.doc = this.pjsonDeserialiser.deserialiseDocument((InputStream)this.pjsonPrimerStream);
        blackhole.consume((Object)this.doc);
    }

    @Benchmark
    public void testSerialisePJson(Blackhole blackhole) throws IOException {
        this.baos.reset();
        this.pjsonSerialiser.serialiseDocument((OutputStream)this.baos, this.doc, false);
        blackhole.consume((Object)this.baos);
    }

    @Benchmark
    public void testDeserialiseJson(Blackhole blackhole) throws IOException {
        this.provjsonldPrimerStream.reset();
        this.doc = this.rawJsonDeserialiser.deserialiseDocument((InputStream)this.provjsonldPrimerStream);
        blackhole.consume((Object)this.doc);
    }

    @Benchmark
    public void testDeserialiseProvN(Blackhole blackhole) throws IOException {
        this.provnPrimerStream.reset();
        this.doc = this.provnDeserialiser.deserialiseDocument((InputStream)this.provnPrimerStream);
        blackhole.consume((Object)this.doc);
    }

    @Benchmark
    public void testSerialiseProvN(Blackhole blackhole) throws IOException {
        this.baos.reset();
        this.provnSerialiser.serialiseDocument((OutputStream)this.baos, this.doc, false);
        blackhole.consume((Object)this.baos);
    }

    @Benchmark
    public void testReadScala(Blackhole blackhole) throws IOException {
        this.provnPrimerStream.reset();
        this.doc = this.scalaDeserialiser.deserialiseDocument((InputStream)this.provnPrimerStream);
        blackhole.consume((Object)this.doc);
    }
}

