/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.scala.interop;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.scala.ClassTagExtensions$;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.io.Writer;
import org.openprovenance.prov.core.jsonld11.serialization.ProvSerialiser;
import org.openprovenance.prov.scala.iface.Explainer;
import org.openprovenance.prov.scala.iface.Narrative;
import org.openprovenance.prov.scala.iface.Narrator;
import org.openprovenance.prov.scala.iface.QueryEngine;
import org.openprovenance.prov.scala.iface.QueryResult;
import org.openprovenance.prov.scala.immutable.Document;
import org.openprovenance.prov.scala.immutable.Statement;
import org.openprovenance.prov.scala.immutable.TypedValue;
import org.openprovenance.prov.scala.interop.CommandLine$;
import org.openprovenance.prov.scala.interop.Config;
import org.openprovenance.prov.scala.interop.FileInput;
import org.openprovenance.prov.scala.interop.FileOutput;
import org.openprovenance.prov.scala.interop.Input;
import org.openprovenance.prov.scala.interop.OutConfig;
import org.openprovenance.prov.scala.interop.Output;
import org.openprovenance.prov.scala.interop.StandardOutput;
import org.openprovenance.prov.scala.narrator.EventsDescription;
import org.openprovenance.prov.scala.narrator.XConfig;
import org.openprovenance.prov.scala.summary.TypePropagator$;
import org.openprovenance.prov.scala.utilities.OrType;
import org.openprovenance.prov.validation.EventMatrix;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapOps;
import scala.collection.immutable.Nil$;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Ue\u0001\u0002\u0007\u000e\u0001aA\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006C\u0003J\u0001\u0011\u0005!\nC\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0003\u007f\u0001\u0011\u0005q\u0010C\u0004\u0002\b\u0001!\t!!\u0003\t\u000f\u0005%\u0002\u0001\"\u0003\u0002,!9\u0011\u0011\u0006\u0001\u0005\n\u0005\u0015\u0003bBA+\u0001\u0011\u0005\u0011q\u000b\u0005\n\u0003{\u0002\u0011\u0013!C\u0001\u0003\u007f\u00121\"\u0016;jYND\u0006\u000f\\1j]*\u0011abD\u0001\bS:$XM]8q\u0015\t\u0001\u0012#A\u0003tG\u0006d\u0017M\u0003\u0002\u0013'\u0005!\u0001O]8w\u0015\t!R#\u0001\bpa\u0016t\u0007O]8wK:\fgnY3\u000b\u0003Y\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\r\u0011\u0005iaR\"A\u000e\u000b\u0003AI!!H\u000e\u0003\r\u0005s\u0017PU3g\u0003!q\u0017M\u001d:bi>\u0014\bC\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0010\u0003\u0015Ig-Y2f\u0013\t!\u0013E\u0001\u0005OCJ\u0014\u0018\r^8s\u0003%)\u0007\u0010\u001d7bS:,'\u000f\u0005\u0002!O%\u0011\u0001&\t\u0002\n\u000bb\u0004H.Y5oKJ\f1\"];fef,enZ5oKB!\u0001eK\u00174\u0013\ta\u0013EA\u0006Rk\u0016\u0014\u00180\u00128hS:,\u0007C\u0001\u00182\u001b\u0005y#B\u0001\u0019\u0010\u0003%IW.\\;uC\ndW-\u0003\u00023_\tI1\u000b^1uK6,g\u000e\u001e\t\u0003i\u0019s!!N\"\u000f\u0005Y\neBA\u001cA\u001d\tAtH\u0004\u0002:}9\u0011!(P\u0007\u0002w)\u0011AhF\u0001\u0007yI|w\u000e\u001e \n\u0003YI!\u0001F\u000b\n\u0005I\u0019\u0012B\u0001\t\u0012\u0013\t\u0011u\"A\u0003rk\u0016\u0014\u00180\u0003\u0002E\u000b\u0006\u0001\u0012+^3ss&sG/\u001a:qe\u0016$XM\u001d\u0006\u0003\u0005>I!a\u0012%\u0003\rI3\u0015.\u001a7e\u0015\t!U)\u0001\u0004=S:LGO\u0010\u000b\u0005\u00176su\n\u0005\u0002M\u00015\tQ\u0002C\u0003\u001f\t\u0001\u0007q\u0004C\u0003&\t\u0001\u0007a\u0005C\u0003*\t\u0001\u0007!&A\boCJ\u0014\u0018\r^5wK\u0016C\bo\u001c:u)\u0019\u0011VK\u00176poB\u0011!dU\u0005\u0003)n\u0011A!\u00168ji\")a+\u0002a\u0001/\u000611m\u001c8gS\u001e\u0004\"\u0001\u0014-\n\u0005ek!AB\"p]\u001aLw\rC\u0003\\\u000b\u0001\u0007A,\u0001\u0003uKb$\b\u0003B/bI\u001et!AX0\u0011\u0005iZ\u0012B\u00011\u001c\u0003\u0019\u0001&/\u001a3fM&\u0011!m\u0019\u0002\u0004\u001b\u0006\u0004(B\u00011\u001c!\tiV-\u0003\u0002gG\n11\u000b\u001e:j]\u001e\u0004\"\u0001\t5\n\u0005%\f#!\u0003(beJ\fG/\u001b<f\u0011\u0015YW\u00011\u0001m\u0003\u0011!wn\u0019\u001a\u0011\u00059j\u0017B\u000180\u0005!!unY;nK:$\b\"\u00029\u0006\u0001\u0004\t\u0018aA7biB\u0011!/^\u0007\u0002g*\u0011A/E\u0001\u000bm\u0006d\u0017\u000eZ1uS>t\u0017B\u0001<t\u0005-)e/\u001a8u\u001b\u0006$(/\u001b=\t\u000ba,\u0001\u0019A=\u0002\u0015\u0011,7o\u0019:jaR|'\u000f\u0005\u0002{y6\t1P\u0003\u0002\u001f\u001f%\u0011Qp\u001f\u0002\u0012\u000bZ,g\u000e^:EKN\u001c'/\u001b9uS>t\u0017!E3ya2\fg.\u0019;j_:,\u0005\u0010]8siR9!+!\u0001\u0002\u0004\u0005\u0015\u0001\"\u0002,\u0007\u0001\u00049\u0006\"B.\u0007\u0001\u0004a\u0006\"B6\u0007\u0001\u0004a\u0017!\u00069s_\u000e,7o])vKJL\u0018I\u001c3PkR\u0004X\u000f\u001e\u000b\n%\u0006-\u0011qBA\f\u0003?Aa!!\u0004\b\u0001\u0004a\u0017a\u00013pG\"1!i\u0002a\u0001\u0003#\u00012\u0001TA\n\u0013\r\t)\"\u0004\u0002\u0006\u0013:\u0004X\u000f\u001e\u0005\u0007-\u001e\u0001\r!!\u0007\u0011\u0007i\fY\"C\u0002\u0002\u001em\u0014q\u0001W\"p]\u001aLw\rC\u0004\u0002\"\u001d\u0001\r!a\t\u0002\u0013=,HoQ8oM&<\u0007c\u0001'\u0002&%\u0019\u0011qE\u0007\u0003\u0013=+HoQ8oM&<\u0017\u0001D3ya>\u0014H\u000fV8Kg>tG#\u0002*\u0002.\u0005\u0005\u0003bBA\u0018\u0011\u0001\u0007\u0011\u0011G\u0001\u0005_V$x\u000f\u0005\u0003\u00024\u0005uRBAA\u001b\u0015\u0011\t9$!\u000f\u0002\u0005%|'BAA\u001e\u0003\u0011Q\u0017M^1\n\t\u0005}\u0012Q\u0007\u0002\u0007/JLG/\u001a:\t\r\u0005\r\u0003\u00021\u0001\u001a\u0003\r\tg.\u001f\u000b\u0006%\u0006\u001d\u0013\u0011\u000b\u0005\b\u0003\u0013J\u0001\u0019AA&\u0003\ryW\u000f\u001e\t\u0004\u0019\u00065\u0013bAA(\u001b\t1q*\u001e;qkRDa!a\u0015\n\u0001\u0004I\u0012a\u0002:fG>\u0014Hm]\u0001\ri\u0016DHoT;uaV$XM\u001d\u000b\b%\u0006e\u0013qNA:\u0011\u0019Y&\u00021\u0001\u0002\\A)Q,\u00193\u0002^A)\u0011qLA5I:!\u0011\u0011MA3\u001d\rQ\u00141M\u0005\u0002!%\u0019\u0011qM\u000e\u0002\u000fA\f7m[1hK&!\u00111NA7\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005\u001d4\u0004C\u0004\u0002r)\u0001\r!a\u0013\u0002\u0017\r|gNZ5h?R,\u0007\u0010\u001e\u0005\n\u0003kR\u0001\u0013!a\u0001\u0003o\naB[:p]N+'/[1mSj,G\rE\u0002\u001b\u0003sJ1!a\u001f\u001c\u0005\u001d\u0011un\u001c7fC:\fa\u0003^3yi>+H\u000f];uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0003\u0003SC!a\u001e\u0002\u0004.\u0012\u0011Q\u0011\t\u0005\u0003\u000f\u000b\t*\u0004\u0002\u0002\n*!\u00111RAG\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0010n\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019*!#\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class UtilsXplain {
    private final Narrator narrator;
    private final QueryEngine<Statement, OrType<OrType<Option<Statement>, scala.collection.immutable.Seq<Statement>>, scala.collection.immutable.Seq<TypedValue>>> queryEngine;

    public void narrativeExport(Config config, Map<String, Narrative> text, Document doc2, EventMatrix mat, EventsDescription descriptor) {
        if (config.description() != null) {
            String fileName = config.description().toString();
            BufferedWriter bw = new BufferedWriter(new FileWriter(fileName));
            this.exportToJson(bw, (Object)descriptor);
        }
        if (config.outfiles().nonEmpty()) {
            CommandLine$.MODULE$.outputer(doc2, config);
        }
        if (config.snlg() != null) {
            Map m = this.narrator.getSnlgOnly(text);
            this.textOutputer((Map<String, List<String>>)m, config.snlg(), true);
        }
        if (config.matrix() != null) {
            String mat_text = mat.displayMatrix2();
            CommandLine$.MODULE$.output(mat_text, config.matrix());
        }
        this.textOutputer((Map<String, List<String>>)this.narrator.getTextOnly(text), config.text(), this.textOutputer$default$3());
    }

    public void explanationExport(Config config, Map<String, Narrative> text, Document doc2) {
        if (config.outfiles().nonEmpty()) {
            CommandLine$.MODULE$.outputer(doc2, config);
        }
        if (config.snlg() != null) {
            Map m = this.narrator.getSnlgOnly(text);
            this.textOutputer((Map<String, List<String>>)m, config.snlg(), true);
        }
        this.textOutputer((Map<String, List<String>>)this.narrator.getTextOnly(text), config.text(), this.textOutputer$default$3());
    }

    public void processQueryAndOutput(Document doc, Input query, XConfig config, OutConfig outConfig) {
        String string;
        try (BufferedSource source = Source$.MODULE$.fromFile(((FileInput)query).f(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String queryContents = string;
        QueryResult result = this.queryEngine.processQuery(queryContents, doc);
        Predef$.MODULE$.println((Object)new StringBuilder(28).append("found ").append(result.getRecords().size()).append(" records (and ").append(((MapOps)result.getRecords().headOption().getOrElse((Function0 & Serializable)() -> (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$))).keySet().size()).append(" fields)").toString());
        if (outConfig.queryResult() != null) {
            this.exportToJson(outConfig.queryResult(), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)result.getRecords()).asJava());
        }
        Document doc2 = result.getDocument();
        CommandLine$.MODULE$.outputer(doc2, outConfig);
    }

    private void exportToJson(Writer outw, Object any) {
        TypePropagator$.MODULE$.om().enable(SerializationFeature.INDENT_OUTPUT);
        TypePropagator$.MODULE$.om().writeValue(outw, any);
    }

    private void exportToJson(Output out, Object records) {
        JsonMapper jsonMapper = (JsonMapper)JsonMapper.builder().addModule((Module)DefaultScalaModule$.MODULE$).build();
        JsonMapper om = ClassTagExtensions$.MODULE$.$colon$colon(jsonMapper);
        new ProvSerialiser((ObjectMapper)om, false).getMapper().writeValue(((FileOutput)out).f(), records);
    }

    public void textOutputer(Map<String, List<String>> text, Output config_text, boolean jsonSerialized) {
        block9: {
            block10: {
                String format;
                String string;
                if (config_text == null) break block9;
                Output output = config_text;
                if (output instanceof StandardOutput) {
                    string = "txt";
                } else if (output instanceof FileOutput) {
                    FileOutput fileOutput = (FileOutput)output;
                    File f = fileOutput.f();
                    string = f.getName().substring(f.getName().lastIndexOf(46) + 1);
                } else {
                    throw new MatchError((Object)output);
                }
                String string2 = format = string;
                switch (string2 == null ? 0 : string2.hashCode()) {
                    case 3271912: {
                        if (!"json".equals(string2)) break;
                        if (!jsonSerialized) {
                            TypePropagator$.MODULE$.om().writeValue(((FileOutput)config_text).f(), (Object)text.map((Function1 & Serializable)x0$1 -> {
                                Tuple2 tuple2 = x0$1;
                                if (tuple2 != null) {
                                    String k = (String)tuple2._1();
                                    List vv = (List)tuple2._2();
                                    return new Tuple2((Object)k, (Object)vv.mkString("  "));
                                }
                                throw new MatchError((Object)tuple2);
                            }));
                        } else {
                            CommandLine$.MODULE$.output(((IterableOnceOps)text.map((Function1 & Serializable)x0$2 -> {
                                Tuple2 tuple2 = x0$2;
                                if (tuple2 != null) {
                                    String k = (String)tuple2._1();
                                    List vv = (List)tuple2._2();
                                    return new StringBuilder(4).append("\"").append(k).append("\": ").append(vv.mkString("  ")).toString();
                                }
                                throw new MatchError((Object)tuple2);
                            })).mkString("{", ", ", "}"), config_text);
                        }
                        break block10;
                    }
                }
                CommandLine$.MODULE$.output(text.map((Function1 & Serializable)x0$3 -> {
                    Tuple2 tuple2 = x0$3;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        List v = (List)tuple2._2();
                        return new Tuple2((Object)k, (Object)v.mkString("  "));
                    }
                    throw new MatchError((Object)tuple2);
                }).mkString("", "\n", ""), config_text);
            }
            return;
        }
    }

    public boolean textOutputer$default$3() {
        return false;
    }

    public UtilsXplain(Narrator narrator, Explainer explainer, QueryEngine<Statement, OrType<OrType<Option<Statement>, scala.collection.immutable.Seq<Statement>>, scala.collection.immutable.Seq<TypedValue>>> queryEngine) {
        this.narrator = narrator;
        this.queryEngine = queryEngine;
    }
}

