/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.format.english;

import java.util.ArrayList;
import java.util.List;
import simplenlg.features.DiscourseFunction;
import simplenlg.format.english.MarkupMorphologyProcessor;
import simplenlg.format.english.NumberedPrefix;
import simplenlg.framework.CoordinatedPhraseElement;
import simplenlg.framework.DocumentCategory;
import simplenlg.framework.DocumentElement;
import simplenlg.framework.ElementCategory;
import simplenlg.framework.ListElement;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGModule;
import simplenlg.framework.StringElement;

public class MarkupFormatter
extends NLGModule {
    private static NumberedPrefix numberedPrefix = new NumberedPrefix();

    public void initialise() {
    }

    public NLGElement realise(NLGElement element) {
        MarkupFormatter.debug_println("*** (1)" + element);
        NLGElement realisedComponent = null;
        StringBuffer realisation = new StringBuffer();
        if (element != null) {
            ElementCategory category = element.getCategory();
            List components = element.getChildren();
            MarkupFormatter.debug_println("*** (1)" + category);
            if (element instanceof StringElement) {
                MarkupFormatter.debug_println("*** (2)" + element);
                MarkupFormatter.debug_println("*** (2)" + components);
                MarkupFormatter.debug_println("*** (2)" + element.getAllFeatures());
                String elementRealisation = element.getRealisation();
                elementRealisation = this.addMarkupToRealisation(element, elementRealisation);
                realisation.append(elementRealisation);
            } else if (category instanceof DocumentCategory) {
                MarkupFormatter.debug_println("*** (3)" + components);
                String title = element instanceof DocumentElement ? ((DocumentElement)element).getTitle() : null;
                switch ((DocumentCategory)category) {
                    case DOCUMENT: {
                        this.appendTitle(realisation, title, 2);
                        this.realiseSubComponents(realisation, components);
                        break;
                    }
                    case SECTION: {
                        this.appendTitle(realisation, title, 1);
                        this.realiseSubComponents(realisation, components);
                        break;
                    }
                    case LIST: {
                        this.realiseSubComponents(realisation, components);
                        break;
                    }
                    case ENUMERATED_LIST: {
                        numberedPrefix.upALevel();
                        if (title != null) {
                            realisation.append(title).append('\n');
                        }
                        if (null != components && 0 < components.size()) {
                            realisedComponent = this.realise((NLGElement)components.get(0));
                            if (realisedComponent != null) {
                                realisation.append(realisedComponent.getRealisation());
                            }
                            for (int i = 1; i < components.size(); ++i) {
                                if (realisedComponent != null && !realisedComponent.getRealisation().endsWith("\n")) {
                                    realisation.append(' ');
                                }
                                if (((NLGElement)components.get(i)).getParent().getCategory() == DocumentCategory.ENUMERATED_LIST) {
                                    numberedPrefix.increment();
                                }
                                if ((realisedComponent = this.realise((NLGElement)components.get(i))) == null) continue;
                                realisation.append(realisedComponent.getRealisation());
                            }
                        }
                        numberedPrefix.downALevel();
                        break;
                    }
                    case PARAGRAPH: {
                        if (null != components && 0 < components.size()) {
                            realisedComponent = this.realise((NLGElement)components.get(0));
                            if (realisedComponent != null) {
                                realisation.append(realisedComponent.getRealisation());
                            }
                            for (int i = 1; i < components.size(); ++i) {
                                if (realisedComponent != null) {
                                    realisation.append(' ');
                                }
                                if ((realisedComponent = this.realise((NLGElement)components.get(i))) == null) continue;
                                realisation.append(realisedComponent.getRealisation());
                            }
                        }
                        realisation.append("\n\n");
                        break;
                    }
                    case SENTENCE: {
                        this.realiseSubComponentsWithMarkup(realisation, element, components);
                        this.stripLeadingCommas(realisation);
                        this.capitaliseFirstLetter(realisation);
                        this.terminateSentence(realisation, element.getFeatureAsBoolean("interrogative"));
                        break;
                    }
                    case LIST_ITEM: {
                        if (element.getParent() != null) {
                            if (element.getParent().getCategory() == DocumentCategory.LIST) {
                                realisation.append(" * ");
                            } else if (element.getParent().getCategory() == DocumentCategory.ENUMERATED_LIST) {
                                realisation.append(numberedPrefix.getPrefix() + " - ");
                            }
                        }
                        for (NLGElement eachComponent : components) {
                            realisedComponent = this.realise(eachComponent);
                            if (realisedComponent == null) continue;
                            realisation.append(realisedComponent.getRealisation());
                            if (components.indexOf(eachComponent) >= components.size() - 1) continue;
                            realisation.append(' ');
                        }
                        realisation.append("\n");
                    }
                }
            } else if (element instanceof ListElement) {
                MarkupFormatter.debug_println("***(4a) " + element);
                MarkupFormatter.debug_println("***(4a) " + (element instanceof ListElement ? "ListElement" : "CoordinatedPhraseElement") + " !!!  " + element.getFeatureAsString("markup_element"));
                String markup = null;
                if (element instanceof ListElement && (markup = element.getFeatureAsString("markup_element")) != null) {
                    realisation.append(MarkupFormatter.startMarkup(markup, element.getFeatureAsString("markup_attributes")));
                }
                boolean first = true;
                for (NLGElement eachComponent : components) {
                    realisedComponent = this.realise(eachComponent);
                    if (realisedComponent == null) continue;
                    if (first) {
                        first = false;
                    } else {
                        realisation.append(' ');
                    }
                    realisation.append(realisedComponent.getRealisation());
                }
                if (markup != null && element instanceof ListElement) {
                    realisation.append(MarkupFormatter.endMarkup(markup));
                }
            } else if (element instanceof CoordinatedPhraseElement) {
                MarkupFormatter.debug_println("***(4) " + element);
                MarkupFormatter.debug_println("***(4) " + (element instanceof ListElement ? "ListElement" : "CoordinatedPhraseElement") + " !!!  " + element.getFeatureAsString("markup_element"));
                String markup = null;
                if (element instanceof CoordinatedPhraseElement && (markup = element.getFeatureAsString("markup_element")) != null) {
                    realisation.append(MarkupFormatter.startMarkup(markup, element.getFeatureAsString("markup_attributes")));
                }
                boolean first = true;
                int index = 0;
                int length = components.size();
                for (NLGElement eachComponent : components) {
                    realisedComponent = this.realise(eachComponent);
                    if (realisedComponent != null) {
                        if (first) {
                            first = false;
                        } else {
                            realisation.append(' ');
                        }
                        if (index != length - 2 && DiscourseFunction.CONJUNCTION.equals(eachComponent.getFeature("discourse_function"))) {
                            realisation.append(", ");
                        } else {
                            realisation.append(realisedComponent.getRealisation());
                        }
                    }
                    ++index;
                }
                if (markup != null && element instanceof CoordinatedPhraseElement) {
                    realisation.append(MarkupFormatter.endMarkup(markup));
                }
                realisation = this.fixPunctuationAndMarkup(realisation);
            }
        }
        return new StringElement(realisation.toString());
    }

    public StringBuffer fixPunctuationAndMarkup(StringBuffer realisation) {
        return new StringBuffer(realisation.toString().replace("</li> ,", ",</li>").replace(" ,", ", ").replace("</li> and <li>", " and</li> <li>"));
    }

    private void terminateSentence(StringBuffer realisation, boolean interrogative) {
        char character = realisation.charAt(realisation.length() - 1);
        if (character != '.' && character != '?') {
            if (interrogative) {
                realisation.append('?');
            } else {
                realisation.append('.');
            }
        }
    }

    private void stripLeadingCommas(StringBuffer realisation) {
        char character = realisation.charAt(0);
        if (character == ' ' || character == ',') {
            realisation.deleteCharAt(0);
            this.stripLeadingCommas(realisation);
        }
    }

    private void capitaliseFirstLetter(StringBuffer realisation) {
        char character = realisation.charAt(0);
        if (character >= 'a' && character <= 'z') {
            character = (char)(65 + (character - 97));
            realisation.setCharAt(0, character);
        }
    }

    public static void debug_println(String s) {
    }

    public String addMarkupToRealisation(NLGElement element, String elementRealisation) {
        String s = element.getFeatureAsString("markup_element");
        if (s != null && s != "") {
            elementRealisation = MarkupFormatter.startMarkup(s, element.getFeatureAsString("markup_attributes")) + (String)elementRealisation + MarkupFormatter.endMarkup(s);
        }
        return elementRealisation;
    }

    public static String endMarkup(String s) {
        return "</" + s + ">";
    }

    public static String startMarkup(String s, String attributes) {
        String toInsert = attributes == null || "".equals(attributes) ? "" : " " + attributes;
        return "<" + s + toInsert + ">";
    }

    private void realiseSubComponents(StringBuffer realisation, List<NLGElement> components) {
        for (NLGElement eachComponent : components) {
            NLGElement realisedComponent = this.realise(eachComponent);
            if (realisedComponent == null) continue;
            realisation.append(realisedComponent.getRealisation());
        }
    }

    private void realiseSubComponentsWithMarkup(StringBuffer realisation, NLGElement element, List<NLGElement> components) {
        String markup = element.getFeatureAsString("markup_element");
        if (markup != null && markup != "") {
            realisation.append(MarkupFormatter.startMarkup(markup, element.getFeatureAsString("markup_attributes")));
        }
        boolean first = true;
        for (NLGElement eachComponent : components) {
            NLGElement realisedComponent = this.realise(eachComponent);
            MarkupMorphologyProcessor.propagateMarkup(element, realisedComponent);
            if (realisedComponent == null) continue;
            if (first) {
                first = false;
            } else {
                realisation.append(' ');
            }
            realisation.append(realisedComponent.getRealisation());
        }
        if (markup != null && markup != "") {
            realisation.append(MarkupFormatter.endMarkup(markup));
        }
    }

    private void appendTitle(StringBuffer realisation, String title, int numberOfLineBreaksAfterTitle) {
        if (title != null && !title.isEmpty()) {
            realisation.append(title);
            for (int i = 0; i < numberOfLineBreaksAfterTitle; ++i) {
                realisation.append("\n");
            }
        }
    }

    public List<NLGElement> realise(List<NLGElement> elements) {
        ArrayList<NLGElement> realisedList = new ArrayList<NLGElement>();
        if (elements != null) {
            for (NLGElement eachElement : elements) {
                realisedList.add(this.realise(eachElement));
            }
        }
        return realisedList;
    }
}

