/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.format.english;

import simplenlg.format.english.MarkupFormatter;
import simplenlg.framework.NLGElement;
import simplenlg.morphology.english.MorphologyProcessor;

public class MarkupMorphologyProcessor
extends MorphologyProcessor {
    static String[] markupsToPropagate = new String[]{"markup_element", "markup_attributes"};

    public NLGElement realise(NLGElement element) {
        NLGElement result = super.realise(element);
        if (result != null) {
            MarkupFormatter.debug_println("{{{ ***** Morpho }}}" + element);
            MarkupMorphologyProcessor.propagateMarkup(element, result);
            MarkupFormatter.debug_println("    -> {{{ ***** Morpho }}} " + element.getFeatureAsString("markup_element") + " " + result.getCategory() + " " + result.getClass() + " " + result);
        }
        return result;
    }

    public static void propagateMarkup(NLGElement src, NLGElement dst) {
        if (src != null) {
            for (String markup : markupsToPropagate) {
                String s = src.getFeatureAsString(markup);
                if (s == null) continue;
                MarkupFormatter.debug_println(s);
                dst.setFeature(markup, (Object)s);
            }
        }
    }
}

