/*
 * Decompiled with CFR 0.152.
 */
package nlg.wrapper;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import nlg.wrapper.Block;
import nlg.wrapper.BlocklyContents;
import nlg.wrapper.Field;
import nlg.wrapper.Mutation;
import nlg.wrapper.Next;
import nlg.wrapper.Root;
import nlg.wrapper.Statement;
import nlg.wrapper.Value;

public class StatementsHandler
extends SimpleModule {
    static final Map<String, Class<? extends Object>> statementMap = StatementsHandler.setupStatementTable();

    public StatementsHandler(String customSerializaer, Version version) {
        super(customSerializaer, version);
    }

    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        context.addDeserializationProblemHandler((DeserializationProblemHandler)new MyDeserializationProblemHandler());
    }

    static Map<String, Class<? extends Object>> setupStatementTable() {
        HashMap<String, Class<? extends Object>> result = new HashMap<String, Class<? extends Object>>();
        result.put("field", Field.class);
        result.put("value", Value.class);
        result.put("block", Block.class);
        result.put("statement", Statement.class);
        result.put("next", Next.class);
        result.put("mutation", Mutation.class);
        return result;
    }

    private static class MyDeserializationProblemHandler
    extends DeserializationProblemHandler {
        private MyDeserializationProblemHandler() {
        }

        public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser jp, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException {
            Class<? extends Object> cl2 = statementMap.get(propertyName);
            if (cl2 != null) {
                System.out.println("########################" + propertyName);
                Object s = jp.readValueAs(cl2);
                if (beanOrClass instanceof Block) {
                    Block b = (Block)beanOrClass;
                    System.out.println("Bock context " + b.type + " " + String.valueOf(s));
                    b.getBody().add((BlocklyContents)s);
                } else if (beanOrClass instanceof Value) {
                    Value v = (Value)beanOrClass;
                    System.out.println("Value context " + v.getName() + " " + String.valueOf(s));
                    v.getBlock().add((Block)s);
                } else if (beanOrClass instanceof Root) {
                    Root v = (Root)beanOrClass;
                    System.out.println("Root context  " + String.valueOf(s));
                    v.getBlock().add((Block)s);
                }
                return true;
            }
            return super.handleUnknownProperty(ctxt, jp, deserializer, beanOrClass, propertyName);
        }
    }
}

