/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.dot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.dot.DotProperties;
import org.openprovenance.prov.dot.ProvShorthandNames;
import org.openprovenance.prov.dot.RecommendedProvVisualProperties;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.DerivedByInsertionFrom;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Element;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.HasLabel;
import org.openprovenance.prov.model.HasOther;
import org.openprovenance.prov.model.HasRole;
import org.openprovenance.prov.model.HasType;
import org.openprovenance.prov.model.HasValue;
import org.openprovenance.prov.model.Identifiable;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.Other;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.QualifiedRelation;
import org.openprovenance.prov.model.Relation;
import org.openprovenance.prov.model.Role;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.model.Value;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.model.exception.DocumentedUnsupportedCaseException;
import org.openprovenance.prov.model.exception.UncheckedException;

public class ProvToDot
implements DotProperties,
RecommendedProvVisualProperties,
ProvShorthandNames {
    Logger logger = LogManager.getLogger(ProvToDot.class);
    public int MAX_TOOLTIP_LENGTH = 2000;
    ProvUtilities u = new ProvUtilities();
    final ProvFactory pf;
    final QualifiedName SUM_SIZE;
    private Integer maxStringLength = null;
    int annotationCount = 0;
    boolean displayAnnotationColor = true;
    int bncounter = 0;
    String name;
    private String layout;
    boolean ellipsis = true;

    QualifiedName makeSumSize() {
        return this.pf.newQualifiedName("http://openprovenance.org/provtoolbox/summary/ns#", "size", "sum");
    }

    public String qualifiedNameToString(QualifiedName qName) {
        return qName.getNamespaceURI() + qName.getLocalPart();
    }

    public String localnameToString(QualifiedName qName) {
        return this.nonEmptyLocalName(qName);
    }

    public void setMaxStringLength(Integer maxStringLength) {
        this.maxStringLength = maxStringLength;
    }

    public ProvToDot(ProvFactory pf) {
        this.pf = pf;
        this.SUM_SIZE = this.makeSumSize();
    }

    public void convert(Document graph, String dotFile, String pdfFile, String title) throws IOException {
        this.convert(graph, new File(dotFile), title);
        Runtime runtime = Runtime.getRuntime();
        Process proc = runtime.exec("dot -o " + pdfFile + " -Tpdf " + dotFile);
    }

    public void convert(Document graph, String dotFile, OutputStream pdfStream, String title) throws IOException {
        this.convert(graph, new File(dotFile), title);
        Runtime runtime = Runtime.getRuntime();
        Process proc = runtime.exec("dot  -Tpdf " + dotFile);
        InputStream is = proc.getInputStream();
        IOUtils.copy((InputStream)is, (OutputStream)pdfStream);
    }

    public void convert(Document graph, String dotFile, String title) throws IOException {
        this.convert(graph, new File(dotFile), title);
    }

    public void convert(Document graph, String dotFile, String aFile, String type, String title) throws IOException {
        this.convert(graph, new File(dotFile), title);
        Runtime runtime = Runtime.getRuntime();
        Process proc = runtime.exec("dot -o " + aFile + " -T" + type + " " + dotFile);
        try {
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            String s_error = errorReader.readLine();
            if (s_error != null) {
                System.out.println("Error:  " + s_error);
            }
            proc.waitFor();
        }
        catch (InterruptedException ie) {
            throw new UncheckedException("convert exception", (Exception)ie);
        }
    }

    public void convert(Document graph, OutputStream os, String type, String title) {
        try {
            File dotFile = File.createTempFile("temp", ".dot");
            this.convert(graph, dotFile, title);
            Runtime runtime = Runtime.getRuntime();
            Process proc = runtime.exec("dot  -T" + type + " " + dotFile);
            InputStream is = proc.getInputStream();
            IOUtils.copy((InputStream)is, (OutputStream)os);
            boolean bl = dotFile.delete();
        }
        catch (IOException e) {
            this.logger.throwing((Throwable)e);
            throw new UncheckedException((Exception)e);
        }
    }

    public void convert(Document graph, String dotFile, OutputStream os, String type, String title) throws IOException {
        this.convert(graph, new File(dotFile), title);
        Runtime runtime = Runtime.getRuntime();
        Process proc = runtime.exec("dot  -T" + type + " " + dotFile);
        InputStream is = proc.getInputStream();
        IOUtils.copy((InputStream)is, (OutputStream)os);
    }

    public void convert(Document graph, File file, String title) throws FileNotFoundException {
        FileOutputStream os = new FileOutputStream(file);
        this.convert(graph, new PrintStream(os), title);
    }

    public void convert(Document graph, OutputStream os, String title) {
        this.convert(graph, new PrintStream(os), title);
    }

    public void convert(Document doc, PrintStream out, String title) {
        if (title != null) {
            this.name = title;
        }
        this.prelude(doc, out);
        List edges = this.u.getRelations(doc);
        if (this.u.getActivity(doc) != null) {
            for (Activity p : this.u.getActivity(doc)) {
                this.emitActivity(p, out);
            }
        }
        if (this.u.getEntity(doc) != null) {
            for (Activity p : this.u.getEntity(doc)) {
                this.emitEntity((Entity)p, out);
            }
        }
        if (this.u.getAgent(doc) != null) {
            for (Activity p : this.u.getAgent(doc)) {
                this.emitAgent((Agent)p, out);
            }
        }
        for (Relation e : edges) {
            this.emitDependency(e, out);
        }
        if (this.u.getBundle(doc) != null) {
            for (Bundle bun : this.u.getBundle(doc)) {
                this.convert(bun, out);
            }
        }
        this.postlude(doc, out);
    }

    public void convert(Bundle bun, PrintStream out) {
        this.prelude(bun, out);
        List edges = this.u.getRelations(bun);
        if (this.u.getActivity(bun) != null) {
            for (Activity p : this.u.getActivity(bun)) {
                this.emitActivity(p, out);
            }
        }
        if (this.u.getEntity(bun) != null) {
            for (Activity p : this.u.getEntity(bun)) {
                this.emitEntity((Entity)p, out);
            }
        }
        if (this.u.getAgent(bun) != null) {
            for (Activity p : this.u.getAgent(bun)) {
                this.emitAgent((Agent)p, out);
            }
        }
        for (Relation e : edges) {
            this.emitDependency(e, out);
        }
        this.postlude(bun, out);
    }

    public void emitActivity(Activity p, PrintStream out) {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.emitSpace(p.getId(), out);
        this.emitElement(p.getId(), p.getKind(), this.addURL(p.getId(), this.addActivityShape(p, this.addActivityLabel(p, this.addActivityColor(p, properties)))), out);
        this.emitAnnotations("", (HasOther)p, out);
    }

    public void emitEntity(Entity e, PrintStream out) {
        this.emitSpace(e.getId(), out);
        HashMap<String, String> properties = new HashMap<String, String>();
        this.emitElement(e.getId(), e.getKind(), this.addURL(e.getId(), this.addEntityShape(e, this.addEntityLabel(e, this.addEntityColor(e, properties)))), out);
        this.emitAnnotations("", (HasOther)e, out);
    }

    public void emitAgent(Agent ag, PrintStream out) {
        this.emitSpace(ag.getId(), out);
        HashMap<String, String> properties = new HashMap<String, String>();
        this.emitElement(ag.getId(), ag.getKind(), this.addURL(ag.getId(), this.addAgentShape(ag, this.addAgentLabel(ag, this.addAgentColor(ag, properties)))), out);
        this.emitAnnotations("", (HasOther)ag, out);
    }

    private void emitSpace(QualifiedName ignoredId, PrintStream out) {
        out.println();
    }

    private void emitComment(QualifiedName id, StatementOrBundle.Kind kind, StringBuffer out) {
        String prefix = id == null ? "_" : id.getPrefix();
        String localPart = id == null ? "_" : id.getLocalPart();
        out.append(" [comment=\"").append(kind).append(" ").append(prefix).append(":").append(localPart).append("\"]");
    }

    public void emitAnnotations(String id, HasOther statement, PrintStream out) {
        if (!(statement.getOther() != null && !statement.getOther().isEmpty() && this.countOthers(statement) != 0 || !((HasType)statement).getType().isEmpty() || statement instanceof HasValue && ((HasValue)statement).getValue() != null || statement instanceof HasRole && !((HasRole)statement).getRole().isEmpty() || !((HasLabel)statement).getLabel().isEmpty())) {
            return;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        QualifiedName newId = this.annotationId(((Identifiable)statement).getId(), id);
        this.emitElement(newId, null, this.addAnnotationShape(statement, this.addAnnotationColor(statement, this.addAnnotationLabel(statement, properties))), out);
        HashMap<String, String> linkProperties = new HashMap<String, String>();
        this.emitRelation(null, this.qualifiedNameToString(newId), this.qualifiedNameToString(((Identifiable)statement).getId()), this.addAnnotationLinkProperties(statement, linkProperties), out, true);
    }

    public QualifiedName annotationId(QualifiedName ignoredId, String node) {
        return this.pf.newQualifiedName("-", "attrs" + node + this.annotationCount++, null);
    }

    public Map<String, String> addURL(QualifiedName id, Map<String, String> properties) {
        if (id != null) {
            properties.put("URL", this.htmlify(id.getNamespaceURI() + id.getLocalPart()));
        }
        return properties;
    }

    public Map<String, String> addAnnotationLinkProperties(HasOther ignoredAnn, Map<String, String> properties) {
        properties.put("arrowhead", "none");
        properties.put("style", "dashed");
        properties.put("color", "gray");
        return properties;
    }

    public Map<String, String> addActivityShape(Activity ignoredActivity, Map<String, String> properties) {
        properties.put("shape", "polygon");
        properties.put("sides", "4");
        return properties;
    }

    public Map<String, String> addBlankNodeShape(Map<String, String> properties) {
        properties.put("shape", "point");
        properties.put("label", "");
        return properties;
    }

    public Map<String, String> addActivityLabel(Activity p, Map<String, String> properties) {
        properties.put("label", this.activityLabel(p) + this.displaySize((HasOther)p));
        return properties;
    }

    public Map<String, String> addActivityColor(Activity p, Map<String, String> properties) {
        properties.put("fillcolor", "#9FB1FC");
        properties.put("color", "#0000FF");
        properties.put("style", "filled");
        this.addColors((HasOther)p, properties);
        return properties;
    }

    public String getStringValue(Other o) {
        Object v = o.getValue();
        if (v instanceof LangString) {
            return ((LangString)v).getValue();
        }
        return v.toString();
    }

    public void addColors(HasOther object, Map<String, String> properties) {
        Object val;
        Hashtable table = this.u.attributesWithNamespace(object, "http://openprovenance.org/provtoolbox/dot/ns#");
        List o = (List)table.get("fillcolor");
        if (o != null && !o.isEmpty()) {
            properties.put("fillcolor", this.getStringValue((Other)o.get(0)));
            properties.put("style", "filled");
        }
        if ((o = (List)table.get("color")) != null && !o.isEmpty()) {
            properties.put("color", this.getStringValue((Other)o.get(0)));
        }
        if ((o = (List)table.get("url")) != null && !o.isEmpty()) {
            properties.put("URL", this.htmlify(this.getStringValue((Other)o.get(0))));
        }
        if ((o = (List)table.get("size")) != null && !o.isEmpty()) {
            if (object instanceof QualifiedRelation) {
                val = ((Other)o.get(0)).getValue().toString();
                properties.put("penwidth", (String)val);
            } else if (object instanceof Element) {
                properties.put("width", "" + Double.parseDouble(this.getStringValue((Other)o.get(0))) * 0.75);
            }
        }
        if ((o = (List)table.get("tooltip")) != null && !o.isEmpty()) {
            val = this.getStringValue((Other)o.get(0));
            if (((String)val).length() > this.MAX_TOOLTIP_LENGTH) {
                val = ((String)val).substring(0, this.MAX_TOOLTIP_LENGTH) + " ...";
            }
            properties.put("tooltip", (String)val);
        }
    }

    public Map<String, String> addEntityShape(Entity p, Map<String, String> properties) {
        List types = p.getType();
        for (Type type : types) {
            QualifiedName name;
            if (!(type.getValue() instanceof QualifiedName) || !"Dictionary".equals((name = (QualifiedName)type.getValue()).getLocalPart()) && !"EmptyDictionary".equals(name.getLocalPart())) continue;
            properties.put("shape", "folder");
        }
        return properties;
    }

    public Map<String, String> addEntityColor(Entity a, Map<String, String> properties) {
        properties.put("fillcolor", "#FFFC87");
        properties.put("color", "#808080");
        properties.put("style", "filled");
        this.addColors((HasOther)a, properties);
        return properties;
    }

    public Map<String, String> addEntityLabel(Entity p, Map<String, String> properties) {
        properties.put("label", this.entityLabel(p) + this.displaySize((HasOther)p));
        return properties;
    }

    public String displaySize(HasOther p) {
        for (Other o : p.getOther()) {
            if (!this.SUM_SIZE.equals((Object)o.getElementName())) continue;
            return " (" + o.getConvertedValue() + ")";
        }
        return "";
    }

    public Map<String, String> addAgentShape(Agent ignoredAgent, Map<String, String> properties) {
        properties.put("shape", "house");
        return properties;
    }

    public Map<String, String> addAgentLabel(Agent agent, Map<String, String> properties) {
        properties.put("label", this.agentLabel(agent) + this.displaySize((HasOther)agent));
        return properties;
    }

    public Map<String, String> addAgentColor(Agent agent, Map<String, String> properties) {
        properties.put("fillcolor", "#FDB266");
        properties.put("style", "filled");
        this.addColors((HasOther)agent, properties);
        return properties;
    }

    public Map<String, String> addAnnotationShape(HasOther ignoredAnn, Map<String, String> properties) {
        properties.put("shape", "note");
        return properties;
    }

    public Map<String, String> addAnnotationLabel(HasOther ann, Map<String, String> properties) {
        Value val;
        StringBuilder label = new StringBuilder();
        label.append("<<TABLE cellpadding=\"0\" border=\"0\">\n");
        for (Type type : ((HasType)ann).getType()) {
            label.append("\t<TR>\n");
            label.append("\t    <TD align=\"left\">").append("type").append(":</TD>\n");
            label.append("\t    <TD align=\"left\">").append(this.getPropertyValueWithUrl((Attribute)type)).append("</TD>\n");
            label.append("\t</TR>\n");
        }
        for (LangString lab : ((HasLabel)ann).getLabel()) {
            label.append("\t<TR>\n");
            label.append("\t    <TD align=\"left\">").append("label").append(":</TD>\n");
            label.append("\t    <TD align=\"left\">").append(this.htmlify(lab.getValue(), true)).append("</TD>\n");
            label.append("\t</TR>\n");
        }
        if (ann instanceof HasValue && (val = ((HasValue)ann).getValue()) != null) {
            label.append("\t<TR>\n");
            label.append("\t    <TD align=\"left\">").append("value").append(":</TD>\n");
            label.append("\t    <TD align=\"left\">").append(this.getPropertyValueWithUrl((Attribute)val)).append("</TD>\n");
            label.append("\t</TR>\n");
        }
        if (ann instanceof HasRole) {
            for (Role role : ((HasRole)ann).getRole()) {
                label.append("\t<TR>\n");
                label.append("\t    <TD align=\"left\">").append("role").append(":</TD>\n");
                label.append("\t    <TD align=\"left\">").append(this.getPropertyValueWithUrl((Attribute)role)).append("</TD>\n");
                label.append("\t</TR>\n");
            }
        }
        for (Other prop : ann.getOther()) {
            if (prop.getElementName().getNamespaceURI().startsWith("http://openprovenance.org/provtoolbox/")) continue;
            label.append("\t<TR>\n");
            label.append("\t    <TD align=\"left\">").append(this.convertProperty((Attribute)prop)).append(":</TD>\n");
            label.append("\t    <TD align=\"left\">").append(this.getPropertyValueWithUrl((Attribute)prop)).append("</TD>\n");
            label.append("\t</TR>\n");
        }
        label.append("    </TABLE>>\n");
        properties.put("label", label.toString());
        properties.put("fontsize", "10");
        return properties;
    }

    public int countOthers(HasOther ann) {
        int count = 0;
        for (Other obj : ann.getOther()) {
            if (obj.getElementName().getNamespaceURI().startsWith("http://openprovenance.org/provtoolbox/")) continue;
            ++count;
        }
        return count;
    }

    public String nonEmptyLocalName(QualifiedName name) {
        String localPart = name.getLocalPart();
        if ("".equals(localPart)) {
            String uri = name.getNamespaceURI();
            String label = uri.substring(0, uri.length() - 1);
            int i = label.lastIndexOf("#");
            int j = label.lastIndexOf("/");
            return uri.substring(Math.max(i, j) + 1);
        }
        return localPart;
    }

    public String convertProperty(Attribute oLabel) {
        String label = this.getPropertyFromAny(oLabel);
        int i = label.lastIndexOf("#");
        int j = label.lastIndexOf("/");
        return label.substring(Math.max(i, j) + 1);
    }

    public String getPropertyFromAny(Attribute o) {
        return o.getElementName().getUri();
    }

    public String getPropertyValueWithUrl(Attribute t) {
        Object val = t.getValue();
        if (val instanceof QualifiedName) {
            QualifiedName q = (QualifiedName)val;
            return this.htmlify(q.getPrefix() + ":" + q.getLocalPart(), true);
        }
        if (val instanceof LangString) {
            LangString ls = (LangString)val;
            if (ls.getLang() == null) {
                return this.htmlify(ls.getValue(), true);
            }
            return this.htmlify(ls.getValue(), true) + "@" + ls.getLang();
        }
        return this.htmlify("" + val, true);
    }

    public Map<String, String> addAnnotationColor(HasOther ann, Map<String, String> properties) {
        if (this.displayAnnotationColor) {
            properties.put("color", this.annotationColor(ann));
            properties.put("fontcolor", "black");
        }
        return properties;
    }

    public String activityLabel(Activity p) {
        return this.localnameToString(p.getId());
    }

    public String selectColor(List<String> colors) {
        String tr = "transparent";
        for (String c : colors) {
            if (c.equals(tr)) continue;
            return c;
        }
        return tr;
    }

    public String entityLabel(Entity p) {
        return this.localnameToString(p.getId());
    }

    public String annotationColor(HasOther ignoredAnn) {
        LinkedList<String> colors = new LinkedList<String>();
        colors.add("gray");
        return this.selectColor(colors);
    }

    public String agentLabel(Agent p) {
        return this.localnameToString(p.getId());
    }

    public void emitDependency(Relation e, PrintStream out) {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.emitSpace(null, out);
        List others = this.u.getOtherCauses(e);
        if (others != null) {
            String bnid = "bn" + this.bncounter++;
            this.emitBlankNode(this.dotify(bnid), this.addBlankNodeShape(properties), out);
            HashMap<String, String> properties2 = new HashMap<String, String>();
            properties2.put("arrowhead", "none");
            String arrowTail = this.getArrowShapeForRelation(e);
            if (arrowTail != null) {
                properties2.put("arrowtail", arrowTail);
                properties2.put("dir", "back");
            }
            if (e instanceof HasOther) {
                this.addColors((HasOther)e, properties2);
            }
            HashMap<String, String> properties3 = new HashMap<String, String>();
            QualifiedName effect = this.u.getEffect(e);
            if (effect != null) {
                this.emitRelation(e.getKind(), this.qualifiedNameToString(effect), bnid, properties2, out, true);
            }
            this.relationName(e, properties3);
            if (e instanceof HasOther) {
                this.addColors((HasOther)e, properties3);
            }
            if (e instanceof DerivedByInsertionFrom) {
                properties3.put("arrowhead", "onormal");
            }
            if (this.u.getCause(e) != null) {
                this.emitRelation(e.getKind(), bnid, this.qualifiedNameToString(this.u.getCause(e)), properties3, out, true);
            }
            HashMap<String, String> properties4 = new HashMap<String, String>();
            if (e instanceof HasOther) {
                this.addColors((HasOther)e, properties4);
            }
            for (QualifiedName other : others) {
                if (other == null) continue;
                this.emitRelation(e.getKind(), bnid, this.qualifiedNameToString(other), properties4, out, true);
            }
            this.emitSpace(null, out);
        } else if (this.u.getCause(e) != null) {
            String arrowTail;
            this.relationName(e, properties);
            if (e instanceof QualifiedRelation) {
                this.addColors((HasOther)((QualifiedRelation)e), properties);
            }
            if ((arrowTail = this.getArrowShapeForRelation(e)) != null) {
                properties.put("arrowtail", arrowTail);
                properties.put("dir", "both");
            }
            QualifiedName effect = this.u.getEffect(e);
            QualifiedName cause = this.u.getCause(e);
            if (effect != null && cause != null) {
                this.emitRelation(e.getKind(), this.qualifiedNameToString(effect), this.qualifiedNameToString(cause), properties, out, true);
            }
        }
    }

    void relationName(Relation e, Map<String, String> properties) {
        String l = this.getShortLabelForRelation(e);
        if (l != null) {
            properties.put("taillabel", l);
            properties.put("labelangle", "60.0");
            properties.put("labeldistance", "1.5");
            properties.put("rotation", "20");
            properties.put("labelfontsize", "8");
        }
    }

    String getArrowShapeForRelation(Relation e) {
        if (e instanceof WasStartedBy) {
            return "oinv";
        }
        if (e instanceof WasEndedBy) {
            return "odiamond";
        }
        if (e instanceof WasInvalidatedBy) {
            return "odiamond";
        }
        return null;
    }

    String getShortLabelForRelation(Relation e) {
        switch (e.getKind()) {
            case PROV_ENTITY: 
            case PROV_ACTIVITY: 
            case PROV_AGENT: {
                throw new IllegalStateException("should not happen: a relation is not an element");
            }
            case PROV_USAGE: {
                return "use";
            }
            case PROV_GENERATION: {
                return "gen";
            }
            case PROV_INVALIDATION: {
                return "inv";
            }
            case PROV_START: {
                return "start";
            }
            case PROV_END: {
                return "end";
            }
            case PROV_COMMUNICATION: {
                return "inf";
            }
            case PROV_DERIVATION: {
                return "der";
            }
            case PROV_ASSOCIATION: {
                return "assoc";
            }
            case PROV_ATTRIBUTION: {
                return "att";
            }
            case PROV_DELEGATION: {
                return "del";
            }
            case PROV_INFLUENCE: {
                return "infl";
            }
            case PROV_ALTERNATE: {
                return "alt";
            }
            case PROV_SPECIALIZATION: {
                return "spe";
            }
            case PROV_MENTION: {
                return "men";
            }
            case PROV_MEMBERSHIP: {
                return "mem";
            }
            case PROV_BUNDLE: {
                return null;
            }
            case PROV_DICTIONARY_INSERTION: 
            case PROV_DICTIONARY_REMOVAL: 
            case PROV_DICTIONARY_MEMBERSHIP: {
                throw new DocumentedUnsupportedCaseException("dictionaries not supported");
            }
        }
        return null;
    }

    public String dotify(String name) {
        return "\"" + name + "\"";
    }

    public String htmlify(String name) {
        return this.htmlify(name, false);
    }

    public String htmlify(String name, boolean truncate) {
        if (truncate && this.maxStringLength != null && ((String)name).length() > this.maxStringLength) {
            name = ((String)name).substring(0, this.maxStringLength);
            if (this.ellipsis) {
                name = (String)name + "...";
            }
        }
        return ((String)name).replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public void emitElement(QualifiedName name, StatementOrBundle.Kind kind, Map<String, String> properties, PrintStream out) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.dotify(this.qualifiedNameToString(name)));
        if (kind != null) {
            this.emitComment(name, kind, sb);
        }
        this.emitProperties(sb, properties);
        out.println(sb);
    }

    public void emitBlankNode(String bnid, Map<String, String> properties, PrintStream out) {
        StringBuffer sb = new StringBuffer();
        sb.append(bnid);
        this.emitProperties(sb, properties);
        out.println(sb);
    }

    public void emitRelation(StatementOrBundle.Kind kind, String src, String dest, Map<String, String> properties, PrintStream out, boolean directional) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.dotify(src));
        if (directional) {
            sb.append(" -> ");
        } else {
            sb.append(" -- ");
        }
        sb.append(this.dotify(dest));
        this.emitComment(null, kind, sb);
        this.emitProperties(sb, properties);
        out.println(sb);
    }

    public void emitProperties(StringBuffer sb, Map<String, String> properties) {
        sb.append(" [");
        boolean first = true;
        for (String key : properties.keySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            String value = properties.get(key);
            sb.append(key);
            if (value.startsWith("<")) {
                sb.append("=");
                sb.append(value);
                continue;
            }
            sb.append("=\"");
            sb.append(value);
            sb.append("\"");
        }
        sb.append("]");
    }

    void prelude(Document ignoredDoc, PrintStream out) {
        out.println("digraph \"" + this.name + "\" { rankdir=\"BT\"; ");
        if (this.layout != null) {
            out.println("layout=\"" + this.layout + "\"; ");
        }
    }

    void postlude(Document ignoredDoc, PrintStream out) {
        out.println("}");
        out.close();
    }

    void prelude(Bundle doc, PrintStream out) {
        out.println("subgraph " + this.dotify("cluster" + this.qualifiedNameToString(doc.getId())) + " { ");
        out.println("  label=\"" + this.localnameToString(doc.getId()) + "\";");
        out.println("  URL=\"" + this.qualifiedNameToString(doc.getId()) + "\";");
    }

    void postlude(Bundle ignoredDoc, PrintStream out) {
        out.println("}");
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }
}

