/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.interop;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.xml.ProvFactory;

public class CommandLineArguments {
    public static final String BINDINGS = "bindings";
    public static final String OUTFILE = "outfile";
    public static final String VERBOSE = "verbose";
    public static final String NAMESPACES = "namespaces";
    public static final String DEBUG = "debug";
    public static final String VERSION = "version";
    public static final String HELP = "help";
    public static final String LOGFILE = "logfile";
    public static final String INFILE = "infile";
    public static final String TITLE = "title";
    public static final String LAYOUT = "layout";
    public static final String GENERATOR = "generator";

    static Options buildOptions() {
        Option help = new Option(HELP, "print this message");
        Option version = new Option(VERSION, "print the version information and exit");
        Option verbose = new Option(VERBOSE, "be verbose");
        Option debug = new Option(DEBUG, "print debugging information");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given file for log");
        Option logfile = OptionBuilder.create((String)LOGFILE);
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given file as input");
        Option infile = OptionBuilder.create((String)INFILE);
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given file as output");
        Option outfile = OptionBuilder.create((String)OUTFILE);
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given file as declaration of prefix namespaces");
        Option namespaces = OptionBuilder.create((String)NAMESPACES);
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given file as bindings for template expansion (template is provided as infile)");
        Option bindings = OptionBuilder.create((String)BINDINGS);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"document title");
        Option title = OptionBuilder.create((String)TITLE);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"dot layout: circo, dot (default), fdp, neato, osage, sfdp, twopi ");
        Option layout = OptionBuilder.create((String)LAYOUT);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"graph generator N:n:first:seed:e1");
        Option generator = OptionBuilder.create((String)GENERATOR);
        Options options = new Options();
        options.addOption(help);
        options.addOption(version);
        options.addOption(verbose);
        options.addOption(debug);
        options.addOption(logfile);
        options.addOption(infile);
        options.addOption(outfile);
        options.addOption(namespaces);
        options.addOption(title);
        options.addOption(layout);
        options.addOption(bindings);
        options.addOption(generator);
        return options;
    }

    public static void main(String[] args) {
        GnuParser parser = new GnuParser();
        String help = null;
        String version = null;
        String verbose = null;
        String debug = null;
        String logfile = null;
        String infile = null;
        String outfile = null;
        String namespaces = null;
        String title = null;
        String layout = null;
        String bindings = null;
        String generator = null;
        try {
            Options options = CommandLineArguments.buildOptions();
            CommandLine line = parser.parse(options, args);
            if (line.hasOption(HELP)) {
                help = HELP;
            }
            if (line.hasOption(VERSION)) {
                version = VERSION;
            }
            if (line.hasOption(VERBOSE)) {
                verbose = VERBOSE;
            }
            if (line.hasOption(DEBUG)) {
                debug = DEBUG;
            }
            if (line.hasOption(LOGFILE)) {
                logfile = line.getOptionValue(LOGFILE);
            }
            if (line.hasOption(INFILE)) {
                infile = line.getOptionValue(INFILE);
            }
            if (line.hasOption(OUTFILE)) {
                outfile = line.getOptionValue(OUTFILE);
            }
            if (line.hasOption(NAMESPACES)) {
                namespaces = line.getOptionValue(NAMESPACES);
            }
            if (line.hasOption(TITLE)) {
                title = line.getOptionValue(TITLE);
            }
            if (line.hasOption(LAYOUT)) {
                layout = line.getOptionValue(LAYOUT);
            }
            if (line.hasOption(BINDINGS)) {
                bindings = line.getOptionValue(BINDINGS);
            }
            if (line.hasOption(GENERATOR)) {
                generator = line.getOptionValue(GENERATOR);
            }
            if (help != null) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("prov-convert", options, true);
                return;
            }
            if (version != null) {
                System.out.println("prov-convert:  version x.y.z");
                return;
            }
            InteropFramework interop = new InteropFramework(verbose, debug, logfile, infile, outfile, namespaces, title, layout, bindings, generator, (org.openprovenance.prov.model.ProvFactory)ProvFactory.getFactory());
            interop.run();
        }
        catch (ParseException exp) {
            System.err.println("Parsing failed.  Reason: " + exp.getMessage());
        }
    }
}

