/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.interop;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Variant;
import javax.xml.bind.JAXBException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.apache.log4j.Logger;
import org.openprovenance.prov.dot.ProvToDot;
import org.openprovenance.prov.generator.GeneratorDetails;
import org.openprovenance.prov.generator.GraphGenerator;
import org.openprovenance.prov.interop.InteropException;
import org.openprovenance.prov.interop.InteropMediaType;
import org.openprovenance.prov.json.Converter;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvSerialiser;
import org.openprovenance.prov.notation.Utility;
import org.openprovenance.prov.rdf.Ontology;
import org.openprovenance.prov.template.Expand;
import org.openprovenance.prov.xml.ProvDeserialiser;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;

public class InteropFramework
implements InteropMediaType {
    static Logger logger = Logger.getLogger(InteropFramework.class);
    public static final String UNKNOWN = "unknown";
    final Utility u = new Utility();
    final ProvFactory pFactory;
    final Ontology onto;
    private final String verbose;
    private final String debug;
    private final String logfile;
    private final String infile;
    private final String outfile;
    private final String namespaces;
    private final String title;
    private final String layout;
    private final String bindings;
    public final Hashtable<ProvFormat, String> extensionMap;
    public final Hashtable<String, ProvFormat> extensionRevMap;
    public final Hashtable<ProvFormat, String> mimeTypeMap;
    public final Hashtable<String, ProvFormat> mimeTypeRevMap;
    public final Hashtable<ProvFormat, ProvFormatType> provTypeMap;
    private final String generator;

    public InteropFramework() {
        this(null, null, null, null, null, null, null, null, null, null, (ProvFactory)org.openprovenance.prov.xml.ProvFactory.getFactory());
    }

    public InteropFramework(ProvFactory pFactory) {
        this(null, null, null, null, null, null, null, null, null, null, pFactory);
    }

    public InteropFramework(String verbose, String debug, String logfile, String infile, String outfile, String namespaces, String title, String layout, String bindings, String generator, ProvFactory pFactory) {
        this.verbose = verbose;
        this.debug = debug;
        this.logfile = logfile;
        this.infile = infile;
        this.outfile = outfile;
        this.namespaces = namespaces;
        this.title = title;
        this.layout = layout;
        this.bindings = bindings;
        this.generator = generator;
        this.pFactory = pFactory;
        this.onto = new Ontology(pFactory);
        this.extensionMap = new Hashtable();
        this.extensionRevMap = new Hashtable();
        this.mimeTypeMap = new Hashtable();
        this.mimeTypeRevMap = new Hashtable();
        this.provTypeMap = new Hashtable();
        this.initializeExtensionMap(this.extensionMap, this.extensionRevMap);
    }

    public String buildAcceptHeader() {
        StringBuffer mimetypes = new StringBuffer();
        Enumeration<ProvFormat> e = this.mimeTypeMap.keys();
        String sep = "";
        while (e.hasMoreElements()) {
            ProvFormat f = e.nextElement();
            if (!this.isInputFormat(f).booleanValue()) continue;
            mimetypes.append(sep);
            sep = ",";
            mimetypes.append(this.mimeTypeMap.get((Object)f));
        }
        mimetypes.append(sep);
        mimetypes.append("*/*;q=0.1");
        return mimetypes.toString();
    }

    public URLConnection connectWithRedirect(URL theURL) throws IOException {
        URLConnection conn = null;
        String accept_header = this.buildAcceptHeader();
        int redirect_count = 0;
        boolean done = false;
        while (!done) {
            if (theURL.getProtocol().equals("file")) {
                return null;
            }
            Boolean isHttp = theURL.getProtocol().equals("http") || theURL.getProtocol().equals("https");
            logger.debug((Object)("Requesting: " + theURL.toString()));
            conn = theURL.openConnection();
            if (isHttp.booleanValue()) {
                logger.debug((Object)("Accept: " + accept_header));
                conn.setRequestProperty("Accept", accept_header);
            }
            conn.setConnectTimeout(60000);
            conn.setReadTimeout(60000);
            conn.connect();
            done = true;
            if (!isHttp.booleanValue()) continue;
            logger.debug((Object)("Response: " + conn.getHeaderField(0)));
            int rc = ((HttpURLConnection)conn).getResponseCode();
            if (rc == 301 || rc == 302 || rc == 303 || rc == 307) {
                if (redirect_count > 10) {
                    return null;
                }
                ++redirect_count;
                String loc = conn.getHeaderField("Location");
                if (loc != null) {
                    theURL = new URL(loc);
                    done = false;
                    continue;
                }
                return null;
            }
            if (rc >= 200 && rc < 300) continue;
            return null;
        }
        return conn;
    }

    public String convertExtensionToMediaType(String extension) {
        ProvFormat format = this.extensionRevMap.get(extension);
        if (format == null) {
            return null;
        }
        return this.mimeTypeMap.get((Object)format);
    }

    public String getExtension(ProvFormat format) {
        String extension = UNKNOWN;
        if (format != null) {
            extension = this.extensionMap.get((Object)format);
        }
        return extension;
    }

    String getOption(String[] options, int index) {
        if (options != null && options.length > index) {
            return options[index];
        }
        return null;
    }

    public ProvFormat getTypeForFile(String filename) {
        int count = filename.lastIndexOf(".");
        if (count == -1) {
            return null;
        }
        String extension = filename.substring(count + 1);
        return this.extensionRevMap.get(extension);
    }

    public List<Variant> getVariants() {
        ArrayList<Variant> vs = new ArrayList<Variant>();
        for (Map.Entry<String, ProvFormat> entry : this.mimeTypeRevMap.entrySet()) {
            if (!this.isOutputFormat(entry.getValue()).booleanValue()) continue;
            String[] parts = entry.getKey().split("/");
            MediaType m = new MediaType(parts[0], parts[1]);
            vs.add(new Variant(m, (Locale)null, (String)null));
        }
        return vs;
    }

    public void initializeExtensionMap(Hashtable<ProvFormat, String> extensionMap, Hashtable<String, ProvFormat> extensionRevMap) {
        block12: for (ProvFormat f : ProvFormat.values()) {
            switch (f) {
                case DOT: {
                    extensionMap.put(ProvFormat.DOT, "dot");
                    extensionRevMap.put("dot", ProvFormat.DOT);
                    extensionRevMap.put("gv", ProvFormat.DOT);
                    this.mimeTypeMap.put(ProvFormat.DOT, "text/vnd.graphviz");
                    this.mimeTypeRevMap.put("text/vnd.graphviz", ProvFormat.DOT);
                    this.provTypeMap.put(ProvFormat.DOT, ProvFormatType.OUTPUT);
                    continue block12;
                }
                case JPEG: {
                    extensionMap.put(ProvFormat.JPEG, "jpg");
                    extensionRevMap.put("jpeg", ProvFormat.JPEG);
                    extensionRevMap.put("jpg", ProvFormat.JPEG);
                    this.mimeTypeMap.put(ProvFormat.JPEG, "image/jpeg");
                    this.mimeTypeRevMap.put("image/jpeg", ProvFormat.JPEG);
                    this.provTypeMap.put(ProvFormat.JPEG, ProvFormatType.OUTPUT);
                    continue block12;
                }
                case JSON: {
                    extensionMap.put(ProvFormat.JSON, "json");
                    extensionRevMap.put("json", ProvFormat.JSON);
                    this.mimeTypeMap.put(ProvFormat.JSON, "application/json");
                    this.mimeTypeRevMap.put("application/json", ProvFormat.JSON);
                    this.provTypeMap.put(ProvFormat.JSON, ProvFormatType.INPUTOUTPUT);
                    continue block12;
                }
                case PDF: {
                    extensionMap.put(ProvFormat.PDF, "pdf");
                    extensionRevMap.put("pdf", ProvFormat.PDF);
                    this.mimeTypeMap.put(ProvFormat.PDF, "application/pdf");
                    this.mimeTypeRevMap.put("application/pdf", ProvFormat.PDF);
                    this.provTypeMap.put(ProvFormat.PDF, ProvFormatType.OUTPUT);
                    continue block12;
                }
                case PROVN: {
                    extensionMap.put(ProvFormat.PROVN, "provn");
                    extensionRevMap.put("provn", ProvFormat.PROVN);
                    extensionRevMap.put("pn", ProvFormat.PROVN);
                    extensionRevMap.put("asn", ProvFormat.PROVN);
                    extensionRevMap.put("prov-asn", ProvFormat.PROVN);
                    this.mimeTypeMap.put(ProvFormat.PROVN, "text/provenance-notation");
                    this.mimeTypeRevMap.put("text/provenance-notation", ProvFormat.PROVN);
                    this.provTypeMap.put(ProvFormat.PROVN, ProvFormatType.INPUTOUTPUT);
                    continue block12;
                }
                case RDFXML: {
                    extensionMap.put(ProvFormat.RDFXML, "rdf");
                    extensionRevMap.put("rdf", ProvFormat.RDFXML);
                    this.mimeTypeMap.put(ProvFormat.RDFXML, "application/rdf+xml");
                    this.mimeTypeRevMap.put("application/rdf+xml", ProvFormat.RDFXML);
                    this.provTypeMap.put(ProvFormat.RDFXML, ProvFormatType.INPUTOUTPUT);
                    continue block12;
                }
                case SVG: {
                    extensionMap.put(ProvFormat.SVG, "svg");
                    extensionRevMap.put("svg", ProvFormat.SVG);
                    this.mimeTypeMap.put(ProvFormat.SVG, "image/svg+xml");
                    this.mimeTypeRevMap.put("image/svg+xml", ProvFormat.SVG);
                    this.provTypeMap.put(ProvFormat.SVG, ProvFormatType.OUTPUT);
                    continue block12;
                }
                case TRIG: {
                    extensionMap.put(ProvFormat.TRIG, "trig");
                    extensionRevMap.put("trig", ProvFormat.TRIG);
                    this.mimeTypeMap.put(ProvFormat.TRIG, "application/trig");
                    this.mimeTypeRevMap.put("application/trig", ProvFormat.TRIG);
                    this.provTypeMap.put(ProvFormat.TRIG, ProvFormatType.INPUTOUTPUT);
                    continue block12;
                }
                case TURTLE: {
                    extensionMap.put(ProvFormat.TURTLE, "ttl");
                    extensionRevMap.put("ttl", ProvFormat.TURTLE);
                    this.mimeTypeMap.put(ProvFormat.TURTLE, "text/turtle");
                    this.mimeTypeRevMap.put("text/turtle", ProvFormat.TURTLE);
                    this.provTypeMap.put(ProvFormat.TURTLE, ProvFormatType.INPUTOUTPUT);
                    continue block12;
                }
                case XML: {
                    extensionMap.put(ProvFormat.XML, "provx");
                    extensionRevMap.put("provx", ProvFormat.XML);
                    extensionRevMap.put("xml", ProvFormat.XML);
                    this.mimeTypeMap.put(ProvFormat.XML, "application/provenance+xml");
                    this.mimeTypeRevMap.put("application/provenance+xml", ProvFormat.XML);
                    this.provTypeMap.put(ProvFormat.XML, ProvFormatType.INPUTOUTPUT);
                    continue block12;
                }
            }
        }
    }

    public Boolean isInputFormat(ProvFormat format) {
        ProvFormatType t = this.provTypeMap.get((Object)format);
        return t.equals((Object)ProvFormatType.INPUT) || t.equals((Object)ProvFormatType.INPUTOUTPUT);
    }

    public Boolean isOutputFormat(ProvFormat format) {
        ProvFormatType t = this.provTypeMap.get((Object)format);
        return t.equals((Object)ProvFormatType.OUTPUT) || t.equals((Object)ProvFormatType.INPUTOUTPUT);
    }

    public Object loadProvUnknownGraph(String filename) {
        try {
            Utility u = new Utility();
            CommonTree tree = u.convertASNToTree(filename);
            Object o = u.convertTreeToJavaBean(tree, this.pFactory);
            if (o != null) {
                return o;
            }
        }
        catch (RecognitionException t1) {
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            File in = new File(filename);
            ProvDeserialiser deserial = ProvDeserialiser.getThreadProvDeserialiser();
            org.openprovenance.prov.xml.Document c = deserial.deserialiseDocument(in);
            if (c != null) {
                return c;
            }
        }
        catch (JAXBException t2) {
            // empty catch block
        }
        try {
            Document o = new Converter(this.pFactory).readDocument(filename);
            if (o != null) {
                return o;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            org.openprovenance.prov.rdf.Utility rdfU = new org.openprovenance.prov.rdf.Utility(this.pFactory, this.onto);
            Document doc = rdfU.parseRDF(filename);
            if (doc != null) {
                return doc;
            }
        }
        catch (RDFParseException e) {
        }
        catch (RDFHandlerException e) {
        }
        catch (IOException e) {
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
        System.out.println("Unparseable format " + filename);
        throw new UnsupportedOperationException();
    }

    public static ProvFactory newXMLProvFactory() {
        return org.openprovenance.prov.xml.ProvFactory.getFactory();
    }

    public void provn2html(String file, String file2) throws IOException, JAXBException, RecognitionException {
        Document doc = (Document)this.u.convertASNToJavaBean(file, this.pFactory);
        String s = this.u.convertBeanToHTML(doc, this.pFactory);
        this.u.writeTextToFile(s, file2);
    }

    public Document readDocument(InputStream is, ProvFormat format) {
        return this.readDocument(is, format, this.pFactory);
    }

    public Document readDocument(InputStream is, ProvFormat format, ProvFactory pFactory) {
        try {
            switch (format) {
                case DOT: 
                case JPEG: 
                case SVG: {
                    throw new UnsupportedOperationException();
                }
                case JSON: {
                    return new Converter(pFactory).readDocument(is);
                }
                case PROVN: {
                    Utility u = new Utility();
                    CommonTree tree = u.convertASNToTree(is);
                    Object o = u.convertTreeToJavaBean(tree, pFactory);
                    Document doc = (Document)o;
                    return doc;
                }
                case RDFXML: {
                    org.openprovenance.prov.rdf.Utility rdfU = new org.openprovenance.prov.rdf.Utility(pFactory, this.onto);
                    return rdfU.parseRDF(is, RDFFormat.RDFXML);
                }
                case TRIG: {
                    org.openprovenance.prov.rdf.Utility rdfU = new org.openprovenance.prov.rdf.Utility(pFactory, this.onto);
                    return rdfU.parseRDF(is, RDFFormat.TRIG);
                }
                case TURTLE: {
                    org.openprovenance.prov.rdf.Utility rdfU = new org.openprovenance.prov.rdf.Utility(pFactory, this.onto);
                    return rdfU.parseRDF(is, RDFFormat.TURTLE);
                }
                case XML: {
                    ProvDeserialiser deserial = ProvDeserialiser.getThreadProvDeserialiser();
                    org.openprovenance.prov.xml.Document doc = deserial.deserialiseDocument(is);
                    return doc;
                }
            }
            System.out.println("Unknown format " + (Object)((Object)format));
            throw new UnsupportedOperationException();
        }
        catch (IOException e) {
            throw new InteropException(e);
        }
        catch (JAXBException e) {
            throw new InteropException((Exception)((Object)e));
        }
        catch (RecognitionException e) {
            throw new InteropException((Exception)((Object)e));
        }
        catch (RDFParseException e) {
            throw new InteropException((Exception)((Object)e));
        }
        catch (RDFHandlerException e) {
            throw new InteropException((Exception)((Object)e));
        }
    }

    public Document readDocument(String url) {
        try {
            URL theURL = new URL(url);
            URLConnection conn = this.connectWithRedirect(theURL);
            if (conn == null) {
                return null;
            }
            ProvFormat format = null;
            String content_type = conn.getContentType();
            logger.debug((Object)("Content-type: " + content_type));
            if (content_type != null) {
                int end = content_type.indexOf(";");
                if (end < 0) {
                    end = content_type.length();
                }
                String actual_content_type = content_type.substring(0, end).trim();
                logger.debug((Object)("Found Content-type: " + actual_content_type));
                format = this.mimeTypeRevMap.get(actual_content_type);
            }
            logger.debug((Object)("Format after Content-type: " + format));
            if (format == null) {
                format = this.getTypeForFile(theURL.toString());
            }
            logger.debug((Object)("Format after extension: " + (Object)((Object)format)));
            InputStream content_stream = conn.getInputStream();
            return this.readDocument(content_stream, format);
        }
        catch (IOException e) {
            throw new InteropException(e);
        }
    }

    public Document readDocumentFromFile(String filename) {
        try {
            ProvFormat format = this.getTypeForFile(filename);
            if (format == null) {
                throw new InteropException("Unknown output file format: " + filename);
            }
            switch (format) {
                case DOT: 
                case JPEG: 
                case SVG: {
                    throw new UnsupportedOperationException();
                }
                case JSON: {
                    return new Converter(this.pFactory).readDocument(filename);
                }
                case PROVN: {
                    Utility u = new Utility();
                    CommonTree tree = u.convertASNToTree(filename);
                    Object o = u.convertTreeToJavaBean(tree, this.pFactory);
                    Document doc = (Document)o;
                    return doc;
                }
                case RDFXML: 
                case TRIG: 
                case TURTLE: {
                    org.openprovenance.prov.rdf.Utility rdfU = new org.openprovenance.prov.rdf.Utility(this.pFactory, this.onto);
                    Document doc = rdfU.parseRDF(filename);
                    return doc;
                }
                case XML: {
                    File in = new File(filename);
                    ProvDeserialiser deserial = ProvDeserialiser.getThreadProvDeserialiser();
                    org.openprovenance.prov.xml.Document doc = deserial.deserialiseDocument(in);
                    return doc;
                }
            }
            System.out.println("Unknown format " + filename);
            throw new UnsupportedOperationException();
        }
        catch (IOException e) {
            throw new InteropException(e);
        }
        catch (RDFParseException e) {
            throw new InteropException((Exception)((Object)e));
        }
        catch (RDFHandlerException e) {
            throw new InteropException((Exception)((Object)e));
        }
        catch (JAXBException e) {
            throw new InteropException((Exception)((Object)e));
        }
        catch (RecognitionException e) {
            throw new InteropException((Exception)((Object)e));
        }
    }

    public void run() {
        Document doc;
        if (this.outfile == null) {
            return;
        }
        if (this.infile == null && this.generator == null) {
            return;
        }
        if (this.infile != null) {
            doc = this.readDocumentFromFile(this.infile);
        } else {
            String[] options = this.generator.split(":");
            String noOfNodes = this.getOption(options, 0);
            String noOfEdges = this.getOption(options, 1);
            String firstNode = this.getOption(options, 2);
            String namespace = "http://expample.org/";
            String seed = this.getOption(options, 3);
            String term = this.getOption(options, 4);
            if (term == null) {
                term = "e1";
            }
            GeneratorDetails gd = new GeneratorDetails(Integer.valueOf(noOfNodes).intValue(), Integer.valueOf(noOfEdges).intValue(), firstNode, namespace, seed == null ? null : Long.valueOf(seed), term);
            System.out.println(gd);
            GraphGenerator gg = new GraphGenerator(gd, this.pFactory);
            gg.generateElements();
            doc = gg.getDetails().getDocument();
        }
        if (this.bindings != null) {
            Document docBindings = this.readDocumentFromFile(this.bindings);
            Document expanded = new Expand(this.pFactory).expander(doc, this.outfile, docBindings);
            this.writeDocument(this.outfile, expanded);
        } else {
            this.writeDocument(this.outfile, doc);
        }
    }

    public void setNamespaces(Document doc) {
        if (doc.getNamespace() == null) {
            doc.setNamespace(new Namespace());
        }
    }

    public void writeDocument(OutputStream os, MediaType mt, Document document) {
        ProvFormat format = this.mimeTypeRevMap.get(mt.toString());
        this.writeDocument(os, format, document);
    }

    public void writeDocument(OutputStream os, ProvFormat format, Document document) {
        Namespace.withThreadNamespace((Namespace)document.getNamespace());
        try {
            if (format == null) {
                System.err.println("Unknown output format: " + (Object)((Object)format));
                return;
            }
            logger.debug((Object)("writing " + (Object)((Object)format)));
            this.setNamespaces(document);
            switch (format) {
                case PROVN: {
                    this.u.writeDocument(document, os, this.pFactory);
                    break;
                }
                case XML: {
                    ProvSerialiser serial = this.pFactory.getSerializer();
                    logger.debug((Object)("namespaces " + document.getNamespace()));
                    serial.serialiseDocument(os, document, true);
                    break;
                }
                case TURTLE: {
                    new org.openprovenance.prov.rdf.Utility(this.pFactory, this.onto).dumpRDF(document, RDFFormat.TURTLE, os);
                    break;
                }
                case RDFXML: {
                    new org.openprovenance.prov.rdf.Utility(this.pFactory, this.onto).dumpRDF(document, RDFFormat.RDFXML, os);
                    break;
                }
                case TRIG: {
                    new org.openprovenance.prov.rdf.Utility(this.pFactory, this.onto).dumpRDF(document, RDFFormat.TRIG, os);
                    break;
                }
                case JSON: {
                    new Converter(this.pFactory).writeDocument(document, (Writer)new OutputStreamWriter(os));
                    break;
                }
                case PDF: {
                    String configFile = null;
                    File tmp = File.createTempFile("viz-", ".dot");
                    String dotFileOut = tmp.getAbsolutePath();
                    ProvToDot toDot = configFile == null ? new ProvToDot(ProvToDot.Config.ROLE_NO_LABEL) : new ProvToDot(configFile);
                    toDot.convert(document, dotFileOut, os, this.title);
                    break;
                }
                case DOT: {
                    String configFile = null;
                    ProvToDot toDot = configFile == null ? new ProvToDot(ProvToDot.Config.ROLE_NO_LABEL) : new ProvToDot(configFile);
                    toDot.convert(document, os, this.title);
                    break;
                }
                case JPEG: {
                    String configFile = null;
                    File tmp = File.createTempFile("viz-", ".dot");
                    String dotFileOut = tmp.getAbsolutePath();
                    ProvToDot toDot = configFile != null ? new ProvToDot(configFile) : new ProvToDot(ProvToDot.Config.ROLE_NO_LABEL);
                    toDot.convert(document, dotFileOut, os, "jpg", this.title);
                    tmp.delete();
                    break;
                }
                case SVG: {
                    String configFile = null;
                    File tmp = File.createTempFile("viz-", ".dot");
                    String dotFileOut = tmp.getAbsolutePath();
                    ProvToDot toDot = configFile != null ? new ProvToDot(configFile) : new ProvToDot(ProvToDot.Config.ROLE_NO_LABEL);
                    toDot.convert(document, dotFileOut, os, "svg", this.title);
                    tmp.delete();
                    break;
                }
            }
        }
        catch (JAXBException e) {
            if (this.verbose != null) {
                e.printStackTrace();
            }
            throw new InteropException((Exception)((Object)e));
        }
        catch (Exception e) {
            if (this.verbose != null) {
                e.printStackTrace();
            }
            throw new InteropException(e);
        }
    }

    public void writeDocument(String filename, Document document) {
        Namespace.withThreadNamespace((Namespace)document.getNamespace());
        try {
            ProvFormat format = this.getTypeForFile(filename);
            if (format == null) {
                System.err.println("Unknown output file format: " + filename);
                return;
            }
            logger.debug((Object)("writing " + (Object)((Object)format)));
            logger.debug((Object)("writing " + filename));
            this.setNamespaces(document);
            switch (format) {
                case PROVN: {
                    this.u.writeDocument(document, filename, this.pFactory);
                    break;
                }
                case XML: {
                    org.openprovenance.prov.xml.ProvSerialiser serial = org.openprovenance.prov.xml.ProvSerialiser.getThreadProvSerialiser();
                    logger.debug((Object)("namespaces " + document.getNamespace()));
                    serial.serialiseDocument(new File(filename), document, true);
                    break;
                }
                case TURTLE: {
                    new org.openprovenance.prov.rdf.Utility(this.pFactory, this.onto).dumpRDF(document, RDFFormat.TURTLE, filename);
                    break;
                }
                case RDFXML: {
                    new org.openprovenance.prov.rdf.Utility(this.pFactory, this.onto).dumpRDF(document, RDFFormat.RDFXML, filename);
                    break;
                }
                case TRIG: {
                    new org.openprovenance.prov.rdf.Utility(this.pFactory, this.onto).dumpRDF(document, RDFFormat.TRIG, filename);
                    break;
                }
                case JSON: {
                    new Converter(this.pFactory).writeDocument(document, filename);
                    break;
                }
                case PDF: {
                    String configFile = null;
                    File tmp = File.createTempFile("viz-", ".dot");
                    String dotFileOut = tmp.getAbsolutePath();
                    ProvToDot toDot = configFile == null ? new ProvToDot(ProvToDot.Config.ROLE_NO_LABEL) : new ProvToDot(configFile);
                    toDot.setLayout(this.layout);
                    toDot.convert(document, dotFileOut, filename, this.title);
                    break;
                }
                case DOT: {
                    String configFile = null;
                    ProvToDot toDot = configFile == null ? new ProvToDot(ProvToDot.Config.ROLE_NO_LABEL) : new ProvToDot(configFile);
                    toDot.setLayout(this.layout);
                    toDot.convert(document, filename, this.title);
                    break;
                }
                case JPEG: {
                    String configFile = null;
                    File tmp = File.createTempFile("viz-", ".dot");
                    String dotFileOut = tmp.getAbsolutePath();
                    ProvToDot toDot = configFile != null ? new ProvToDot(configFile) : new ProvToDot(ProvToDot.Config.ROLE_NO_LABEL);
                    toDot.setLayout(this.layout);
                    toDot.convert(document, dotFileOut, filename, "jpg", this.title);
                    tmp.delete();
                    break;
                }
                case SVG: {
                    String configFile = null;
                    File tmp = File.createTempFile("viz-", ".dot");
                    String dotFileOut = tmp.getAbsolutePath();
                    ProvToDot toDot = configFile != null ? new ProvToDot(configFile) : new ProvToDot(ProvToDot.Config.ROLE_NO_LABEL);
                    toDot.setLayout(this.layout);
                    toDot.convert(document, dotFileOut, filename, "svg", this.title);
                    tmp.delete();
                    break;
                }
            }
        }
        catch (JAXBException e) {
            if (this.verbose != null) {
                e.printStackTrace();
            }
            throw new InteropException((Exception)((Object)e));
        }
        catch (IOException e) {
            if (this.verbose != null) {
                e.printStackTrace();
            }
            throw new InteropException(e);
        }
    }

    public static enum ProvFormatType {
        INPUT,
        OUTPUT,
        INPUTOUTPUT;

    }

    public static enum ProvFormat {
        PROVN,
        XML,
        TURTLE,
        RDFXML,
        TRIG,
        JSON,
        DOT,
        JPEG,
        SVG,
        PDF;

    }
}

