/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.interop;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;
import org.openprovenance.prov.interop.ErrorCodes;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.xml.ProvFactory;

public class CommandLineArguments
implements ErrorCodes {
    static Logger logger = Logger.getLogger(CommandLineArguments.class);
    public static final String BINDINGS = "bindings";
    public static final String OUTFILE = "outfile";
    public static final String VERBOSE = "verbose";
    public static final String NAMESPACES = "namespaces";
    public static final String DEBUG = "debug";
    public static final String VERSION = "version";
    public static final String HELP = "help";
    public static final String LOGFILE = "logfile";
    public static final String INFILE = "infile";
    public static final String TITLE = "title";
    public static final String LAYOUT = "layout";
    public static final String GENERATOR = "generator";
    public static final String INDEX = "index";
    public static final String COMPARE = "compare";
    public static final String FLATTEN = "flatten";
    public static final String MERGE = "merge";
    private static final String GENORDER = "genorder";
    public static final String FORMATS = "formats";
    public static final String INFORMAT = "informat";
    public static final String OUTFORMAT = "outformat";
    public static final String BINDFORMAT = "bindformat";
    public static final String COMPAREOUT = "outcompare";
    private static String fileName = "config.properties";
    static final String toolboxVersion = CommandLineArguments.getPropertiesFromClasspath(fileName).getProperty("toolbox.version");

    static Options buildOptions() {
        Option help = new Option(HELP, "print this message");
        Option version = new Option(VERSION, "print the version information and exit");
        Option verbose = new Option(VERBOSE, "be verbose");
        Option debug = new Option(DEBUG, "print debugging information");
        Option index = new Option(INDEX, "index all elements and edges of a document, merging them where appropriate");
        Option flatten = new Option(FLATTEN, "flatten all bundles in a single document (to used with -index option or -merge option)");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"merge all documents (listed in file argument) into a single document");
        Option merge = OptionBuilder.create((String)MERGE);
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given file for log");
        Option logfile = OptionBuilder.create((String)LOGFILE);
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given file as input");
        Option infile = OptionBuilder.create((String)INFILE);
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given file as output");
        Option outfile = OptionBuilder.create((String)OUTFILE);
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given file as declaration of prefix namespaces");
        Option namespaces = OptionBuilder.create((String)NAMESPACES);
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given file as bindings for template expansion (template is provided as infile)");
        Option bindings = OptionBuilder.create((String)BINDINGS);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"document title");
        Option title = OptionBuilder.create((String)TITLE);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"dot layout: circo, dot (default), fdp, neato, osage, sfdp, twopi ");
        Option layout = OptionBuilder.create((String)LAYOUT);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"graph generator N:n:first:seed:e1");
        Option generator = OptionBuilder.create((String)GENERATOR);
        Option genorder = new Option(GENORDER, "In template expansion, generate order attribute. By default does not.");
        Option formats = new Option(FORMATS, "list supported formats");
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify the format of the input");
        Option informat = OptionBuilder.create((String)INFORMAT);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify the format of the output");
        Option outformat = OptionBuilder.create((String)OUTFORMAT);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify the format of the bindings");
        Option bindformat = OptionBuilder.create((String)BINDFORMAT);
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"compare with given file");
        Option compare = OptionBuilder.create((String)COMPARE);
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"output file for log of comparison");
        Option compareOut = OptionBuilder.create((String)COMPAREOUT);
        Options options = new Options();
        options.addOption(help);
        options.addOption(version);
        options.addOption(verbose);
        options.addOption(debug);
        options.addOption(index);
        options.addOption(merge);
        options.addOption(flatten);
        options.addOption(infile);
        options.addOption(outfile);
        options.addOption(namespaces);
        options.addOption(title);
        options.addOption(layout);
        options.addOption(bindings);
        options.addOption(generator);
        options.addOption(genorder);
        options.addOption(formats);
        options.addOption(informat);
        options.addOption(outformat);
        options.addOption(bindformat);
        options.addOption(compare);
        options.addOption(compareOut);
        return options;
    }

    private static Properties getPropertiesFromClasspath(String propFileName) {
        Properties props = new Properties();
        InputStream inputStream = CommandLineArguments.class.getClassLoader().getResourceAsStream(propFileName);
        if (inputStream == null) {
            return null;
        }
        try {
            props.load(inputStream);
        }
        catch (IOException ee) {
            return null;
        }
        return props;
    }

    public static void main(String[] args) {
        GnuParser parser = new GnuParser();
        String help = null;
        String version = null;
        String verbose = null;
        String debug = null;
        String logfile = null;
        String infile = null;
        String informat = null;
        String outfile = null;
        String outformat = null;
        String namespaces = null;
        String title = null;
        String layout = null;
        String bindings = null;
        String bindingformat = null;
        String generator = null;
        String index = null;
        String flatten = null;
        String merge = null;
        String compare = null;
        String compareOut = null;
        boolean addOrderp = false;
        boolean listFormatsp = false;
        try {
            Options options = CommandLineArguments.buildOptions();
            CommandLine line = parser.parse(options, args);
            if (line.hasOption(HELP)) {
                help = HELP;
            }
            if (line.hasOption(VERSION)) {
                version = VERSION;
            }
            if (line.hasOption(VERBOSE)) {
                verbose = VERBOSE;
            }
            if (line.hasOption(DEBUG)) {
                debug = DEBUG;
            }
            if (line.hasOption(INDEX)) {
                index = INDEX;
            }
            if (line.hasOption(FLATTEN)) {
                flatten = FLATTEN;
            }
            if (line.hasOption(MERGE)) {
                merge = line.getOptionValue(MERGE);
            }
            if (line.hasOption(LOGFILE)) {
                logfile = line.getOptionValue(LOGFILE);
            }
            if (line.hasOption(INFILE)) {
                infile = line.getOptionValue(INFILE);
            }
            if (line.hasOption(INFORMAT)) {
                informat = line.getOptionValue(INFORMAT);
            }
            if (line.hasOption(OUTFILE)) {
                outfile = line.getOptionValue(OUTFILE);
            }
            if (line.hasOption(OUTFORMAT)) {
                outformat = line.getOptionValue(OUTFORMAT);
            }
            if (line.hasOption(NAMESPACES)) {
                namespaces = line.getOptionValue(NAMESPACES);
            }
            if (line.hasOption(TITLE)) {
                title = line.getOptionValue(TITLE);
            }
            if (line.hasOption(LAYOUT)) {
                layout = line.getOptionValue(LAYOUT);
            }
            if (line.hasOption(BINDINGS)) {
                bindings = line.getOptionValue(BINDINGS);
            }
            if (line.hasOption(BINDFORMAT)) {
                bindingformat = line.getOptionValue(BINDFORMAT);
            }
            if (line.hasOption(GENERATOR)) {
                generator = line.getOptionValue(GENERATOR);
            }
            if (line.hasOption(GENORDER)) {
                addOrderp = true;
            }
            if (line.hasOption(FORMATS)) {
                listFormatsp = true;
            }
            if (line.hasOption(COMPARE)) {
                compare = line.getOptionValue(COMPARE);
            }
            if (line.hasOption(COMPAREOUT)) {
                compareOut = line.getOptionValue(COMPAREOUT);
            }
            if (help != null) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("provconvert", options, true);
                return;
            }
            if (version != null) {
                System.out.println("provconvert version " + toolboxVersion);
                return;
            }
            InteropFramework interop = new InteropFramework(verbose, debug, logfile, infile, informat, outfile, outformat, namespaces, title, layout, bindings, bindingformat, addOrderp, generator, index, merge, flatten, compare, compareOut, (org.openprovenance.prov.model.ProvFactory)ProvFactory.getFactory());
            if (listFormatsp) {
                List<Map<String, String>> formats = interop.getSupportedFormats();
                for (Map<String, String> e : formats) {
                    System.out.println(e.get("extension") + '\t' + e.get("mediatype") + '\t' + e.get("type"));
                }
                return;
            }
            System.exit(interop.run());
        }
        catch (ParseException exp) {
            logger.fatal((Object)("Parsing failed.  Reason: " + exp.getMessage()));
            System.exit(1);
        }
    }
}

