/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.interop;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Variant;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.configuration.Configuration;
import org.openprovenance.prov.core.json.serialization.ProvDeserialiser;
import org.openprovenance.prov.dot.ProvSerialiser;
import org.openprovenance.prov.dot.ProvToDot;
import org.openprovenance.prov.generator.GeneratorDetails;
import org.openprovenance.prov.generator.GraphGenerator;
import org.openprovenance.prov.interop.CommandLineArguments;
import org.openprovenance.prov.interop.DeserializerFunction;
import org.openprovenance.prov.interop.Formats;
import org.openprovenance.prov.interop.InteropException;
import org.openprovenance.prov.interop.InteropMediaType;
import org.openprovenance.prov.interop.SerializerFunction;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.DocumentEquality;
import org.openprovenance.prov.model.IndexedDocument;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.exception.DocumentedUnsupportedCaseException;
import org.openprovenance.prov.notation.Utility;
import org.openprovenance.prov.template.compiler.BindingsBeanGenerator;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.TemplatesCompilerConfig;
import org.openprovenance.prov.template.expander.Expand;
import org.openprovenance.prov.template.json.Bindings;

public class InteropFramework
implements InteropMediaType,
org.openprovenance.prov.model.ProvSerialiser {
    public static final String configFile = "config.interop.properties";
    public static final String configuration;
    public static final String factoryClass;
    public static final ProvFactory defaultFactory;
    static Logger logger;
    public static final String UNKNOWN = "unknown";
    final ProvFactory pFactory;
    public final Hashtable<Formats.ProvFormat, String> extensionMap;
    public final Hashtable<String, Formats.ProvFormat> extensionRevMap;
    public final Hashtable<Formats.ProvFormat, String> mimeTypeMap;
    public final Hashtable<String, Formats.ProvFormat> mimeTypeRevMap;
    public final Hashtable<Formats.ProvFormat, Formats.ProvFormatType> provTypeMap;
    private final CommandLineArguments config;
    private final Map<Formats.ProvFormat, SerializerFunction> serializerMap;
    private final Map<Formats.ProvFormat, DeserializerFunction> deserializerMap;
    static String SEPARATOR;
    private Integer maxStringLength = 100;

    public static Properties getPropertiesFromClasspath(String propFileName) {
        return Configuration.getPropertiesFromClasspath(InteropFramework.class, (String)propFileName);
    }

    public static ProvFactory getDefaultFactory() {
        return defaultFactory;
    }

    public static ProvFactory dynamicallyLoadFactory(String factory) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(factory);
            Method method = clazz.getMethod("getFactory", new Class[0]);
            return (ProvFactory)method.invoke((Object)new Object[0], new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public InteropFramework() {
        this(new CommandLineArguments(), defaultFactory);
    }

    public InteropFramework(ProvFactory pFactory) {
        this(new CommandLineArguments(), pFactory);
    }

    public InteropFramework(CommandLineArguments config, ProvFactory pFactory) {
        this.pFactory = pFactory;
        this.config = config;
        this.extensionMap = new Hashtable();
        this.extensionRevMap = new Hashtable();
        this.mimeTypeMap = new Hashtable();
        this.mimeTypeRevMap = new Hashtable();
        this.provTypeMap = new Hashtable();
        this.initializeExtensionMap(this.extensionMap, this.extensionRevMap);
        this.serializerMap = this.createSerializerMap();
        this.deserializerMap = this.createDeserializerMap();
    }

    public String buildAcceptHeader() {
        StringBuilder mimetypes = new StringBuilder();
        Enumeration<Formats.ProvFormat> e = this.mimeTypeMap.keys();
        String sep = "";
        while (e.hasMoreElements()) {
            Formats.ProvFormat f = e.nextElement();
            if (!this.isInputFormat(f).booleanValue()) continue;
            mimetypes.append(sep);
            sep = ",";
            mimetypes.append(this.mimeTypeMap.get(f));
        }
        mimetypes.append(sep);
        mimetypes.append("*/*;q=0.1");
        return mimetypes.toString();
    }

    public URLConnection connectWithRedirect(URL theURL) throws IOException {
        URLConnection conn = null;
        String accept_header = this.buildAcceptHeader();
        int redirect_count = 0;
        boolean done = false;
        while (!done) {
            if (theURL.getProtocol().equals("file")) {
                return null;
            }
            boolean isHttp = theURL.getProtocol().equals("http") || theURL.getProtocol().equals("https");
            logger.debug("Requesting: " + theURL);
            conn = theURL.openConnection();
            if (isHttp) {
                logger.debug("Accept: " + accept_header);
                conn.setRequestProperty("Accept", accept_header);
            }
            conn.setConnectTimeout(60000);
            conn.setReadTimeout(60000);
            conn.connect();
            done = true;
            if (!isHttp) continue;
            logger.debug("Response: " + conn.getHeaderField(0));
            int rc = ((HttpURLConnection)conn).getResponseCode();
            if (rc == 301 || rc == 302 || rc == 303 || rc == 307) {
                if (redirect_count > 10) {
                    return null;
                }
                ++redirect_count;
                String loc = conn.getHeaderField("Location");
                if (loc != null) {
                    theURL = new URL(loc);
                    done = false;
                    continue;
                }
                return null;
            }
            if (rc >= 200 && rc < 300) continue;
            return null;
        }
        return conn;
    }

    public String convertExtensionToMediaType(String extension) {
        Formats.ProvFormat format = this.extensionRevMap.get(extension);
        if (format == null) {
            return null;
        }
        return this.mimeTypeMap.get(format);
    }

    public String getExtension(Formats.ProvFormat format) {
        String extension = UNKNOWN;
        if (format != null) {
            extension = this.extensionMap.get(format);
        }
        return extension;
    }

    String getOption(String[] options, int index) {
        if (options != null && options.length > index) {
            return options[index];
        }
        return null;
    }

    public Formats.ProvFormat getTypeForFile(String filename) {
        int count = filename.lastIndexOf(".");
        if (count == -1) {
            return null;
        }
        String extension = filename.substring(count + 1);
        return this.extensionRevMap.get(extension);
    }

    public Formats.ProvFormat getTypeForFormat(String format) {
        Formats.ProvFormat result = this.mimeTypeRevMap.get(format);
        if (result == null) {
            result = this.extensionRevMap.get(format);
        }
        return result;
    }

    public List<Variant> getVariants() {
        ArrayList<Variant> vs = new ArrayList<Variant>();
        for (Map.Entry<String, Formats.ProvFormat> entry : this.mimeTypeRevMap.entrySet()) {
            if (!this.isOutputFormat(entry.getValue()).booleanValue()) continue;
            String[] parts = entry.getKey().split("/");
            MediaType m = new MediaType(parts[0], parts[1]);
            vs.add(new Variant(m, (Locale)null, null));
        }
        return vs;
    }

    public void initializeExtensionMap(Hashtable<Formats.ProvFormat, String> extensionMap, Hashtable<String, Formats.ProvFormat> extensionRevMap) {
        block13: for (Formats.ProvFormat f : Formats.ProvFormat.values()) {
            switch (f) {
                case DOT: {
                    extensionMap.put(Formats.ProvFormat.DOT, "dot");
                    extensionRevMap.put("dot", Formats.ProvFormat.DOT);
                    extensionRevMap.put("gv", Formats.ProvFormat.DOT);
                    this.mimeTypeMap.put(Formats.ProvFormat.DOT, "text/vnd.graphviz");
                    this.mimeTypeRevMap.put("text/vnd.graphviz", Formats.ProvFormat.DOT);
                    this.provTypeMap.put(Formats.ProvFormat.DOT, Formats.ProvFormatType.OUTPUT);
                    continue block13;
                }
                case JPEG: {
                    extensionMap.put(Formats.ProvFormat.JPEG, "jpg");
                    extensionRevMap.put("jpeg", Formats.ProvFormat.JPEG);
                    extensionRevMap.put("jpg", Formats.ProvFormat.JPEG);
                    this.mimeTypeMap.put(Formats.ProvFormat.JPEG, "image/jpeg");
                    this.mimeTypeRevMap.put("image/jpeg", Formats.ProvFormat.JPEG);
                    this.provTypeMap.put(Formats.ProvFormat.JPEG, Formats.ProvFormatType.OUTPUT);
                    continue block13;
                }
                case PNG: {
                    extensionMap.put(Formats.ProvFormat.PNG, "png");
                    extensionRevMap.put("png", Formats.ProvFormat.PNG);
                    this.mimeTypeMap.put(Formats.ProvFormat.PNG, "image/png");
                    this.mimeTypeRevMap.put("image/png", Formats.ProvFormat.PNG);
                    this.provTypeMap.put(Formats.ProvFormat.PNG, Formats.ProvFormatType.OUTPUT);
                    continue block13;
                }
                case JSON: {
                    extensionMap.put(Formats.ProvFormat.JSON, "json");
                    extensionRevMap.put("json", Formats.ProvFormat.JSON);
                    this.mimeTypeMap.put(Formats.ProvFormat.JSON, "application/json");
                    this.mimeTypeRevMap.put("application/json", Formats.ProvFormat.JSON);
                    this.provTypeMap.put(Formats.ProvFormat.JSON, Formats.ProvFormatType.INPUTOUTPUT);
                    continue block13;
                }
                case PDF: {
                    extensionMap.put(Formats.ProvFormat.PDF, "pdf");
                    extensionRevMap.put("pdf", Formats.ProvFormat.PDF);
                    this.mimeTypeMap.put(Formats.ProvFormat.PDF, "application/pdf");
                    this.mimeTypeRevMap.put("application/pdf", Formats.ProvFormat.PDF);
                    this.provTypeMap.put(Formats.ProvFormat.PDF, Formats.ProvFormatType.OUTPUT);
                    continue block13;
                }
                case PROVN: {
                    extensionMap.put(Formats.ProvFormat.PROVN, "provn");
                    extensionRevMap.put("provn", Formats.ProvFormat.PROVN);
                    extensionRevMap.put("pn", Formats.ProvFormat.PROVN);
                    extensionRevMap.put("asn", Formats.ProvFormat.PROVN);
                    extensionRevMap.put("prov-asn", Formats.ProvFormat.PROVN);
                    this.mimeTypeMap.put(Formats.ProvFormat.PROVN, "text/provenance-notation");
                    this.mimeTypeRevMap.put("text/provenance-notation", Formats.ProvFormat.PROVN);
                    this.provTypeMap.put(Formats.ProvFormat.PROVN, Formats.ProvFormatType.INPUTOUTPUT);
                    continue block13;
                }
                case SVG: {
                    extensionMap.put(Formats.ProvFormat.SVG, "svg");
                    extensionRevMap.put("svg", Formats.ProvFormat.SVG);
                    this.mimeTypeMap.put(Formats.ProvFormat.SVG, "image/svg+xml");
                    this.mimeTypeRevMap.put("image/svg+xml", Formats.ProvFormat.SVG);
                    this.provTypeMap.put(Formats.ProvFormat.SVG, Formats.ProvFormatType.OUTPUT);
                    continue block13;
                }
                case TRIG: {
                    extensionMap.put(Formats.ProvFormat.TRIG, "trig");
                    extensionRevMap.put("trig", Formats.ProvFormat.TRIG);
                    this.mimeTypeMap.put(Formats.ProvFormat.TRIG, "application/trig");
                    this.mimeTypeRevMap.put("application/trig", Formats.ProvFormat.TRIG);
                    this.provTypeMap.put(Formats.ProvFormat.TRIG, Formats.ProvFormatType.INPUTOUTPUT);
                    continue block13;
                }
                case TURTLE: {
                    extensionMap.put(Formats.ProvFormat.TURTLE, "ttl");
                    extensionRevMap.put("ttl", Formats.ProvFormat.TURTLE);
                    this.mimeTypeMap.put(Formats.ProvFormat.TURTLE, "text/turtle");
                    this.mimeTypeRevMap.put("text/turtle", Formats.ProvFormat.TURTLE);
                    this.provTypeMap.put(Formats.ProvFormat.TURTLE, Formats.ProvFormatType.INPUTOUTPUT);
                    continue block13;
                }
                case JSONLD: {
                    extensionMap.put(Formats.ProvFormat.JSONLD, "jsonld");
                    extensionRevMap.put("jsonld", Formats.ProvFormat.JSONLD);
                    this.mimeTypeMap.put(Formats.ProvFormat.JSONLD, "application/ld+json");
                    this.mimeTypeRevMap.put("application/ld+json", Formats.ProvFormat.JSONLD);
                    this.provTypeMap.put(Formats.ProvFormat.JSONLD, Formats.ProvFormatType.INPUTOUTPUT);
                    continue block13;
                }
                case XML: {
                    extensionMap.put(Formats.ProvFormat.XML, "provx");
                    extensionRevMap.put("provx", Formats.ProvFormat.XML);
                    extensionRevMap.put("xml", Formats.ProvFormat.XML);
                    this.mimeTypeMap.put(Formats.ProvFormat.XML, "application/provenance+xml");
                    this.mimeTypeRevMap.put("application/provenance+xml", Formats.ProvFormat.XML);
                    this.provTypeMap.put(Formats.ProvFormat.XML, Formats.ProvFormatType.INPUTOUTPUT);
                    continue block13;
                }
            }
        }
    }

    public Boolean isInputFormat(Formats.ProvFormat format) {
        Formats.ProvFormatType t = this.provTypeMap.get(format);
        return t.equals((Object)Formats.ProvFormatType.INPUT) || t.equals((Object)Formats.ProvFormatType.INPUTOUTPUT);
    }

    public Boolean isOutputFormat(Formats.ProvFormat format) {
        Formats.ProvFormatType t = this.provTypeMap.get(format);
        return t.equals((Object)Formats.ProvFormatType.OUTPUT) || t.equals((Object)Formats.ProvFormatType.INPUTOUTPUT);
    }

    public Object loadProvUnknownGraph(String filename) {
        try {
            Utility u = new Utility();
            Object o = u.convertTreeToJavaBean(u.convertSyntaxTreeToTree(filename), this.pFactory);
            if (o != null) {
                return o;
            }
        }
        catch (RuntimeException u) {
            // empty catch block
        }
        try {
            File in = new File(filename);
            org.openprovenance.prov.core.xml.serialization.ProvDeserialiser deserial = new org.openprovenance.prov.core.xml.serialization.ProvDeserialiser();
            Document c = deserial.deserialiseDocument(in);
            if (c != null) {
                return c;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("Unparseable format " + filename);
        throw new UnsupportedOperationException();
    }

    public Document readDocument(InputStream is, Formats.ProvFormat format, String baseuri) {
        return this.readDocument(is, format, this.pFactory, baseuri);
    }

    public Document readDocument(InputStream is, Formats.ProvFormat format, ProvFactory pFactory, String baseuri) {
        switch (format) {
            case DOT: 
            case JPEG: 
            case PNG: 
            case SVG: {
                throw new UnsupportedOperationException();
            }
            case PROVN: {
                Utility u = new Utility();
                Object o = u.convertTreeToJavaBean(u.convertSyntaxTreeToTree(is), pFactory);
                return (Document)o;
            }
            case XML: {
                org.openprovenance.prov.core.xml.serialization.ProvDeserialiser deserial = new org.openprovenance.prov.core.xml.serialization.ProvDeserialiser();
                Document doc = null;
                try {
                    doc = deserial.deserialiseDocument(is);
                }
                catch (IOException e) {
                    throw new InteropException(e);
                }
                return doc;
            }
        }
        System.out.println("Unknown format " + format);
        throw new UnsupportedOperationException();
    }

    public Document readDocument(String url) {
        try {
            URL theURL = new URL(url);
            URLConnection conn = this.connectWithRedirect(theURL);
            if (conn == null) {
                return null;
            }
            Formats.ProvFormat format = null;
            String content_type = conn.getContentType();
            logger.debug("Content-type: " + content_type);
            if (content_type != null) {
                int end = content_type.indexOf(";");
                if (end < 0) {
                    end = content_type.length();
                }
                String actual_content_type = content_type.substring(0, end).trim();
                logger.debug("Found Content-type: " + actual_content_type);
                format = this.mimeTypeRevMap.get(actual_content_type);
            }
            logger.debug("Format after Content-type: " + format);
            if (format == null) {
                format = this.getTypeForFile(theURL.toString());
            }
            logger.debug("Format after extension: " + format);
            InputStream content_stream = conn.getInputStream();
            return this.readDocument(content_stream, format, url);
        }
        catch (IOException e) {
            throw new InteropException(e);
        }
    }

    public Document readDocumentFromFile(String filename) {
        Formats.ProvFormat format = this.getTypeForFile(filename);
        if (format == null) {
            throw new InteropException("Unknown output file format: " + filename);
        }
        try {
            return this.deserialiseDocument(Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]), format);
        }
        catch (IOException e) {
            throw new InteropException(e);
        }
    }

    public Document readDocumentFromFile(String filename, Formats.ProvFormat format) {
        try {
            switch (format) {
                case DOT: 
                case JPEG: 
                case PNG: 
                case SVG: {
                    throw new UnsupportedOperationException();
                }
                case PROVN: {
                    Utility u = new Utility();
                    Object o = u.convertTreeToJavaBean(u.convertSyntaxTreeToTree(filename), this.pFactory);
                    return (Document)o;
                }
                case TRIG: 
                case JSONLD: 
                case XML: 
                case RDFXML: {
                    File in = new File(filename);
                    org.openprovenance.prov.core.xml.serialization.ProvDeserialiser deserial = new org.openprovenance.prov.core.xml.serialization.ProvDeserialiser();
                    Document doc = deserial.deserialiseDocument(in);
                    return doc;
                }
            }
            System.out.println("Unknown format " + filename);
            throw new UnsupportedOperationException();
        }
        catch (IOException | RuntimeException e) {
            throw new InteropException(e);
        }
    }

    public List<Map<String, String>> getSupportedFormats() {
        ArrayList<Map<String, String>> tripleList = new ArrayList<Map<String, String>>();
        for (Formats.ProvFormat pt : this.provTypeMap.keySet()) {
            for (String mt : this.mimeTypeRevMap.keySet()) {
                if (this.mimeTypeRevMap.get(mt) != pt) continue;
                for (String ext : this.extensionRevMap.keySet()) {
                    HashMap<String, String> trip;
                    if (this.extensionRevMap.get(ext) != pt) continue;
                    if (this.isInputFormat(pt).booleanValue()) {
                        trip = new HashMap<String, String>();
                        trip.put("extension", ext);
                        trip.put("mediatype", mt);
                        trip.put("type", "input");
                        tripleList.add(trip);
                    }
                    if (!this.isOutputFormat(pt).booleanValue()) continue;
                    trip = new HashMap();
                    trip.put("extension", ext);
                    trip.put("mediatype", mt);
                    trip.put("type", "output");
                    tripleList.add(trip);
                }
            }
        }
        return tripleList;
    }

    private Document doReadDocument(String filename, String format) {
        Document doc;
        Formats.ProvFormat informat;
        if (format != null) {
            informat = this.getTypeForFormat(format);
            if (informat == null) {
                throw new InteropException("Unknown format: " + format);
            }
        } else {
            informat = this.getTypeForFile(filename);
            if (informat == null) {
                throw new InteropException("Unknown file format for: " + filename);
            }
        }
        if (Objects.equals(filename, "-")) {
            if (informat == null) {
                throw new InteropException("File format for standard input not specified");
            }
            doc = this.readDocument(System.in, informat, "file://stdin/");
        } else {
            doc = this.readDocumentFromFile(filename, informat);
        }
        return doc;
    }

    private void doWriteDocument(String filename, String format, Document doc) {
        Formats.ProvFormat outformat;
        if (format != null) {
            outformat = this.getTypeForFormat(format);
            if (outformat == null) {
                throw new InteropException("Unknown format: " + format);
            }
        } else {
            outformat = this.getTypeForFile(filename);
            if (outformat == null) {
                throw new InteropException("Unknown file format for: " + filename);
            }
        }
        if (Objects.equals(filename, "-")) {
            if (outformat == null) {
                throw new InteropException("File format for standard output not specified");
            }
            this.writeDocument((OutputStream)System.out, outformat, doc);
        } else {
            this.writeDocument(filename, outformat, doc);
        }
    }

    public void serialiseDocument(OutputStream out, Document document, boolean formatted) {
        throw new UnsupportedOperationException("InteropFramework()  serialize Document requires a media type");
    }

    public void serialiseDocument(OutputStream out, Document document, String mediaType, boolean formatted) {
        Formats.ProvFormat format = this.mimeTypeRevMap.get(mediaType);
        if (format == null) {
            throw new UnsupportedOperationException("InteropFramework(): serialisedDocument unknown mediatype " + mediaType);
        }
        SerializerFunction serializerMaker = this.serializerMap.get(format);
        logger.debug("serializer " + format + " " + serializerMaker);
        serializerMaker.apply().serialiseDocument(out, document, mediaType, formatted);
    }

    public Document deserialiseDocument(InputStream is, Formats.ProvFormat format) throws IOException {
        DeserializerFunction deserializer = this.deserializerMap.get(format);
        logger.debug("deserializer " + format + " " + deserializer);
        return deserializer.apply().deserialiseDocument(is);
    }

    public Collection<String> mediaTypes() {
        return this.mimeTypeRevMap.keySet();
    }

    public Document readDocument(ToRead something) {
        Document doc = null;
        switch (something.kind) {
            case FILE: {
                doc = this.readDocumentFromFile(something.url, something.format);
                break;
            }
            case URL: {
                doc = this.readDocument(something.url);
            }
        }
        return doc;
    }

    private List<ToRead> readIndexFile(File fin) throws IOException {
        FileInputStream fis = new FileInputStream(fin);
        return this.readIndexFile(fis);
    }

    private List<ToRead> readIndexFile(InputStream is) throws IOException {
        String line;
        LinkedList<ToRead> res = new LinkedList<ToRead>();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((line = br.readLine()) != null) {
            String[] parts = line.split(SEPARATOR);
            if (parts.length >= 3) {
                FileKind kind = parts[0].trim().equals("URL") ? FileKind.URL : FileKind.FILE;
                String path = parts[1].trim();
                Formats.ProvFormat format = this.getTypeForFormat(parts[2].trim());
                ToRead elem = new ToRead(kind, path, format);
                res.add(elem);
                continue;
            }
            if (parts.length != 1) continue;
            String filename = parts[0].trim();
            ToRead elem = new ToRead(FileKind.FILE, filename, this.getTypeForFile(filename));
            res.add(elem);
        }
        br.close();
        return res;
    }

    public int run() {
        Document doc;
        if (this.config.config) {
            String classpath = System.getProperty("java.class.path");
            System.out.println("provconvert.classpath=" + classpath);
            System.out.println("provconvert.main=" + CommandLineArguments.class.getName());
            return 0;
        }
        if (this.config.outfile == null && this.config.compare == null && this.config.template_builder == null) {
            return 3;
        }
        if (this.config.infile == null && this.config.generator == null && this.config.template_builder == null && this.config.merge == null) {
            return 2;
        }
        if (Objects.equals(this.config.infile, "-") && Objects.equals(this.config.bindings, "-")) {
            throw new InteropException("Cannot use standard input for both infile and bindings");
        }
        if (this.config.infile != null && this.config.log2prov == null) {
            doc = this.doReadDocument(this.config.infile, this.config.informat);
        } else if (this.config.merge != null) {
            IndexedDocument iDoc = new IndexedDocument(this.pFactory, this.pFactory.newDocument(), this.config.flatten != null);
            try {
                List<ToRead> files = this.config.merge.equals("-") ? this.readIndexFile(System.in) : this.readIndexFile(new File(this.config.merge));
                for (ToRead something : files) {
                    iDoc.merge(this.readDocument(something));
                }
            }
            catch (IOException e) {
                System.err.println("problem reading index file");
                e.printStackTrace();
            }
            doc = iDoc.toDocument();
        } else {
            if (this.config.template_builder != null) {
                ConfigProcessor cp = new ConfigProcessor(this.pFactory);
                return cp.processTemplateGenerationConfig(this.config.template_builder, this.pFactory);
            }
            if (this.config.log2prov != null) {
                try {
                    Class<?> clazz = Class.forName(this.config.log2prov);
                    Method method = clazz.getMethod("main", String[].class);
                    try {
                        if (this.config.log2kernel) {
                            List<String> init = List.of("kernel", "-infile", this.config.infile, "-outfile", this.config.outfile);
                            LinkedList<String> ll = new LinkedList<String>(init);
                            Map<String, String> env = System.getenv();
                            String tmp = env.get("LEVEL_OFFSET");
                            if (tmp != null && !tmp.isEmpty()) {
                                ll.add("-levelOffset");
                                ll.add(tmp);
                            }
                            if ((tmp = env.get("LEVEL_NUMBER")) != null && !tmp.isEmpty()) {
                                ll.add("-levelNumber");
                                ll.add(tmp);
                            }
                            if ((tmp = env.get("SET_OFFSET")) != null && !tmp.isEmpty()) {
                                ll.add("-setOffset");
                                ll.add(tmp);
                            }
                            if ((tmp = env.get("RELATION_OFFSET")) != null && !tmp.isEmpty()) {
                                ll.add("-relationOffset");
                                ll.add(tmp);
                            }
                            if ((tmp = env.get("KNOWN_TYPES")) != null && !tmp.isEmpty()) {
                                ll.add("-knownTypes");
                                ll.add(tmp);
                            }
                            if ((tmp = env.get("KNOWN_RELATIONS")) != null && !tmp.isEmpty()) {
                                ll.add("-knownRelations");
                                ll.add(tmp);
                            }
                            if ((tmp = env.get("TRANSLATION")) != null && !tmp.isEmpty()) {
                                ll.add("-translation");
                                ll.add(tmp);
                            }
                            if ((tmp = env.get("ADDLEVEL0")) != null && !tmp.isEmpty()) {
                                ll.add("-addlevel0");
                                ll.add(tmp);
                            }
                            if ((tmp = env.get("PROPERTY_CONVERTERS")) != null && !tmp.isEmpty()) {
                                ll.add("-propertyConverters");
                                ll.add(tmp);
                            }
                            logger.debug("log2kernel " + ll);
                            method.invoke(null, new Object[]{ll.toArray(new String[0])});
                        } else {
                            method.invoke(null, new Object[]{new String[]{this.config.infile, this.config.outfile, "-merge"}});
                        }
                        return 0;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        return -1;
                    }
                }
                catch (ClassNotFoundException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
                    e.printStackTrace();
                    return -1;
                }
            }
            String[] options = this.config.generator.split(":");
            String noOfNodes = this.getOption(options, 0);
            String noOfEdges = this.getOption(options, 1);
            String firstNode = this.getOption(options, 2);
            String namespace = "http://expample.org/";
            String seed = this.getOption(options, 3);
            String term = this.getOption(options, 4);
            if (term == null) {
                term = "e1";
            }
            GeneratorDetails gd = new GeneratorDetails(Integer.parseInt(noOfNodes), Integer.parseInt(noOfEdges), firstNode, namespace, seed == null ? null : Long.valueOf(seed), term);
            System.err.println(gd);
            GraphGenerator gg = new GraphGenerator(gd, this.pFactory);
            gg.generateElements();
            doc = gg.getDetails().getDocument();
        }
        if (this.config.compare != null) {
            return this.doCompare(doc, this.doReadDocument(this.config.compare, this.config.informat));
        }
        if (this.config.template != null && !this.config.builder) {
            BindingsBeanGenerator bbgen = new BindingsBeanGenerator(this.pFactory);
            boolean val = bbgen.generate(doc, this.config.template, this.config.packge, this.config.outfile, this.config.location);
            return val ? 0 : 7;
        }
        if (this.config.template != null && this.config.builder) {
            ConfigProcessor cp = new ConfigProcessor(this.pFactory);
            if (this.config.bindings != null) {
                if (this.config.bindingsVersion >= 3) {
                    try {
                        TemplatesCompilerConfig configs = new TemplatesCompilerConfig();
                        Locations locations = new Locations(configs, null);
                        cp.generate(doc, locations, this.config.template, this.config.packge, this.config.outfile, this.config.location, this.config.location, true, this.config.location, "schema.json", "documentation.html", cp.readTree(new File(this.config.bindings)), cp.getBindingsSchema(this.config.bindings), null, this.config.location + "/src/main/resources/project/version/", false, new LinkedList(), null, null);
                        return 0;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    throw new DocumentedUnsupportedCaseException("bindings version number < 3");
                }
            }
        }
        if (this.config.index != null) {
            doc = new IndexedDocument(this.pFactory, doc, this.config.flatten != null).toDocument();
        }
        if (this.config.bindings != null) {
            Bindings inBindings;
            Expand myExpand = new Expand(this.pFactory, this.config.addOrderp, this.config.allExpanded);
            if (this.config.bindingsVersion == 3) {
                try {
                    inBindings = (Bindings)new ObjectMapper().readValue(new File(this.config.bindings), Bindings.class);
                }
                catch (IOException e) {
                    throw new InteropException("problem parsing bindings file " + this.config.bindings, e);
                }
            } else {
                throw new DocumentedUnsupportedCaseException("bindings version number <> 3");
            }
            Document expanded = myExpand.expander(doc, inBindings);
            boolean flag = myExpand.getAllExpanded();
            this.doWriteDocument(this.config.outfile, this.config.outformat, expanded);
            if (!flag) {
                return 7;
            }
        } else {
            this.doWriteDocument(this.config.outfile, this.config.outformat, doc);
        }
        return 0;
    }

    private int doCompare(Document doc1, Document doc2) {
        if (doc1 == null) {
            return 4;
        }
        if (doc2 == null) {
            return 5;
        }
        PrintStream ps = System.out;
        try {
            if (this.config.compareOut != null && !this.config.compareOut.equals("-")) {
                ps = new PrintStream(this.config.compareOut);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        DocumentEquality comparator = new DocumentEquality(false, ps);
        logger.debug("about to compare two docs");
        if (comparator.check(doc1, doc2)) {
            return 0;
        }
        return 6;
    }

    public void setNamespaces(Document doc) {
        if (doc.getNamespace() == null) {
            doc.setNamespace(new Namespace());
        }
    }

    public void writeDocument(OutputStream os, MediaType mt, Document document) {
        Formats.ProvFormat format = this.mimeTypeRevMap.get(mt.toString());
        this.writeDocument(os, format, document);
    }

    public void writeDocument(OutputStream os, Formats.ProvFormat format, Document document) {
        this.serialiseDocument(os, document, this.mimeTypeMap.get(format), true);
    }

    public void writeDocumentOLD(OutputStream os, Formats.ProvFormat format, Document document) {
        Namespace.withThreadNamespace((Namespace)document.getNamespace());
        try {
            if (format == null) {
                System.err.println("Unknown output format: " + format);
                return;
            }
            logger.debug("writing " + format);
            this.setNamespaces(document);
            switch (format) {
                case PROVN: {
                    new Utility().writeDocument(document, os, this.pFactory);
                    break;
                }
                case XML: {
                    org.openprovenance.prov.model.ProvSerialiser serial = this.pFactory.getSerializer();
                    logger.debug("namespaces " + document.getNamespace());
                    serial.serialiseDocument(os, document, true);
                    break;
                }
                case DOT: {
                    ProvToDot toDot = new ProvToDot(this.pFactory);
                    toDot.setMaxStringLength(this.maxStringLength);
                    toDot.convert(document, os, this.config.title);
                    break;
                }
                case JPEG: 
                case PNG: 
                case PDF: 
                case SVG: {
                    File tmp = File.createTempFile("viz-", ".dot");
                    String dotFileOut = tmp.getAbsolutePath();
                    ProvToDot toDot = new ProvToDot(this.pFactory);
                    toDot.setMaxStringLength(this.maxStringLength);
                    toDot.convert(document, dotFileOut, os, this.extensionMap.get(format), this.config.title);
                    tmp.delete();
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            if (this.config.verbose != null) {
                e.printStackTrace();
            }
            throw new InteropException(e);
        }
        catch (Exception e) {
            if (this.config.verbose != null) {
                e.printStackTrace();
            }
            throw new InteropException(e);
        }
    }

    public void writeDocument(String filename, Document document) {
        Formats.ProvFormat format = this.getTypeForFile(filename);
        if (format == null) {
            System.err.println("Unknown output file format: " + filename);
            return;
        }
        this.writeDocument(filename, format, document);
    }

    public final Map<Formats.ProvFormat, SerializerFunction> createLightSerializerMap() {
        HashMap<Formats.ProvFormat, SerializerFunction> serializer = new HashMap<Formats.ProvFormat, SerializerFunction>();
        serializer.putAll(Map.of(Formats.ProvFormat.PROVN, () -> new org.openprovenance.prov.notation.ProvSerialiser(this.pFactory), Formats.ProvFormat.XML, () -> new org.openprovenance.prov.core.xml.serialization.ProvSerialiser(true), Formats.ProvFormat.TURTLE, () -> {
            throw new UnsupportedOperationException("light turtle converter not integrated yet");
        }, Formats.ProvFormat.JSONLD, () -> new org.openprovenance.prov.core.jsonld11.serialization.ProvSerialiser(new ObjectMapper(), false), Formats.ProvFormat.TRIG, () -> {
            throw new UnsupportedOperationException("light turtle converter not integrated yet");
        }, Formats.ProvFormat.JSON, org.openprovenance.prov.core.json.serialization.ProvSerialiser::new));
        serializer.putAll(Map.of(Formats.ProvFormat.JPEG, () -> new ProvSerialiser(this.pFactory, this.extensionMap.get(Formats.ProvFormat.JPEG), this.maxStringLength), Formats.ProvFormat.SVG, () -> new ProvSerialiser(this.pFactory, this.extensionMap.get(Formats.ProvFormat.SVG), this.maxStringLength), Formats.ProvFormat.PDF, () -> new ProvSerialiser(this.pFactory, this.extensionMap.get(Formats.ProvFormat.PDF), this.maxStringLength), Formats.ProvFormat.PNG, () -> new ProvSerialiser(this.pFactory, this.extensionMap.get(Formats.ProvFormat.PNG), this.maxStringLength), Formats.ProvFormat.DOT, () -> new ProvSerialiser(this.pFactory, this.extensionMap.get(Formats.ProvFormat.DOT), this.maxStringLength)));
        return serializer;
    }

    public final Map<Formats.ProvFormat, DeserializerFunction> createLightDeserializerMap() {
        HashMap<Formats.ProvFormat, DeserializerFunction> serializer = new HashMap<Formats.ProvFormat, DeserializerFunction>();
        serializer.putAll(Map.of(Formats.ProvFormat.PROVN, () -> new org.openprovenance.prov.notation.ProvDeserialiser(this.pFactory), Formats.ProvFormat.XML, org.openprovenance.prov.core.xml.serialization.ProvDeserialiser::new, Formats.ProvFormat.JSONLD, org.openprovenance.prov.core.jsonld11.serialization.ProvDeserialiser::new, Formats.ProvFormat.JSON, ProvDeserialiser::new));
        return serializer;
    }

    public Map<Formats.ProvFormat, SerializerFunction> createSerializerMap() {
        switch (configuration) {
            case "light": {
                return this.createLightSerializerMap();
            }
        }
        throw new IllegalStateException("Unexpected configuration value: " + configuration);
    }

    public Map<Formats.ProvFormat, DeserializerFunction> createDeserializerMap() {
        switch (configuration) {
            case "light": {
                return this.createLightDeserializerMap();
            }
        }
        throw new IllegalStateException("Unexpected configuration value: " + configuration);
    }

    public void setMaxStringLength(Integer maxStringLength) {
        this.maxStringLength = maxStringLength;
        this.serializerMap.put(Formats.ProvFormat.SVG, () -> new ProvSerialiser(this.pFactory, this.extensionMap.get(Formats.ProvFormat.SVG), maxStringLength));
    }

    public void writeDocument(String filename, Formats.ProvFormat format, Document document) {
        Namespace.withThreadNamespace((Namespace)document.getNamespace());
        try {
            logger.debug("writing " + format);
            logger.debug("writing " + filename);
            this.setNamespaces(document);
            switch (format) {
                case PROVN: {
                    new Utility().writeDocument(document, filename, this.pFactory);
                    break;
                }
                case XML: {
                    org.openprovenance.prov.core.xml.serialization.ProvSerialiser serial = new org.openprovenance.prov.core.xml.serialization.ProvSerialiser();
                    logger.debug("namespaces " + document.getNamespace());
                    serial.serialiseDocument(Files.newOutputStream(new File(filename).toPath(), new OpenOption[0]), document, true);
                    break;
                }
                case DOT: {
                    ProvToDot toDot = new ProvToDot(this.pFactory);
                    toDot.setMaxStringLength(this.maxStringLength);
                    toDot.setLayout(this.config.layout);
                    toDot.convert(document, filename, this.config.title);
                    break;
                }
                case JPEG: 
                case PNG: 
                case PDF: 
                case SVG: {
                    File tmp = File.createTempFile("viz-", ".dot");
                    String dotFileOut = tmp.getAbsolutePath();
                    ProvToDot toDot = new ProvToDot(this.pFactory);
                    toDot.setMaxStringLength(this.maxStringLength);
                    toDot.setLayout(this.config.layout);
                    toDot.convert(document, dotFileOut, filename, this.extensionMap.get(format), this.config.title);
                    tmp.delete();
                    break;
                }
            }
        }
        catch (IOException | RuntimeException e) {
            if (this.config.verbose != null) {
                e.printStackTrace();
            }
            throw new InteropException(e);
        }
    }

    static {
        Properties properties = InteropFramework.getPropertiesFromClasspath(configFile);
        configuration = (String)properties.get("interop.config");
        factoryClass = properties.getProperty("prov.factory");
        defaultFactory = InteropFramework.dynamicallyLoadFactory(factoryClass);
        logger = LogManager.getLogger(InteropFramework.class);
        SEPARATOR = ",";
    }

    static class ToRead {
        FileKind kind;
        String url;
        Formats.ProvFormat format;

        public String toString() {
            return "[" + this.kind + "," + this.url + "," + this.format + "]";
        }

        ToRead(FileKind kind, String url, Formats.ProvFormat format) {
            this.kind = kind;
            this.url = url;
            this.format = format;
        }
    }

    static enum FileKind {
        FILE,
        URL;

    }
}

