/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.interop;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openprovenance.prov.core.jsonld11.serialization.ProvSerialiser;
import org.openprovenance.prov.interop.Formats;
import org.openprovenance.prov.interop.InteropException;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.interop.InteropMediaType;
import org.openprovenance.prov.interop.SerializerFunction;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;

public class Outputer
implements InteropMediaType {
    private final InteropFramework interopFramework;
    private final ProvFactory pFactory;
    Integer maxStringLength = 100;
    private final Map<Formats.ProvFormat, SerializerFunction> serializerMap;

    public Outputer(InteropFramework interopFramework, ProvFactory pFactory) {
        this.interopFramework = interopFramework;
        this.pFactory = pFactory;
        this.serializerMap = this.createSerializerMap();
    }

    void setNamespaces(Document doc) {
        if (doc.getNamespace() == null) {
            doc.setNamespace(new Namespace());
        }
    }

    public void writeDocument(String filename, Document document) {
        Formats.ProvFormat format = this.interopFramework.getTypeForFile(filename);
        if (format == null) {
            throw new InteropException("Format could not be determined from filename extension: " + filename);
        }
        this.writeDocument(filename, document, format);
    }

    public void writeDocumentToFileOrDefaultOutput(String filename, Document doc, String format) throws IOException {
        Formats.ProvFormat outformat;
        if (format != null) {
            outformat = this.interopFramework.getTypeForFormat(format);
            if (outformat == null) {
                throw new InteropException("Unknown format: " + format);
            }
        } else {
            outformat = this.interopFramework.getTypeForFile(filename);
            if (outformat == null) {
                throw new InteropException("Unknown file format for: " + filename);
            }
        }
        if (Objects.equals(filename, "-")) {
            this.writeDocument(System.out, doc, outformat);
        } else {
            this.writeDocument(Files.newOutputStream(new File(filename).toPath(), new OpenOption[0]), doc, outformat);
        }
    }

    public final Map<Formats.ProvFormat, SerializerFunction> createSerializerMap() {
        HashMap<Formats.ProvFormat, SerializerFunction> serializer = new HashMap<Formats.ProvFormat, SerializerFunction>();
        serializer.putAll(Map.of(Formats.ProvFormat.PROVN, () -> new org.openprovenance.prov.notation.ProvSerialiser(this.pFactory), Formats.ProvFormat.PROVX, () -> new org.openprovenance.prov.core.xml.serialization.ProvSerialiser(true), Formats.ProvFormat.JSONLD, () -> new ProvSerialiser(new ObjectMapper(), false), Formats.ProvFormat.JSON, org.openprovenance.prov.core.json.serialization.ProvSerialiser::new, Formats.ProvFormat.TURTLE, () -> {
            throw new UnsupportedOperationException("light turtle converter not integrated yet");
        }, Formats.ProvFormat.TRIG, () -> {
            throw new UnsupportedOperationException("light turtle converter not integrated yet");
        }));
        serializer.putAll(Map.of(Formats.ProvFormat.JPEG, () -> new org.openprovenance.prov.dot.ProvSerialiser(this.pFactory, this.interopFramework.getExtensionMap().get(Formats.ProvFormat.JPEG), this.maxStringLength), Formats.ProvFormat.SVG, () -> new org.openprovenance.prov.dot.ProvSerialiser(this.pFactory, this.interopFramework.getExtensionMap().get(Formats.ProvFormat.SVG), this.maxStringLength), Formats.ProvFormat.PDF, () -> new org.openprovenance.prov.dot.ProvSerialiser(this.pFactory, this.interopFramework.getExtensionMap().get(Formats.ProvFormat.PDF), this.maxStringLength), Formats.ProvFormat.PNG, () -> new org.openprovenance.prov.dot.ProvSerialiser(this.pFactory, this.interopFramework.getExtensionMap().get(Formats.ProvFormat.PNG), this.maxStringLength), Formats.ProvFormat.DOT, () -> new org.openprovenance.prov.dot.ProvSerialiser(this.pFactory, this.interopFramework.getExtensionMap().get(Formats.ProvFormat.DOT), this.maxStringLength)));
        return serializer;
    }

    void setMaxStringLength(Integer maxStringLength) {
        this.maxStringLength = maxStringLength;
        this.serializerMap.put(Formats.ProvFormat.SVG, () -> new org.openprovenance.prov.dot.ProvSerialiser(this.pFactory, this.interopFramework.getExtensionMap().get(Formats.ProvFormat.SVG), maxStringLength));
    }

    public void writeDocument(OutputStream os, Document document, Formats.ProvFormat format) {
        this.writeDocument(os, document, this.interopFramework.getMimeTypeMap().get(format), true);
    }

    public void writeDocument(String filename, Document document, Formats.ProvFormat format) {
        try {
            this.writeDocument(Files.newOutputStream(Paths.get(filename, new String[0]), new OpenOption[0]), document, format);
        }
        catch (IOException e) {
            throw new InteropException(e);
        }
    }

    public void writeDocument(OutputStream out, Document document, String mediaType, boolean formatted) {
        Formats.ProvFormat format = this.interopFramework.getMimeTypeRevMap().get(mediaType);
        if (format == null) {
            throw new InteropException("InteropFramework(): serialisedDocument unknown mediatype " + mediaType);
        }
        SerializerFunction serializerMaker = this.serializerMap.get(format);
        InteropFramework.logger.debug("serializer " + String.valueOf(format) + " " + String.valueOf(serializerMaker));
        serializerMaker.apply().serialiseDocument(out, document, formatted);
    }
}

