/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.interop;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Variant;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.generator.GeneratorDetails;
import org.openprovenance.prov.generator.GraphGenerator;
import org.openprovenance.prov.interop.CommandLineArguments;
import org.openprovenance.prov.interop.DeserializerFunction;
import org.openprovenance.prov.interop.DeserializerFunction2;
import org.openprovenance.prov.interop.Inputer;
import org.openprovenance.prov.interop.InteropException;
import org.openprovenance.prov.interop.Outputer;
import org.openprovenance.prov.model.DateTimeOption;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.DocumentEquality;
import org.openprovenance.prov.model.IndexedDocument;
import org.openprovenance.prov.model.ProvDocumentWriter;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.exception.DocumentedUnsupportedCaseException;
import org.openprovenance.prov.model.interop.Formats;
import org.openprovenance.prov.model.interop.Framework;
import org.openprovenance.prov.model.interop.InteropMediaType;
import org.openprovenance.prov.rules.Rules;
import org.openprovenance.prov.template.compiler.BindingsBeanGenerator;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.TemplatesProjectConfiguration;
import org.openprovenance.prov.template.expander.Expand;
import org.openprovenance.prov.template.json.Bindings;

public class InteropFramework
implements InteropMediaType,
ProvDocumentWriter,
Framework {
    public static final String configFile = "config.interop.properties";
    public static final String configuration;
    public static final String factoryClass;
    public static final ProvFactory defaultFactory;
    private final Outputer outputer;
    private final Inputer inputer;
    static Logger logger;
    public static final String UNKNOWN = "unknown";
    final ProvFactory pFactory;
    private final Hashtable<Formats.ProvFormat, String> extensionMap;
    public final Hashtable<String, Formats.ProvFormat> extensionRevMap;
    private final Hashtable<Formats.ProvFormat, String> mimeTypeMap;
    public final Hashtable<String, Formats.ProvFormat> mimeTypeRevMap;
    private final Hashtable<Formats.ProvFormat, Formats.ProvFormatType> provTypeMap;
    private final CommandLineArguments config;
    private final Map<Formats.ProvFormat, DeserializerFunction> deserializerMap;
    private final Map<Formats.ProvFormat, DeserializerFunction2> deserializerMap2;

    static ProvFactory dynamicallyLoadFactory(String factory) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(factory);
            Method method = clazz.getMethod("getFactory", new Class[0]);
            return (ProvFactory)method.invoke((Object)new Object[0], new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ProvFactory getDefaultFactory() {
        return defaultFactory;
    }

    public ProvFactory getFactory() {
        return defaultFactory;
    }

    public InteropFramework() {
        this(new CommandLineArguments(), defaultFactory);
    }

    public InteropFramework(ProvFactory pFactory) {
        this(new CommandLineArguments(), pFactory);
    }

    public InteropFramework(CommandLineArguments config, ProvFactory pFactory) {
        this.pFactory = pFactory;
        this.config = config;
        this.extensionMap = new Hashtable();
        this.extensionRevMap = new Hashtable();
        this.mimeTypeMap = new Hashtable();
        this.mimeTypeRevMap = new Hashtable();
        this.provTypeMap = new Hashtable();
        this.initializeExtensionMap(this.extensionMap, this.extensionRevMap);
        this.outputer = new Outputer(this, pFactory);
        this.inputer = new Inputer(this, pFactory);
        this.deserializerMap = this.inputer.deserializerMap;
        this.deserializerMap2 = this.inputer.deserializerMap2;
    }

    public CommandLineArguments getConfig() {
        return this.config;
    }

    public String buildAcceptHeader() {
        StringBuilder mimetypes = new StringBuilder();
        Enumeration<Formats.ProvFormat> e = this.mimeTypeMap.keys();
        String sep = "";
        while (e.hasMoreElements()) {
            Formats.ProvFormat f = e.nextElement();
            if (!this.isInputFormat(f).booleanValue()) continue;
            mimetypes.append(sep);
            sep = ",";
            mimetypes.append(this.mimeTypeMap.get(f));
        }
        mimetypes.append(sep);
        mimetypes.append("*/*;q=0.1");
        return mimetypes.toString();
    }

    public URLConnection connectWithRedirect(URL theURL) throws IOException {
        URLConnection conn = null;
        String accept_header = this.buildAcceptHeader();
        int redirect_count = 0;
        boolean done = false;
        while (!done) {
            if (theURL.getProtocol().equals("file")) {
                return null;
            }
            boolean isHttp = theURL.getProtocol().equals("http") || theURL.getProtocol().equals("https");
            logger.debug("Requesting: " + String.valueOf(theURL));
            conn = theURL.openConnection();
            if (isHttp) {
                logger.debug("Accept: " + accept_header);
                conn.setRequestProperty("Accept", accept_header);
            }
            conn.setConnectTimeout(60000);
            conn.setReadTimeout(60000);
            conn.connect();
            done = true;
            if (!isHttp) continue;
            logger.debug("Response: " + conn.getHeaderField(0));
            int rc = ((HttpURLConnection)conn).getResponseCode();
            if (rc == 301 || rc == 302 || rc == 303 || rc == 307) {
                if (redirect_count > 10) {
                    return null;
                }
                ++redirect_count;
                String loc = conn.getHeaderField("Location");
                if (loc != null) {
                    theURL = new URL(loc);
                    done = false;
                    continue;
                }
                return null;
            }
            if (rc >= 200 && rc < 300) continue;
            return null;
        }
        return conn;
    }

    public String convertExtensionToMediaType(String extension) {
        Formats.ProvFormat format = this.extensionRevMap.get(extension);
        if (format == null) {
            return null;
        }
        return this.mimeTypeMap.get(format);
    }

    public String getExtension(Formats.ProvFormat format) {
        String extension = UNKNOWN;
        if (format != null) {
            extension = this.extensionMap.get(format);
        }
        return extension;
    }

    String getOption(String[] options, int index) {
        if (options != null && options.length > index) {
            return options[index];
        }
        return null;
    }

    public Formats.ProvFormat getTypeForFile(String filename) {
        int count = filename.lastIndexOf(".");
        if (count == -1) {
            return null;
        }
        String extension = filename.substring(count + 1);
        return this.extensionRevMap.get(extension);
    }

    public Formats.ProvFormat getTypeForFormat(String format) {
        Formats.ProvFormat result = this.mimeTypeRevMap.get(format);
        if (result == null) {
            result = this.extensionRevMap.get(format);
        }
        return result;
    }

    public List<Variant> getVariants() {
        ArrayList<Variant> vs = new ArrayList<Variant>();
        for (Map.Entry<String, Formats.ProvFormat> entry : this.mimeTypeRevMap.entrySet()) {
            if (!this.isOutputFormat(entry.getValue()).booleanValue()) continue;
            String[] parts = entry.getKey().split("/");
            MediaType m = new MediaType(parts[0], parts[1]);
            vs.add(new Variant(m, (Locale)null, null));
        }
        return vs;
    }

    public void initializeExtensionMap(Hashtable<Formats.ProvFormat, String> extensionMap, Hashtable<String, Formats.ProvFormat> extensionRevMap) {
        block11: for (Formats.ProvFormat f : Formats.ProvFormat.values()) {
            switch (f) {
                case DOT: {
                    extensionMap.put(Formats.ProvFormat.DOT, "dot");
                    extensionRevMap.put("dot", Formats.ProvFormat.DOT);
                    extensionRevMap.put("gv", Formats.ProvFormat.DOT);
                    this.mimeTypeMap.put(Formats.ProvFormat.DOT, "text/vnd.graphviz");
                    this.mimeTypeRevMap.put("text/vnd.graphviz", Formats.ProvFormat.DOT);
                    this.provTypeMap.put(Formats.ProvFormat.DOT, Formats.ProvFormatType.OUTPUT);
                    continue block11;
                }
                case JPEG: {
                    extensionMap.put(Formats.ProvFormat.JPEG, "jpg");
                    extensionRevMap.put("jpeg", Formats.ProvFormat.JPEG);
                    extensionRevMap.put("jpg", Formats.ProvFormat.JPEG);
                    this.mimeTypeMap.put(Formats.ProvFormat.JPEG, "image/jpeg");
                    this.mimeTypeRevMap.put("image/jpeg", Formats.ProvFormat.JPEG);
                    this.provTypeMap.put(Formats.ProvFormat.JPEG, Formats.ProvFormatType.OUTPUT);
                    continue block11;
                }
                case PNG: {
                    extensionMap.put(Formats.ProvFormat.PNG, "png");
                    extensionRevMap.put("png", Formats.ProvFormat.PNG);
                    this.mimeTypeMap.put(Formats.ProvFormat.PNG, "image/png");
                    this.mimeTypeRevMap.put("image/png", Formats.ProvFormat.PNG);
                    this.provTypeMap.put(Formats.ProvFormat.PNG, Formats.ProvFormatType.OUTPUT);
                    continue block11;
                }
                case JSON: {
                    extensionMap.put(Formats.ProvFormat.JSON, "json");
                    extensionRevMap.put("json", Formats.ProvFormat.JSON);
                    this.mimeTypeMap.put(Formats.ProvFormat.JSON, "application/json");
                    this.mimeTypeRevMap.put("application/json", Formats.ProvFormat.JSON);
                    this.provTypeMap.put(Formats.ProvFormat.JSON, Formats.ProvFormatType.INPUTOUTPUT);
                    continue block11;
                }
                case PDF: {
                    extensionMap.put(Formats.ProvFormat.PDF, "pdf");
                    extensionRevMap.put("pdf", Formats.ProvFormat.PDF);
                    this.mimeTypeMap.put(Formats.ProvFormat.PDF, "application/pdf");
                    this.mimeTypeRevMap.put("application/pdf", Formats.ProvFormat.PDF);
                    this.provTypeMap.put(Formats.ProvFormat.PDF, Formats.ProvFormatType.OUTPUT);
                    continue block11;
                }
                case PROVN: {
                    extensionMap.put(Formats.ProvFormat.PROVN, "provn");
                    extensionRevMap.put("provn", Formats.ProvFormat.PROVN);
                    this.mimeTypeMap.put(Formats.ProvFormat.PROVN, "text/provenance-notation");
                    this.mimeTypeRevMap.put("text/provenance-notation", Formats.ProvFormat.PROVN);
                    this.provTypeMap.put(Formats.ProvFormat.PROVN, Formats.ProvFormatType.INPUTOUTPUT);
                    continue block11;
                }
                case SVG: {
                    extensionMap.put(Formats.ProvFormat.SVG, "svg");
                    extensionRevMap.put("svg", Formats.ProvFormat.SVG);
                    this.mimeTypeMap.put(Formats.ProvFormat.SVG, "image/svg+xml");
                    this.mimeTypeRevMap.put("image/svg+xml", Formats.ProvFormat.SVG);
                    this.provTypeMap.put(Formats.ProvFormat.SVG, Formats.ProvFormatType.OUTPUT);
                    continue block11;
                }
                case JSONLD: {
                    extensionMap.put(Formats.ProvFormat.JSONLD, "jsonld");
                    extensionRevMap.put("jsonld", Formats.ProvFormat.JSONLD);
                    this.mimeTypeMap.put(Formats.ProvFormat.JSONLD, "application/ld+json");
                    this.mimeTypeRevMap.put("application/ld+json", Formats.ProvFormat.JSONLD);
                    this.provTypeMap.put(Formats.ProvFormat.JSONLD, Formats.ProvFormatType.INPUTOUTPUT);
                    continue block11;
                }
                case PROVX: {
                    extensionMap.put(Formats.ProvFormat.PROVX, "provx");
                    extensionRevMap.put("provx", Formats.ProvFormat.PROVX);
                    extensionRevMap.put("xml", Formats.ProvFormat.PROVX);
                    this.mimeTypeMap.put(Formats.ProvFormat.PROVX, "application/provenance+xml");
                    this.mimeTypeRevMap.put("application/provenance+xml", Formats.ProvFormat.PROVX);
                    this.provTypeMap.put(Formats.ProvFormat.PROVX, Formats.ProvFormatType.INPUTOUTPUT);
                    continue block11;
                }
            }
        }
    }

    public Boolean isInputFormat(Formats.ProvFormat format) {
        Formats.ProvFormatType t = this.provTypeMap.get(format);
        return t.equals((Object)Formats.ProvFormatType.INPUT) || t.equals((Object)Formats.ProvFormatType.INPUTOUTPUT);
    }

    public Boolean isOutputFormat(Formats.ProvFormat format) {
        Formats.ProvFormatType t = this.provTypeMap.get(format);
        return t.equals((Object)Formats.ProvFormatType.OUTPUT) || t.equals((Object)Formats.ProvFormatType.INPUTOUTPUT);
    }

    public List<Map<String, String>> getSupportedFormats() {
        ArrayList<Map<String, String>> tripleList = new ArrayList<Map<String, String>>();
        for (Formats.ProvFormat pt : this.provTypeMap.keySet()) {
            for (String mt : this.mimeTypeRevMap.keySet()) {
                if (this.mimeTypeRevMap.get(mt) != pt) continue;
                for (String ext : this.extensionRevMap.keySet()) {
                    HashMap<String, String> trip;
                    if (this.extensionRevMap.get(ext) != pt) continue;
                    if (this.isInputFormat(pt).booleanValue()) {
                        trip = new HashMap<String, String>();
                        trip.put("extension", ext);
                        trip.put("mediatype", mt);
                        trip.put("type", "input");
                        tripleList.add(trip);
                    }
                    if (!this.isOutputFormat(pt).booleanValue()) continue;
                    trip = new HashMap();
                    trip.put("extension", ext);
                    trip.put("mediatype", mt);
                    trip.put("type", "output");
                    tripleList.add(trip);
                }
            }
        }
        return tripleList;
    }

    public int run() {
        Document doc;
        if (this.config.config) {
            String classpath = System.getProperty("java.class.path");
            System.out.println("provconvert.classpath=" + classpath);
            System.out.println("provconvert.main=" + CommandLineArguments.class.getName());
            return 0;
        }
        if (this.config.outfile == null && this.config.compare == null && this.config.template_builder == null && this.config.metrics == null) {
            return 3;
        }
        if (this.config.infile == null && this.config.generator == null && this.config.template_builder == null && this.config.merge == null) {
            return 2;
        }
        if (Objects.equals(this.config.infile, "-") && Objects.equals(this.config.bindings, "-")) {
            throw new InteropException("Cannot use standard input for both infile and bindings");
        }
        if (this.config.infile != null && this.config.log2prov == null) {
            try {
                doc = this.inputer.readDocument(this.config.infile, this.config.informat);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.config.merge != null) {
            IndexedDocument iDoc = new IndexedDocument(this.pFactory, this.pFactory.newDocument(), this.config.flatten != null);
            try {
                List<Inputer.ToRead> files = this.config.merge.equals("-") ? this.inputer.readIndexFile(System.in) : this.inputer.readIndexFile(new File(this.config.merge));
                for (Inputer.ToRead something : files) {
                    iDoc.merge(this.inputer.readDocument(something));
                }
            }
            catch (IOException e) {
                System.err.println("problem reading index file");
                e.printStackTrace();
            }
            doc = iDoc.toDocument();
        } else {
            if (this.config.template_builder != null) {
                ConfigProcessor cp = new ConfigProcessor(this.pFactory);
                return cp.processTemplateGenerationConfig(this.config.template_builder, ".", ".", this.pFactory);
            }
            if (this.config.log2prov != null) {
                try {
                    Class<?> clazz = Class.forName(this.config.log2prov);
                    Method method = clazz.getMethod("main", String[].class);
                    try {
                        if (this.config.log2kernel) {
                            List<String> init = List.of("kernel", "-infile", this.config.infile, "-outfile", this.config.outfile);
                            LinkedList<String> ll = new LinkedList<String>(init);
                            Map<String, String> env = System.getenv();
                            String tmp = env.get("LEVEL_OFFSET");
                            if (tmp != null && !tmp.isEmpty()) {
                                ll.add("-levelOffset");
                                ll.add(tmp);
                            }
                            if ((tmp = env.get("LEVEL_NUMBER")) != null && !tmp.isEmpty()) {
                                ll.add("-levelNumber");
                                ll.add(tmp);
                            }
                            if ((tmp = env.get("SET_OFFSET")) != null && !tmp.isEmpty()) {
                                ll.add("-setOffset");
                                ll.add(tmp);
                            }
                            if ((tmp = env.get("RELATION_OFFSET")) != null && !tmp.isEmpty()) {
                                ll.add("-relationOffset");
                                ll.add(tmp);
                            }
                            if ((tmp = env.get("KNOWN_TYPES")) != null && !tmp.isEmpty()) {
                                ll.add("-knownTypes");
                                ll.add(tmp);
                            }
                            if ((tmp = env.get("KNOWN_RELATIONS")) != null && !tmp.isEmpty()) {
                                ll.add("-knownRelations");
                                ll.add(tmp);
                            }
                            if ((tmp = env.get("TRANSLATION")) != null && !tmp.isEmpty()) {
                                ll.add("-translation");
                                ll.add(tmp);
                            }
                            if ((tmp = env.get("ADDLEVEL0")) != null && !tmp.isEmpty()) {
                                ll.add("-addlevel0");
                                ll.add(tmp);
                            }
                            if ((tmp = env.get("PROPERTY_CONVERTERS")) != null && !tmp.isEmpty()) {
                                ll.add("-propertyConverters");
                                ll.add(tmp);
                            }
                            logger.debug("log2kernel " + String.valueOf(ll));
                            method.invoke(null, new Object[]{ll.toArray(new String[0])});
                        } else {
                            method.invoke(null, new Object[]{new String[]{this.config.infile, this.config.outfile, "-merge"}});
                        }
                        return 0;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        return -1;
                    }
                }
                catch (ClassNotFoundException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
                    e.printStackTrace();
                    return -1;
                }
            }
            String[] options = this.config.generator.split(":");
            String noOfNodes = this.getOption(options, 0);
            String noOfEdges = this.getOption(options, 1);
            String firstNode = this.getOption(options, 2);
            String namespace = "http://expample.org/";
            String seed = this.getOption(options, 3);
            String term = this.getOption(options, 4);
            if (term == null) {
                term = "e1";
            }
            GeneratorDetails gd = new GeneratorDetails(Integer.parseInt(noOfNodes), Integer.parseInt(noOfEdges), firstNode, namespace, seed == null ? null : Long.valueOf(seed), term);
            System.err.println(gd);
            GraphGenerator gg = new GraphGenerator(gd, this.pFactory);
            gg.generateElements();
            doc = gg.getDetails().getDocument();
        }
        if (this.config.metrics != null) {
            Object data = new Rules().getMetrics(doc, this.pFactory);
            try {
                new ObjectMapper().writeValue(new File(this.config.metrics), data);
                return 0;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.config.compare != null) {
            try {
                return this.doCompare(doc, this.inputer.readDocument(this.config.compare, this.config.informat));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.config.template != null && !this.config.builder) {
            BindingsBeanGenerator bbgen = new BindingsBeanGenerator(this.pFactory);
            boolean val = bbgen.generate(doc, this.config.template, this.config.packge, this.config.outfile, this.config.location);
            return val ? 0 : 7;
        }
        if (this.config.template != null && this.config.builder) {
            ConfigProcessor cp = new ConfigProcessor(this.pFactory);
            if (this.config.bindings != null) {
                if (this.config.bindingsVersion >= 3) {
                    try {
                        TemplatesProjectConfiguration configs = new TemplatesProjectConfiguration();
                        Locations locations = new Locations(configs, null, null);
                        cp.generate(doc, locations, this.config.template, this.config.packge, this.config.outfile, this.config.location, this.config.location, "schema.json", "documentation.html", cp.readTree(new File(this.config.bindings)), cp.getBindingsSchema(this.config.bindings), null, this.config.location + "/src/main/resources/project/version/", false, new LinkedList(), null, null);
                        return 0;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    throw new DocumentedUnsupportedCaseException("bindings version number < 3: " + this.config.bindingsVersion);
                }
            }
        }
        if (this.config.index != null) {
            doc = new IndexedDocument(this.pFactory, doc, this.config.flatten != null).toDocument();
        }
        try {
            if (this.config.bindings != null) {
                Bindings inBindings;
                Expand myExpand = new Expand(this.pFactory, this.config.addOrderp, this.config.allExpanded);
                if (this.config.bindingsVersion == 3) {
                    try {
                        inBindings = (Bindings)new ObjectMapper().readValue(new File(this.config.bindings), Bindings.class);
                    }
                    catch (IOException e) {
                        throw new InteropException("problem parsing bindings file " + this.config.bindings, e);
                    }
                } else {
                    throw new DocumentedUnsupportedCaseException("bindings version number <> 3: " + this.config.bindingsVersion);
                }
                Document expanded = myExpand.expander(doc, inBindings);
                boolean flag = myExpand.getAllExpanded();
                this.outputer.writeDocumentToFileOrDefaultOutput(this.config.outfile, expanded, this.config.outformat);
                if (!flag) {
                    return 7;
                }
            } else {
                this.outputer.writeDocumentToFileOrDefaultOutput(this.config.outfile, doc, this.config.outformat);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    private int doCompare(Document doc1, Document doc2) {
        if (doc1 == null) {
            return 4;
        }
        if (doc2 == null) {
            return 5;
        }
        PrintStream ps = System.out;
        try {
            if (this.config.compareOut != null && !this.config.compareOut.equals("-")) {
                ps = new PrintStream(this.config.compareOut);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        DocumentEquality comparator = new DocumentEquality(false, ps);
        logger.debug("about to compare two docs");
        if (comparator.check(doc1, doc2)) {
            return 0;
        }
        return 6;
    }

    public void setMaxStringLength(Integer maxStringLength) {
        this.outputer.setMaxStringLength(maxStringLength);
    }

    public void writeDocument(String filename, Document document) {
        this.outputer.writeDocument(filename, document);
    }

    public void writeDocument(String filename, Document document, Formats.ProvFormat format) {
        this.outputer.writeDocument(filename, document, format);
    }

    public void writeDocument(OutputStream os, Document document, Formats.ProvFormat format) {
        this.outputer.writeDocument(os, document, format);
    }

    public void writeDocument(OutputStream out, Document document, String mediaType, boolean formatted) {
        this.outputer.writeDocument(out, document, mediaType, formatted);
    }

    public Collection<String> mediaTypes() {
        return this.mimeTypeRevMap.keySet();
    }

    public Hashtable<Formats.ProvFormat, String> getExtensionMap() {
        return this.extensionMap;
    }

    public Hashtable<Formats.ProvFormat, String> getMimeTypeMap() {
        return this.mimeTypeMap;
    }

    public Hashtable<String, Formats.ProvFormat> getMimeTypeRevMap() {
        return this.mimeTypeRevMap;
    }

    public Map<Formats.ProvFormat, DeserializerFunction> getDeserializerMap() {
        return this.deserializerMap;
    }

    public Map<Formats.ProvFormat, DeserializerFunction2> getDeserializerMap2() {
        return this.deserializerMap2;
    }

    public Document readDocument(InputStream is, Formats.ProvFormat format) throws IOException {
        return this.inputer.deserialiseDocument(is, format);
    }

    public Document readDocument(InputStream is, Formats.ProvFormat format, DateTimeOption dateTimeOption, TimeZone timeZone) throws IOException {
        return this.inputer.deserialiseDocument(is, format, dateTimeOption, timeZone);
    }

    public Document readDocumentFromFile(String filename, DateTimeOption dateTimeOption, TimeZone timeZone) {
        return this.inputer.readDocumentFromFile(filename, dateTimeOption, timeZone);
    }

    public Document readDocumentFromFileWithUnknownType(String filename) {
        return this.inputer.readDocumentFromFileWithUnknownType(filename);
    }

    public Document readDocumentFromFileWithUnknownType(String filename, DateTimeOption dateTimeOption, TimeZone timeZone) {
        return this.inputer.readDocumentFromFileWithUnknownType(filename, dateTimeOption, timeZone);
    }

    public Document readDocumentFromURL(String url) {
        return this.inputer.readDocumentFromURL(url);
    }

    public Document readDocumentFromFile(String filename) {
        return this.inputer.readDocumentFromFile(filename);
    }

    static {
        Properties properties = Framework.getPropertiesFromClasspath((String)configFile);
        configuration = (String)properties.get("interop.config");
        factoryClass = properties.getProperty("prov.factory");
        defaultFactory = InteropFramework.dynamicallyLoadFactory(factoryClass);
        logger = LogManager.getLogger(InteropFramework.class);
    }
}

