/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import org.openprovenance.prov.json.ProvDocumentDeserializer;
import org.openprovenance.prov.json.ProvDocumentSerializer;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.exception.UncheckedException;

public class Converter {
    private final ProvFactory pFactory;
    private final Gson gson;
    final Class class1;

    public Converter(ProvFactory pFactory) {
        this.pFactory = pFactory;
        this.class1 = pFactory.newDocument().getClass();
        this.gson = new GsonBuilder().registerTypeAdapter((Type)this.class1, (Object)new ProvDocumentDeserializer(pFactory)).registerTypeAdapter((Type)this.class1, (Object)new ProvDocumentSerializer(pFactory)).setPrettyPrinting().create();
    }

    public Document readDocument(String file) throws JsonSyntaxException, JsonIOException, IOException {
        BufferedReader buf = new BufferedReader(new FileReader(file));
        Document doc = (Document)this.gson.fromJson((Reader)buf, this.class1);
        buf.close();
        return doc;
    }

    public Document readDocument(InputStream is) throws JsonSyntaxException, JsonIOException, IOException {
        BufferedReader buf = new BufferedReader(new InputStreamReader(is));
        Document doc = (Document)this.gson.fromJson((Reader)buf, this.class1);
        buf.close();
        return doc;
    }

    public void writeDocument(Document doc, String file) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        this.gson.toJson((Object)doc, (Appendable)writer);
        writer.close();
    }

    public void writeDocument(Document doc, Writer out) throws IOException {
        BufferedWriter writer = new BufferedWriter(out);
        this.gson.toJson((Object)doc, (Appendable)writer);
        writer.close();
    }

    public void writeDocument(Document doc, OutputStream out) {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        this.gson.toJson((Object)doc, (Appendable)writer);
        try {
            writer.close();
        }
        catch (IOException e) {
            throw new UncheckedException((Exception)e);
        }
    }

    public String getString(Document doc) {
        return this.gson.toJson((Object)doc);
    }

    public Document fromString(String jsonStr) {
        return (Document)this.gson.fromJson(jsonStr, this.class1);
    }
}

